/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.Result;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.neeq.view.NeeqTradeBasePart;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class NeeqTradeExecutePart
extends NeeqTradeBasePart {
    @Inject
    private NewInstructionModel insModel;
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (this.neeqModel.isUpLimit() && !newV.booleanValue() && this.neeqModel.getPrice() > this.instruction.getOrderDetail().getPrice()) {
            this.neeqModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.neeqModel.isDownLimit() && !newV.booleanValue() && this.neeqModel.getPrice() < this.instruction.getOrderDetail().getPrice()) {
            this.neeqModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    @Inject
    public NeeqTradeExecutePart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.partType = "3";
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.neeqModel.create("3");
        this.setConfirmSymbol("\u6307\u4ee4\u6267\u884c");
        this.onApprove(false);
        super.initialize();
        this.neeqModel.getAccDisModel().setShowCanBuy(false);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished.set(true);
        this.doFill();
        this.lbCan.visibleProperty().unbind();
        this.lbCanCount.visibleProperty().unbind();
        this.lbCan.setVisible(false);
        this.lbCanCount.setVisible(false);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.isLimitPrice() || this.neeqModel.isSpecify() || this.neeqModel.getAccDisModel().isActive(), (Observable[])new Observable[]{this.neeqModel.priceStgProperty(), this.neeqModel.priceTypeLimitedStgProperty(), this.neeqModel.getAccDisModel().activeProperty()}));
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail"}) && ins.getIsOrderStep();
    }

    @Override
    protected void submitOrder() {
        super.submitOrder();
        this.clearInfo();
    }

    @Override
    protected Result doAction() throws MException {
        return this.neeqModel.submit((TreeItem<CcsAccountDistribution>)this.neeqModel.getAccDisModel().getRoot(), this.instruction);
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    @Override
    public void setPrice(double price) {
        if (this.neeqModel.isLimitPrice() && !this.neeqModel.isSpecify() && price > 0.0) {
            this.neeqModel.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    private void modifyQuantity() {
        long effectiveQuantity = this.instruction.getAvailOrderQty();
        if (this.neeqModel.getCount() > effectiveQuantity) {
            this.neeqModel.setCount(effectiveQuantity);
            this.quantitySpn.getEditor().requestFocus();
            this.quantitySpn.getEditor().selectAll();
        }
    }
}

