/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleNoZeroSpinnerCtrl;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateReq;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateResp;
import cms.tmx.entity.web.workflow.WorkflowBusinessType;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.neeq.model.NeeqTradeBaseModel;
import cms.tmx.neeq.model.UserPreCtrl;
import cms.tmx.neeq.view.LoadPartModel;
import cms.tmx.neeq.view.NeeqEntrustConfirmDialog;
import cms.tmx.neeq.view.NeeqSelectWorkflowDialog;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class NeeqTradeBasePart
extends MxPart {
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Double> protectedPriceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    protected Label lbMarketMakerCount;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label priceMag;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private StackPane stkPaneCommon;
    @FXML
    private HBox hBoxDistStg;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    protected Button btnOrder;
    @FXML
    private Label lbTransferMethod;
    @FXML
    private Label lbLevelInfo;
    @FXML
    private ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    private TextField txtSearch;
    @FXML
    protected CheckBox checkBoxModify;
    @FXML
    protected HBox hboxProtectedPrice;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected INewRefMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected NeeqTradeBaseModel neeqModel;
    @Inject
    protected UserPreCtrl preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    @Inject
    private WorkflowTemplateApi workflowTemplateApi;
    @Inject
    private IBaseApi baseApi;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u975e\u6302\u724c\u80a1\u7968";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    protected String confirmSymbol = "";
    private MEvent pstEvent = new MEvent();
    protected boolean isInstructionEvent = false;
    private boolean isPstEvent = false;
    protected boolean priceSettle = false;
    protected String partType = "";
    protected ObSimpleInstruction instruction = null;
    @FXML
    private Label lbUpDownPrice;
    @Inject
    private CcsUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    protected Map<String, List<CcsOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 11, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    protected DoubleNoZeroSpinnerCtrl ctrlProctedPrice = new DoubleNoZeroSpinnerCtrl(true, 6, 2);
    protected SecSuggest spCode = new SecSuggest();
    private MEventHandler hSetPst = event -> {
        this.txtCode.requestFocus();
        if (this.txtCode.isFocused()) {
            this.txtCode.setText(event.getStr("sec_code"));
        }
        this.pstEvent = event;
        this.isPstEvent = true;
        if (this.txtCode.getText().equals(event.getStr("sec_code"))) {
            this.neeqModel.setCount(this.pstEvent.getInt("count"));
            this.neeqModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.neeqModel.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
            this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
        }
    };
    private InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    protected boolean tabChange = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(NeeqTradeBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> NeeqTradeBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        NeeqTradeBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                NeeqTradeBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> NeeqTradeBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public NeeqTradeBasePart() {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.exe.execute(() -> {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                this.logger.error("\u521d\u59cb\u5316\u4ea4\u6613\u9762\u677f\u67e5\u8be2\u59d4\u6258\u5931\u8d25", (Throwable)e);
            }
            this.unfinishedModel.query();
        });
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("trade.panel.set.code", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.mktItem = this.neeqModel.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.mktItem.changedProperty().addListener(ob -> Platform.runLater(() -> this.onMktItemChange()));
        this.refMng.changedProperty().addListener(this.listener);
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code", this.hSetPst);
        this.es.subscribe("stock_ref_new", event -> {
            if (this.mktItem.getRefItem() == null || !(event.getObj() instanceof RefItem)) {
                return;
            }
            if (!((RefItem)RefItem.class.cast(event.getObj())).getCode().equals(this.mktItem.getRefItem().getCode())) {
                return;
            }
            Platform.runLater(() -> this.doChange(this.mktItem.getRefItem(), this.mktItem.getRefItem().getCode()));
        });
    }

    protected Collection<RefItem> getRefItems() {
        Collection items = this.refMng.getItems(new String[]{"STOCK"});
        List<String> levelList = Arrays.asList("\u57fa\u7840\u5c42", "\u7cbe\u9009\u5c42", "\u521b\u65b0\u5c42");
        List<String> methodList = Arrays.asList("B", "C", "M");
        return items.stream().filter(item -> levelList.contains(item.getLevelInfo()) && methodList.contains(item.getTransferMethodCode())).collect(Collectors.toList());
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.onSecurityChange(this.txtCode, (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.neeqModel.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.neeqModel.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.setSelected(true);
        this.cmbPriceType.setItems(this.neeqModel.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.neeqModel.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.cmbPriceTypeLimited.setItems(this.neeqModel.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.neeqModel.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, newV) -> this.onPriceTypeLimitedChange((MxNode)newV));
        this.cmbPriceTypeMkt.setItems(this.neeqModel.getPriceTypeMktStg().getNodes());
        this.cmbPriceTypeMkt.valueProperty().bindBidirectional(this.neeqModel.priceTypeMktStgProperty());
        this.cmbPriceTypeBidAsk.setItems(this.neeqModel.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.neeqModel.priceTypeBidAskStgProperty());
        this.cmbPriceTypeAfterHours.setItems(this.neeqModel.getPriceTypeAfterHours().getNodes());
        this.cmbPriceTypeAfterHours.valueProperty().bindBidirectional(this.neeqModel.priceTypeAfterHoursProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.neeqModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setText("");
        this.ctrlProctedPrice.ctrl(this.protectedPriceSpn);
        MxBindings.bindSD((Property)this.protectedPriceSpn.getEditor().textProperty(), (Property)this.neeqModel.priceProtectedProperty());
        this.protectedPriceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.protectedPriceSpn.getEditor().setText("");
        this.priceDisableBind();
        this.priceVisibleBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.moneySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.quantitySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.priceMag, (TextField)this.priceSpn.getEditor());
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.neeqModel.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.neeqModel.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.neeqModel.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.neeqModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.countStg.setItems(this.neeqModel.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange());
        this.countStg.valueProperty().bindBidirectional(this.neeqModel.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().is("1"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().is("3") || this.neeqModel.getCountStg().is("2") || this.neeqModel.getCountStg().is("4"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.neeqModel.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.neeqModel.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%1$,.2f", this.neeqModel.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.neeqModel.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.lbUpLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.neeqModel.isBond() && this.neeqModel.isValidRef() && this.mktItem.getUpLimitPrice() != 0.0, (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbDownLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.neeqModel.isBond() && this.neeqModel.isValidRef() && this.mktItem.getDownLimitPrice() != 0.0, (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        TableUtils.beforeClick(this.tableMarketBuy, item -> this.onMktItemClicked((HandicapInfo)item));
        TableUtils.beforeClick(this.tableMarketSell, item -> this.onMktItemClicked((HandicapInfo)item));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbRate.textProperty());
        this.lbRate.setTooltip(tooltip);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected boolean onMktItemClicked(HandicapInfo now) {
        this.setPrice(now.getPrice());
        return false;
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(true);
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.neeqModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.neeqModel.distStgProperty());
        this.cmbAccFilter.setItems(this.neeqModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.neeqModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.neeqModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.neeqModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.neeqModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(p -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().newAssetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.neeqModel.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(p -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.neeqModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.neeqModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.neeqModel.countStgProperty().addListener(ob -> {
            String stg = this.neeqModel.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onRefChange() {
        if (this.mktItem.getRefItem() == null) {
            this.lbLevelInfo.setText("");
            this.lbTransferMethod.setText("");
        } else {
            this.lbLevelInfo.setText(this.mktItem.getRefItem().getLevelInfo());
            this.lbTransferMethod.setText(this.mktItem.getRefItem().getTransferMethod());
        }
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        this.changeUnit();
    }

    protected void onMktItemChange() {
        if (this.neeqModel.isBidAskPrice()) {
            this.neeqModel.setBidAskPrice();
        }
        this.check();
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    protected void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText(this.buySymbol);
            this.lbCan.setText("\u53ef\u4e70");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText(this.sellSymbol);
            this.lbCan.setText("\u53ef\u5356");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.neeqModel.setBuy(now);
        this.layout();
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    private void onCountStgChange() {
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.neeqModel.isMktPrice() && !this.priceSettle) {
            this.neeqModel.setMktPrice();
            if (this.neeqModel.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.neeqModel.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.neeqModel.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        if (this.neeqModel.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
            this.ctrlProctedPrice.setScale(refItem.getScale());
        }
        this.neeqModel.onSecChange();
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            MEvent event = new MEvent();
            event.put((Object)"code", (Object)this.mktItem.getRefItem().getCode());
            event.put((Object)"market", (Object)this.mktItem.getRefItem().getMarket());
            this.es.postEvent("code_change", event);
        } else {
            this.lbMarketMakerCount.setText("");
        }
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.neeqModel.setCount(this.pstEvent.getInt("count"));
            this.neeqModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.neeqModel.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
            this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
        }
        if (this.neeqModel.isValidRef()) {
            this.checkRepo();
            this.priceSettle = false;
            this.setPrePrice();
        }
        this.layout();
    }

    protected void checkRepo() {
        if ("REPO".equals(this.neeqModel.getValidRef().getType()) || "2".equals(this.partType) || "3".equals(this.partType)) {
            this.countStg.getSelectionModel().selectFirst();
            this.countStg.setDisable(true);
        } else {
            this.countStg.setDisable(false);
        }
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.getCountStg().is("1"), (Observable[])new Observable[]{this.neeqModel.countStgProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.isLimitPrice() || this.neeqModel.isUnlimited(), (Observable[])new Observable[]{this.neeqModel.priceStgProperty(), this.neeqModel.priceTypeLimitedStgProperty()}));
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return true;
            }
            if (!(((MxNode)this.cmbPriceType.getValue()).is("50") || ((MxNode)this.cmbPriceType.getValue()).is("0") || ((MxNode)this.cmbPriceType.getValue()).is("99"))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        this.hboxProtectedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return false;
            }
            if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
                Platform.runLater(() -> this.priceSpn.getEditor().clear());
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
    }

    private void check() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (NeeqTradeBasePart.this.txtCode.getText().length() < 6) {
                    return;
                }
                RefItem ref = NeeqTradeBasePart.this.mktItem.getRefItem();
                if (ref != null && ref.isNeeqQuery() && !StringUtils.isEmpty((String)ref.getCode())) {
                    NeeqTradeBasePart.this.refMng.queryStockInfo(ref);
                }
                Platform.runLater(() -> {
                    if (ref == null || ref.getName().equals("") || NeeqTradeBasePart.this.neeqModel.getValidRef() == null) {
                        NeeqTradeBasePart.this.lbName.setText(NeeqTradeBasePart.INVALID_CODE);
                        NeeqTradeBasePart.this.lbMarketMakerCount.setText("");
                    } else if (ref.isStopFlag()) {
                        NeeqTradeBasePart.this.lbName.setText("\u505c\u724c");
                        NeeqTradeBasePart.this.lbMarketMakerCount.setText("(" + ref.getMarketMakerCount() + ")\u5bb6");
                    } else {
                        if (ref.getOtherBusiness() == null || ref.getOtherBusiness().isEmpty()) {
                            NeeqTradeBasePart.this.lbName.setText(ref.getName());
                        } else {
                            NeeqTradeBasePart.this.lbName.setText(String.valueOf(ref.getName()) + "-" + ref.getOtherBusiness());
                        }
                        NeeqTradeBasePart.this.lbMarketMakerCount.setText("(" + ref.getMarketMakerCount() + ")\u5bb6");
                    }
                });
            }
        };
        timer.schedule(task, 500L);
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
        if (this.neeqModel.isBond()) {
            if (this.neeqModel.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.neeqModel.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.neeqModel.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.neeqModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.neeqModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.neeqModel.getCount() >= 0L && this.neeqModel.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u4fdd\u62a4\u4ef7\u683c\u9700\u8981\u5927\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        return this.alert.check(!this.neeqModel.isMktPrice() || this.neeqModel.getPriceProtected() > 0.0, Alert.AlertType.WARNING, tip6);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.neeqModel.isLimitPrice() || this.neeqModel.isUnlimited() || this.neeqModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.neeqModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.neeqModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            Iterator<WorkflowTemplate> iterator;
            if (this.neeqModel.isMktPrice() && this.mktItem.getUpLimitPrice() > 0.0 && this.neeqModel.getPriceProtected() > this.mktItem.getUpLimitPrice() && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u60a8\u8f93\u5165\u7684\u4fdd\u62a4\u4ef7\u683c\u5927\u4e8e\u6da8\u505c\u4ef7\u683c\uff0c\u662f\u5426\u7ee7\u7eed\u59d4\u6258\uff1f")) {
                return;
            }
            NeeqSelectWorkflowDialog workflowObj = null;
            boolean hasWorkflow = false;
            if ("1".equals(this.neeqModel.getAccDisModel().getInstructType()) || "0".equals(this.neeqModel.getAccDisModel().getInstructType())) {
                for (TreeItem acc : this.neeqModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                    GetWorkflowTemplateReq getWorkflowReq = new GetWorkflowTemplateReq();
                    getWorkflowReq.setOrg(this.baseApi.getPartyId());
                    getWorkflowReq.setUserId(this.baseApi.getUserId());
                    getWorkflowReq.setPostId(this.baseApi.getPostId());
                    getWorkflowReq.setObjType("2");
                    getWorkflowReq.setObjId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
                    getWorkflowReq.setAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                    getWorkflowReq.setAssetClass("1");
                    getWorkflowReq.setMarket(this.mktItem.getRefItem().getMarket());
                    getWorkflowReq.setSecurityId(this.mktItem.getRefItem().getCode());
                    getWorkflowReq.setSecurityType(this.mktItem.getRefItem().getType());
                    getWorkflowReq.setBusinessType(this.buyRadio.isSelected() ? WorkflowBusinessType.TYPE_BUY.getCode() : WorkflowBusinessType.TYPE_SELL.getCode());
                    try {
                        List pick;
                        GetWorkflowTemplateResp getWorkflowResp = this.workflowTemplateApi.getWorkflowTemplate(getWorkflowReq);
                        if (getWorkflowResp.getList() == null || getWorkflowResp.getList().size() == 0 || (pick = getWorkflowResp.getList().stream().filter(item -> this.neeqModel.getAccDisModel().getInstructType().equals(item.getNode().getOrderType())).collect(Collectors.toList())).size() == 0) continue;
                        if (workflowObj == null) {
                            hasWorkflow = true;
                            workflowObj = (NeeqSelectWorkflowDialog)((Object)this.of.create(NeeqSelectWorkflowDialog.class));
                        }
                        workflowObj.getMap().put(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId(), getWorkflowResp.getList());
                    }
                    catch (MException e1) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2 \u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25" + e1.getMessage());
                        return;
                    }
                }
                if (!hasWorkflow) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u60a8\u91cd\u65b0\u8bbe\u7f6e\u6307\u4ee4\u6d41,\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6307\u4ee4\u6d41");
                    return;
                }
                MxDialog workflowDialog = this.df.create(workflowObj, "\u5df2\u5339\u914d\u6307\u4ee4\u6d41\u9009\u62e9");
                workflowObj.init(this.neeqModel.getAccDisModel().getInstructType());
                if (workflowDialog.launch() == ButtonType.OK) {
                    Map<String, WorkflowTemplate> orderMap = workflowObj.getOrderMap();
                    this.neeqModel.setWorkFlowAccountMap(orderMap);
                } else {
                    return;
                }
            }
            List<NewCcsSingleEntrust> entrusts = this.neeqModel.getEntrustList(false);
            NeeqEntrustConfirmDialog obj = (NeeqEntrustConfirmDialog)((Object)this.of.create(NeeqEntrustConfirmDialog.class));
            if (!"4".equals(this.neeqModel.getAccDisModel().getInstructType()) && !"3".equals(this.neeqModel.getAccDisModel().getInstructType())) {
                obj.setInstruction(true);
                if (!"2".equals(this.neeqModel.getAccDisModel().getInstructType())) {
                    Iterator<NewCcsSingleEntrust> iterator2 = entrusts.iterator();
                    while (iterator2.hasNext()) {
                        if (this.neeqModel.getWorkFlowAccountMap().get(iterator2.next().getInvestorId()) != null) continue;
                        iterator2.remove();
                    }
                }
            } else {
                obj.setExecution(true);
            }
            if ((iterator = this.neeqModel.getWorkFlowAccountMap().values().iterator()).hasNext()) {
                WorkflowTemplate workflowTemplate = iterator.next();
                obj.setShowWarning(!"1".equals(workflowTemplate.getNode().getFrozenCapital()));
            }
            obj.setInstructionPanelType(this.neeqModel.getAccDisModel().getInstructType());
            obj.setBuy(this.neeqModel.isBuy());
            obj.setBuySymbol(this.buySymbol);
            obj.setSellSymbol(this.sellSymbol);
            obj.setRefItem(this.mktItem.getRefItem());
            obj.setPriceStg(this.neeqModel.getPriceStg());
            obj.setPriceTypeMktStg(this.neeqModel.getPriceTypeMktStg());
            obj.setPriceTypeLimitedStg(this.neeqModel.getPriceTypeLimitedStg());
            obj.setPriceTypeBidAskStg(this.neeqModel.getPriceTypeBidAskStg());
            obj.setUnit(this.lbUnit.getText());
            obj.setList(entrusts);
            MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                this.submitOrder();
            }
        }
        this.layout();
    }

    protected void submitOrder() {
        Result result = null;
        try {
            result = this.doAction();
            if (result.failed > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14" + result.getReason().toString());
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
            }
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u5931\u8d25" + e.toString());
            this.logger.error(String.valueOf(this.confirmSymbol) + "\u5931\u8d25", (Throwable)e);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error(String.valueOf(this.confirmSymbol) + "\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    protected Result doAction() throws MException {
        return this.neeqModel.submit((TreeItem<CcsAccountDistribution>)this.neeqModel.getAccDisModel().getRoot());
    }

    protected void fillInstruction() throws MException {
        this.initPanel();
        this.neeqModel.setInstruction(this.instruction);
        if (this.instruction.getOrderDetail() == null) {
            return;
        }
        RefItem refItem = this.refMng.getItem(this.instruction.getSecType(), this.instruction.getSecMarket(), this.instruction.getSecurityCode());
        this.txtCode.setUserData((Object)refItem);
        this.doChange(refItem, this.instruction.getSecurityCode());
        if (this.isInstructionEvent && this.getValidRef() != null && "SimpleDetail".equals(this.instruction.getType())) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
    }

    private void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        ExecJob job = null;
        SimpleDetail orderDetail = this.instruction.getOrderDetail();
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            job = (ExecJob)this.instruction.getJobs().get(0);
        }
        long effectiveQuantity = (long)job.getAvailOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.cmbDist.getSelectionModel().select(1);
        this.neeqModel.getAccDisModel().fillAccount(this.instruction);
        String prc = StringUtils.toPriceStr((double)orderDetail.getPrice(), (double)this.getValidRef().getPriceUnit());
        this.lbUpDownPrice.setText(prc);
        this.cmbPriceType.getSelectionModel().select((Object)this.neeqModel.getPriceStg().getNode(orderDetail.getOrdType().getValue()));
        this.setPrice(new BigDecimal(orderDetail.getPrice()).setScale(this.getValidRef().getScale(), 4).doubleValue());
        if (Side.SIDE_SELL.getValue().equals(orderDetail.getSide().getValue()) || Side.SIDE_LEND.getValue().equals(orderDetail.getSide().getValue())) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.neeqModel.getPriceTypeLimitedStg() != null && OrdType.ORD_TYPE_LIMIT.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.neeqModel.getPriceTypeLimitedStg().getNode(Integer.toString(orderDetail.getPriceRestriction())));
        }
        if (this.neeqModel.getPriceTypeMktStg() != null && OrdType.ORD_TYPE_MARKET.getValue().equals(orderDetail.getOrdType().getValue())) {
            String marketType = MarketUtils.getNeeqMarketPriceType((int)orderDetail.getTif().getValue(), (int)orderDetail.getMaxPriceLevels());
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)this.neeqModel.getPriceTypeMktStg().getNode(marketType));
            this.neeqModel.setMktPrice();
        }
        if (this.neeqModel.getPriceTypeBidAskStg() != null && OrdType.ORD_TYPE_UNDEFINED.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)this.neeqModel.getPriceTypeBidAskStg().getNode(Integer.toString(orderDetail.getPlateLevels())));
            this.neeqModel.setBidAskPrice();
        }
        if (this.instruction.getIsOrderStep() && this.neeqModel.isLimitPrice()) {
            if (this.neeqModel.isSpecify()) {
                this.neeqModel.setPrice(orderDetail.getPrice());
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.neeqModel.isLimitPrice()) {
            this.neeqModel.setPrice(orderDetail.getPrice());
        }
        if ("99".equals(orderDetail.getOrdType().getValue())) {
            this.neeqModel.setPrice(orderDetail.getPrice());
        }
        this.neeqModel.setPriceProtected(orderDetail.getStopPrice());
        if (this.neeqModel.isUpLimit()) {
            this.lbUpDownPrice.setVisible(true);
        }
        if (this.neeqModel.isDownLimit()) {
            this.lbUpDownPrice.setVisible(true);
        }
        this.neeqModel.getAccDisModel().setShowCanBuy(false);
        if ("3".equals(this.neeqModel.getPriceTypeLimitedStg().getRaw())) {
            this.neeqModel.setPrice(0.0);
        }
    }

    private void initPanel() {
        this.onApprove(true);
        this.isInstructionEvent = true;
        this.lbUpDownPrice.setVisible(false);
        this.txtCode.clear();
        this.txtCode.setUserData(null);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.neeqModel.setInstruction(new ObSimpleInstruction());
        this.neeqModel.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
        this.neeqModel.getAccDisModel().setShowCanBuy(false);
    }

    protected void clearCountCheck() {
        this.clearCountCheckForce();
    }

    protected void clearCountCheckForce() {
        switch (this.neeqModel.getCountStg().getRaw()) {
            case "5": {
                this.neeqModel.setMoney(0.0);
                break;
            }
            case "1": {
                this.neeqModel.setCount(0L);
                break;
            }
            default: {
                this.neeqModel.setCountPer(0.0);
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            if (this.neeqModel.isLimitPrice()) {
                this.priceSpn.requestFocus();
            } else if (this.neeqModel.isMktPrice()) {
                this.protectedPriceSpn.requestFocus();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            key.consume();
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    protected void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    protected void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    public void setPrice(double price) {
        if (this.neeqModel.isLimitPrice() && !this.neeqModel.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.neeqModel.setPrice(price);
        } else {
            if (this.neeqModel.isMktPrice() || this.neeqModel.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.neeqModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getNewAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + secAccDis.getCanSell() + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    protected void clearInfo() {
        this.instruction = null;
        this.btnOrder.setDisable(true);
    }

    protected void onApprove(boolean isApprove) {
        this.txtCode.setDisable(true);
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.cmbPriceTypeMkt.setDisable(true);
        this.cmbPriceTypeBidAsk.setDisable(true);
        this.cmbPriceTypeAfterHours.setDisable(true);
        this.btnOrder.setDisable(true);
        this.acctTreeTable.setDisable(isApprove);
        this.countStg.setDisable(true);
        this.hboxMoney.setDisable(true);
        this.hboxCounts.setDisable(true);
        this.hboxPer.setDisable(true);
        this.cmbDist.setDisable(true);
        this.cmbAccFilter.setDisable(true);
        this.stkPaneCommon.setDisable(true);
        this.hBoxDistStg.setDisable(true);
        this.protectedPriceSpn.setDisable(isApprove);
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Double> getProtectedPriceSpn() {
        return this.protectedPriceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.neeqModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.neeqModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.neeqModel.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.neeqModel.setAutoSlice(slice);
        this.neeqModel.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.neeqModel.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

