/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.core.MException;
import cms.tmx.entity.Result;
import cms.tmx.javafx.MxNode;
import cms.tmx.neeq.view.NeeqTradeBasePart;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.inject.Inject;

public class NeeqTradeAdvisePart
extends NeeqTradeBasePart {
    @Inject
    public NeeqTradeAdvisePart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.partType = "1";
        this.neeqModel.create("1");
        this.setBuySymbol("\u5efa\u8bae\u4e70\u5165");
        this.setSellSymbol("\u5efa\u8bae\u5356\u51fa");
        this.setConfirmSymbol("\u5efa\u8bae");
        super.initialize();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    @Override
    protected Result doAction() throws MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.regular.instruct.query");
        }
        return this.neeqModel.submitAdvice();
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.neeqModel.isLimitPrice() && !this.neeqModel.isAfterHoursPrice() || this.neeqModel.isUnlimited() || this.neeqModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        return !this.neeqModel.isBidAskPrice() || this.alert.check(this.neeqModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    protected void onPriceTypeLimitedChange(MxNode newV) {
        this.countStg.setDisable(false);
        super.onPriceTypeLimitedChange(newV);
        if (newV.is("3")) {
            this.countStg.getSelectionModel().select(0);
            this.countStg.setDisable(true);
        }
    }

    @Override
    protected void onPriceTypeChange() {
        super.onPriceTypeChange();
        boolean isDisable = ((MxNode)this.cmbPriceType.getValue()).is("50") && ((MxNode)this.cmbPriceTypeLimited.getValue()).is("3");
        this.countStg.setDisable(isDisable);
        if (isDisable) {
            this.countStg.getSelectionModel().select(0);
        }
    }
}

