/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.PosStatus;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.model.NeeqPositionModel;
import cms.tmx.query.utils.FundAccountStringConverter;
import cms.tmx.utils.CurrencyUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.INewRefMng;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class NeeqPositionPart
extends MxPart {
    @FXML
    private TableView<ObPosition> tablePosition;
    @FXML
    private TableColumn<ObPosition, String> securityId;
    @FXML
    private TableColumn<ObPosition, String> securityName;
    @FXML
    private TableColumn<ObPosition, String> securitySubType;
    @FXML
    private TableColumn<ObPosition, String> securityGroup;
    @FXML
    private TableColumn<ObPosition, String> unit;
    @FXML
    private TableColumn<ObPosition, String> stockType;
    @FXML
    private TableColumn<ObPosition, String> investorId;
    @FXML
    private TableColumn<ObPosition, String> investorName;
    @FXML
    private TableColumn<ObPosition, String> inverstorSecId;
    @FXML
    private TableColumn<ObPosition, String> currencyId;
    @FXML
    private TableColumn<ObPosition, MxNode> market;
    @FXML
    private TableColumn<ObPosition, Number> posQty;
    @FXML
    private TableColumn<ObPosition, Number> secAvail;
    @FXML
    private TableColumn<ObPosition, Number> cost;
    @FXML
    private TableColumn<ObPosition, Number> nowPrice;
    @FXML
    private TableColumn<ObPosition, Number> holdCostAmt;
    @FXML
    private TableColumn<ObPosition, Number> marketValue;
    @FXML
    private TableColumn<ObPosition, Number> buyCost;
    @FXML
    private TableColumn<ObPosition, Number> buyInQty;
    @FXML
    private TableColumn<ObPosition, Number> sellOutQty;
    @FXML
    private TableColumn<ObPosition, Number> percent;
    @FXML
    private TableColumn<ObPosition, Number> floatPnl;
    @FXML
    private TextField searchText;
    @FXML
    protected CheckComboBox<FundAccount> ccmbAccnt;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbPosiQty;
    @FXML
    private Label lbPosiAmt;
    @FXML
    private Label lbCapital;
    @FXML
    private Label lbFloatPL;
    @FXML
    private Label lbRealPl;
    @FXML
    private Label lbTotalPl;
    @FXML
    private Label lbNum;
    @Inject
    private NeeqPositionModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private INewRefMng refMng;
    @Inject
    protected IFundAccountService fundService;
    private final Logger logger = LogManager.getLogger(NeeqPositionPart.class);
    protected FundAccount fundAll = new FundAccount();
    protected Set<String> accIds = new HashSet<String>();
    protected boolean accFalg = false;
    private MxList<ObPosition> mlist = new MxList();
    private Predicate<ObPosition> pd = t -> {
        if (!this.accIds.contains(t.getInvestorId())) {
            return false;
        }
        String text = this.searchText.getText().trim().toUpperCase();
        if (t.getInstrument() == null || t.getInstrument().getSecurityId() == null) {
            return true;
        }
        String code = t.getInstrument().getSecurityId().toUpperCase();
        String name = t.getInstrument().getSymbol();
        return code.contains(text) || name != null && name.contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        this.mlist.update(this.model.getList(), this.pd);
        this.lstnExtendOperation((List<ObPosition>)this.mlist.getList());
        this.tablePosition.refresh();
    };
    private InvalidationListener lstnSearch = ob -> {
        this.mlist.filter(this.model.getList(), this.pd);
        this.lstnExtendOperation((List<ObPosition>)this.mlist.getList());
    };

    @FXML
    private void initialize() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.createTable();
        this.model.initQuery();
        this.initPosFilterAcc();
    }

    @PreDestroy
    private void preDestroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void initPosFilterAcc() {
        this.fundAll.setExtAccntId("\u5168\u90e8");
        this.fundAll.setInvestId("\u5168\u90e8");
        this.ccmbAccnt.getItems().add((Object)this.fundAll);
        this.ccmbAccnt.getItems().addAll((Collection)this.fundService.getNeeqFundAccountList());
        this.ccmbAccnt.setConverter((StringConverter)new FundAccountStringConverter());
        this.ccmbAccnt.getCheckModel().checkAll();
        this.ccmbAccntLis();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(this.fundAll)) {
                accStr = "";
                for (FundAccount fundAccount : listItem) {
                    if (fundAccount == null) continue;
                    accStr = String.valueOf(accStr) + fundAccount.getInvestId() + "__" + fundAccount.getAccountName() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (FundAccount fundAcc : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(fundAcc.getInvestId());
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
        this.accFalg = true;
    }

    void ccmbAccntLis() {
        int i = 1;
        while (i < this.ccmbAccnt.getItems().size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
    }

    private void createTable() {
        this.securityId.setCellValueFactory(data -> new SimpleStringProperty(((ObPosition)data.getValue()).getInstrument().getSecurityId()));
        this.securityName.setCellValueFactory(data -> new SimpleStringProperty(((ObPosition)data.getValue()).getInstrument().getSymbol()));
        this.securitySubType.setCellValueFactory(data -> {
            RefItem item = this.refMng.getItem(((ObPosition)data.getValue()).getInstrument().getSecurityType(), ((ObPosition)data.getValue()).getInstrument().getMarket(), ((ObPosition)data.getValue()).getInstrument().getSecurityId());
            if (item != null) {
                return new SimpleStringProperty(item.getSubSecurityType());
            }
            return new SimpleStringProperty();
        });
        this.securityGroup.setCellValueFactory(data -> {
            RefItem item = this.refMng.getItem(((ObPosition)data.getValue()).getInstrument().getSecurityType(), ((ObPosition)data.getValue()).getInstrument().getMarket(), ((ObPosition)data.getValue()).getInstrument().getSecurityId());
            if (item != null) {
                return new SimpleStringProperty(item.getLevelInfo());
            }
            return new SimpleStringProperty();
        });
        this.nowPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosition)data.getValue()).getNowPrice()));
        this.unit.setCellValueFactory(data -> new SimpleStringProperty(((ObPosition)data.getValue()).getUnit()));
        this.currencyId.setCellValueFactory(data -> new SimpleStringProperty(CurrencyUtils.getMarketNameById((String)((ObPosition)data.getValue()).getInstrument().getCurrencyId())));
        this.market.setCellValueFactory(data -> new SimpleObjectProperty((Object)new MxNode().load("market_code", ((ObPosition)data.getValue()).getInstrument().getMarket())));
        this.investorId.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorIdProperty());
        this.investorName.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorNameProperty());
        this.inverstorSecId.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorSecIdProperty());
        this.posQty.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosition)data.getValue()).getSecBalance()));
        this.secAvail.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosition)data.getValue()).getSecAvail()));
        this.percent.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosition)data.getValue()).getPercent()));
        this.cost.setCellValueFactory(data -> ((ObPosition)data.getValue()).costProperty());
        this.cost.setCellFactory(data -> new PriceCell());
        this.holdCostAmt.setCellValueFactory(data -> ((ObPosition)data.getValue()).holdCostAmtProperty());
        this.holdCostAmt.setCellFactory(data -> new PriceCell());
        this.marketValue.setCellValueFactory(data -> new SimpleDoubleProperty(((ObPosition)data.getValue()).getMarketValue()));
        this.buyCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostProperty());
        this.buyCost.setCellFactory(data -> new BuyCostCell());
        this.floatPnl.setCellValueFactory(data -> ((ObPosition)data.getValue()).floatPnlProperty());
        this.stockType.setCellValueFactory(data -> new SimpleStringProperty(PosStatus.getDes((int)((ObPosition)data.getValue()).getStatus())));
        this.buyInQty.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyInQtyProperty());
        this.sellOutQty.setCellValueFactory(data -> ((ObPosition)data.getValue()).sellOutQtyProperty());
        this.posQty.setCellFactory(data -> new DoubleTableCell());
        this.secAvail.setCellFactory(data -> new DoubleTableCell());
        this.cost.setCellFactory(data -> new DoubleTableCell());
        this.holdCostAmt.setCellFactory(data -> new DoubleTableCell());
        this.marketValue.setCellFactory(data -> new DoubleTableCell());
        this.buyCost.setCellFactory(data -> new BuyCostCell());
        this.floatPnl.setCellFactory(data -> new DoubleTableCell());
        this.percent.setCellFactory(data -> new DoubleTableCell());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.mlist.getList().sort((o1, o2) -> o1.getInstrument().getSecurityId().compareTo(o2.getInstrument().getSecurityId()));
        this.tablePosition.setItems(this.mlist.getList());
    }

    public void lstnExtendOperation(List<ObPosition> list) {
        long posiQty = 0L;
        double posiAmt = 0.0;
        double capital = 0.0;
        double floatPl = 0.0;
        for (ObPosition posi : list) {
            posiQty = (long)((double)posiQty + posi.getSecBalance());
            capital += posi.getMarketValue();
            floatPl += posi.getFloatPnl();
            posi.getRealPnl();
            posi.getTotalProfit();
            posiAmt += posi.getHoldCostAmt();
        }
        this.lbPosiQty.setText(StringUtils.toThousands((Number)posiQty));
        this.lbPosiAmt.setText(StringUtils.toThousands((Number)posiAmt, (int)2));
        this.lbCapital.setText(StringUtils.toThousands((Number)capital, (int)2));
        this.lbFloatPL.setText(StringUtils.toThousands((Number)floatPl, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)list.size()));
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    private class BuyCostCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        private BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObPosition posi = (ObPosition)ObPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = NeeqPositionPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    public class YieldTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");
        private Label label = new Label();

        private YieldTableCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (item != null) {
                    double value = item.doubleValue();
                    this.label.setText(this.sDFPrice.format(item));
                    if (value > 0.0) {
                        CssUtils.makeRise((Control)this.label);
                    } else if (value < 0.0) {
                        CssUtils.makeFall((Control)this.label);
                    } else if (value == 0.0) {
                        CssUtils.makeEven((Control)this.label);
                    }
                } else {
                    this.label.setText("");
                    this.setGraphic(null);
                    this.setText(null);
                }
            } else {
                this.label.setText("");
                this.setGraphic(null);
                this.setText(null);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

