/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.model.NeeqOrderModel;
import cms.tmx.neeq.view.LoadPartModel;
import cms.tmx.query.utils.SideCell;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderNeeq> {
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> side;
    @FXML
    private TableColumn<ObSingleOrderNeeq, String> neeqErrInfo;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> userName;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> wthQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderAmount;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> totalValue;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> donePercent;
    @FXML
    protected ComboBox<String> cmbAccnt;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    private NeeqOrderModel model;
    @Inject
    protected LoadPartModel load;
    @Inject
    protected MxAlert alert;
    private static final String ALL = "\u5168\u90e8";

    @FXML
    protected void initialize() {
        super.initialize();
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        if (!this.fundApi.getNeeqFundAccountList().isEmpty()) {
            this.fundApi.getNeeqFundAccountList().forEach(fund -> {
                boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
            });
        }
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.listenerSearch.invalidated(null));
    }

    protected boolean predicate(SingleOrder data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getExtOrderId();
        if (this.checkAcc(data).booleanValue()) {
            return false;
        }
        return code.contains(text) || orderId.contains(text) || name.contains(text);
    }

    private Boolean checkAcc(SingleOrder order) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return false;
        }
        String[] split = accntNow.split("__");
        if (!ALL.equals(accntNow) && !order.getInvestorId().contains(split[0])) {
            return true;
        }
        return false;
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.side.setCellFactory(cell -> new SideCell());
        this.userName.setCellValueFactory(data -> new SimpleStringProperty(((ObSingleOrderNeeq)data.getValue()).getUserName()));
        this.neeqErrInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.wthQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.totalValue.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }
}

