/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;

public class NeeqEntrustInquiryConfirmDialog
extends DialogObj {
    @FXML
    private TableView<NewCcsSingleEntrust> tableItems;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> index;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> issueId;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> securityId;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> securityName;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> effectivePrice;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> qtyRange;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> tradeStatus;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> startEndDate;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> price;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> qty;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> outstandingShare;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> accnt;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> secAccnt;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<NewCcsSingleEntrust> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    public long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    public boolean triggered = false;
    private RefItem refItem;
    private MxNode priceStg;
    private String type = "";
    private String custom = "";
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeMktStg;
    private MxNode priceTypeBidAskStg;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String issueSymbol = "\u7533\u8d2d";
    private String inquirySymbol = "\u8be2\u4ef7";
    private String unit = "";
    private boolean showWarning = true;
    private boolean buy;
    private static final String BUY_INFO = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u82e5\u60a8\u4e70\u5165\u7684\u6302\u724c\u516c\u53f8\u80a1\u7968\u7684\u59d4\u6258\u4ef7\u683c\u9ad8\u4e8e\u57fa\u51c6\u4ef7\u683c105%\u6216\u4e70\u5165\u57fa\u51c6\u4ef7\u683c0.1\u5143\u4ee5\u4e0a\uff08\u4ee5\u5b70\u9ad8\u4e3a\u51c6\uff09\uff0c\u53ef\u80fd\u6210\u4e3a\u65e0\u6548\u7533\u62a5\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u8bb0\u5f55\u3002";
    private static final String SELL_INFO = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u82e5\u60a8\u5356\u51fa\u7684\u6302\u724c\u516c\u53f8\u80a1\u7968\u7684\u59d4\u6258\u4ef7\u683c\u4f4e\u4e8e\u57fa\u51c6\u4ef7\u683c95%\u6216\u5356\u51fa\u57fa\u51c6\u4ef7\u683c0.1\u5143\u4ee5\u4e0b\uff08\u4ee5\u5b70\u4f4e\u4e3a\u51c6\uff09\uff0c\u53ef\u80fd\u6210\u4e3a\u65e0\u6548\u7533\u62a5\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u8bb0\u5f55\u3002";
    private static final String ISSUE_INFO = "1.\u5982\u679c\u60a8\u5b58\u5728\u6709\u6548\u7684\u8be2\u4ef7\u7533\u62a5\uff0c\u5219\u5fc5\u987b\u6309\u65f6\u5c65\u884c\u7533\u8d2d\u4e49\u52a1\uff012.\u7533\u62a5\u8be2\u4ef7\u4ee5\u7b2c\u4e00\u7b14\u6709\u6548\u7533\u62a5\u4e3a\u51c6";
    private static final String INQUIRY_INFO = "1.\u6295\u8d44\u8005\u53c2\u4e0e\u8be2\u4ef7\u5373\u89c6\u4e3a\u6388\u6743\u5168\u56fd\u80a1\u8f6c\u516c\u53f8\u5411\u672c\u6b21\u53d1\u884c\u80a1\u7968\u7684\u53d1\u884c\u4eba\u548c\u76f8\u5e94\u4e3b\u627f\u9500\u5546\u63d0\u4f9b\u5176\u62a5\u4ef7\u4fe1\u606f\u53ca\u5fc5\u8981\u7684\u8eab\u4efd\u4fe1\u606f\uff1b2.\u6295\u8d44\u8005\u53ef\u4ee5\u591a\u6b21\u53c2\u4e0e\u8be2\u4ef7\uff0c\u8be2\u4ef7\u4ee5\u6700\u540e\u4e00\u7b14\u6709\u6548\u7533\u62a5\u4e3a\u51c6\uff1b3.\u6295\u8d44\u8005\u53c2\u4e0e\u8be2\u4ef7\u7533\u62a5\uff0c\u4e14\u8be2\u4ef7\u6709\u6548\uff0c\u5219\u5fc5\u987b\u6309\u65f6\u5c65\u884c\u7533\u8d2d\u4e49\u52a1\uff01";
    private boolean isInstruction = false;
    private String instructionPanelType = "";
    private boolean isExecution = false;
    private boolean isIssue = false;
    private boolean isInquiry = false;
    private BooleanProperty isLimitJXC = new SimpleBooleanProperty(false);

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
        if (!this.isIssue) {
            // empty if block
        }
    }

    protected void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        if (!this.AmtIsEmpty()) {
            this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        }
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void calTotalInfo() {
        for (NewCcsSingleEntrust item : this.list) {
            double money = this.getMoney(item);
            if (this.isBuy(item)) {
                Double num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            this.totalCount += item.getQuantity();
            this.totalAmt += money;
            if (!this.showWarning) continue;
            if (this.checkSufficient(item)) {
                this.triggered = true;
            }
            if (this.isLimitJXC.get()) continue;
            this.isLimitJXC.set(50 == item.getOrderType() && "\u7cbe\u9009\u5c42".equals(item.getLevelInfo()));
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        StringBuilder bld = new StringBuilder();
        if (!this.showWarning) {
            return;
        }
        for (FundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getAvailable() < this.accBuyMap.get(acc))) continue;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t");
        }
        this.strTip = bld.toString();
    }

    private boolean checkSufficient(NewCcsSingleEntrust item) {
        switch (item.getSide()) {
            case "49": {
                item.setInsufficient(this.getMoney(item) > item.getFundAccount().getAvailable());
                item.setTip(item.isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "50": {
                item.setInsufficient(item.getQuantity() > item.getCanSell());
                item.setTip(item.isInsufficient() ? "\u53ef\u5356\u6570\u4e0d\u8db3" : "");
            }
        }
        return item.isInsufficient();
    }

    protected void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.issueId.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).issueIdProperty());
        this.securityId.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).secProperty());
        this.securityName.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).secNameProperty());
        this.effectivePrice.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).effectivePriceProperty());
        this.qtyRange.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).qtyRangeProperty());
        this.price.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).priceProperty());
        this.qty.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).quantityProperty());
        this.outstandingShare.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).outstandingShareProperty());
        this.tradeStatus.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).tradeStatusProperty());
        this.startEndDate.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).startEndDateProperty());
        this.accnt.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).investorIdProperty());
        this.secAccnt.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).investorSecIdProperty());
        this.price.setCellFactory(data -> new DoubleTableCell(2));
        this.qty.setCellFactory(data -> new DoubleTableCell(1));
        this.outstandingShare.setCellFactory(data -> new DoubleTableCell(2));
        this.tableItems.setItems(this.list);
    }

    private boolean isBuy(NewCcsSingleEntrust item) {
        return item.getSide() == "49";
    }

    private double getMoney(NewCcsSingleEntrust item) {
        return (double)item.getQuantity() * item.getPrice();
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    private MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setList(List<NewCcsSingleEntrust> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeMktStg() {
        return this.priceTypeMktStg;
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStg = priceTypeMktStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isBuy() {
        return this.buy;
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public boolean isIssue() {
        return this.isIssue;
    }

    public void setIssue(boolean isIssue) {
        this.isIssue = isIssue;
    }

    public void setInquiry(boolean isInquiry) {
        this.isInquiry = isInquiry;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<NewCcsSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            NewCcsSingleEntrust item = (NewCcsSingleEntrust)NewCcsSingleEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            if (NeeqEntrustInquiryConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 49) {
                    this.setText(NeeqEntrustInquiryConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustInquiryConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else if (item.getOrderType() == 50) {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = NeeqEntrustInquiryConfirmDialog.this.getRefItem() != null ? NeeqEntrustInquiryConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        if (NeeqEntrustInquiryConfirmDialog.this.getPriceTypeLimitedStg() != null) {
                            text = "-";
                        }
                        text = String.valueOf(text) + StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    }
                    if (NeeqEntrustInquiryConfirmDialog.this.getPriceTypeLimitedStg() != null && "3".equals(NeeqEntrustInquiryConfirmDialog.this.getPriceTypeLimitedStg().getRaw())) {
                        text = "";
                    }
                    this.setText(String.valueOf(NeeqEntrustInquiryConfirmDialog.this.getPriceTypeLimitedStg() != null ? NeeqEntrustInquiryConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 0) {
                    this.setText(NeeqEntrustInquiryConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + NeeqEntrustInquiryConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = NeeqEntrustInquiryConfirmDialog.this.getRefItem() != null ? NeeqEntrustInquiryConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    this.setText(text);
                }
            } else if (item.getOrderType() == 49) {
                if (NeeqEntrustInquiryConfirmDialog.this.isExecution) {
                    this.setText(NeeqEntrustInquiryConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustInquiryConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.setText(NeeqEntrustInquiryConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustInquiryConfirmDialog.this.getPriceStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                }
            } else {
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                double unit = NeeqEntrustInquiryConfirmDialog.this.getRefItem() != null ? NeeqEntrustInquiryConfirmDialog.this.getRefItem().getPriceUnit() : 0.01;
                String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                this.setText(text);
            }
        }
    }

    private class SideCell
    extends TableCell<NewCcsSingleEntrust, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if ("49" == value) {
                this.label.setText(NeeqEntrustInquiryConfirmDialog.this.buySymbol);
            } else if ("50" == value) {
                this.label.setText(NeeqEntrustInquiryConfirmDialog.this.sellSymbol);
            } else if ("201" == value) {
                this.label.setText(NeeqEntrustInquiryConfirmDialog.this.issueSymbol);
            } else if ("80" == value) {
                this.label.setText(NeeqEntrustInquiryConfirmDialog.this.inquirySymbol);
            }
            switch (value) {
                case "49": 
                case "80": 
                case "201": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<NewCcsSingleEntrust, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

