/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;

public class NeeqEntrustConfirmDialog
extends DialogObj {
    @FXML
    private VBox vBox;
    @FXML
    private TableView<NewCcsSingleEntrust> tableItems;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> index;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colCode;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colName;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colMkt;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colDirection;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> colCount;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colUnit;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> colPrice;
    @FXML
    private TableColumn<NewCcsSingleEntrust, Number> colAmt;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colAcc;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colSecAcc;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colTip;
    @FXML
    private TableColumn<NewCcsSingleEntrust, String> colInstrument;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @FXML
    private Label labInfo;
    @FXML
    private GridPane gdPane;
    @Inject
    protected MxAlert alert;
    private ObservableList<NewCcsSingleEntrust> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    public long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    public boolean triggered = false;
    private RefItem refItem;
    private MxNode priceStg;
    private String type = "";
    private String custom = "";
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeMktStg;
    private MxNode priceTypeBidAskStg;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String issueSymbol = "\u7533\u8d2d";
    private String inquirySymbol = "\u8be2\u4ef7";
    private String sellShortSymbol = "\u5356\u7a7a";
    private String unit = "";
    private boolean showWarning = true;
    private boolean buy;
    private boolean hk = false;
    private static final String BUY_INFO = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u82e5\u60a8\u4e70\u5165\u7684\u6302\u724c\u516c\u53f8\u80a1\u7968\u7684\u59d4\u6258\u4ef7\u683c\u9ad8\u4e8e\u57fa\u51c6\u4ef7\u683c105%\u6216\u4e70\u5165\u57fa\u51c6\u4ef7\u683c0.1\u5143\u4ee5\u4e0a\uff08\u4ee5\u5b70\u9ad8\u4e3a\u51c6\uff09\uff0c\u53ef\u80fd\u6210\u4e3a\u65e0\u6548\u7533\u62a5\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u8bb0\u5f55\u3002";
    private static final String SELL_INFO = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u82e5\u60a8\u5356\u51fa\u7684\u6302\u724c\u516c\u53f8\u80a1\u7968\u7684\u59d4\u6258\u4ef7\u683c\u4f4e\u4e8e\u57fa\u51c6\u4ef7\u683c95%\u6216\u5356\u51fa\u57fa\u51c6\u4ef7\u683c0.1\u5143\u4ee5\u4e0b\uff08\u4ee5\u5b70\u4f4e\u4e3a\u51c6\uff09\uff0c\u53ef\u80fd\u6210\u4e3a\u65e0\u6548\u7533\u62a5\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u8bb0\u5f55\u3002";
    private static final String ISSUE_INFO = "1.\u5982\u679c\u60a8\u5b58\u5728\u6709\u6548\u7684\u8be2\u4ef7\u7533\u62a5\uff0c\u5219\u5fc5\u987b\u6309\u65f6\u5c65\u884c\u7533\u8d2d\u4e49\u52a1\uff012.\u7533\u62a5\u8be2\u4ef7\u4ee5\u7b2c\u4e00\u7b14\u6709\u6548\u7533\u62a5\u4e3a\u51c6";
    private static final String INQUIRY_INFO = "1.\u6295\u8d44\u8005\u53c2\u4e0e\u8be2\u4ef7\u5373\u89c6\u4e3a\u6388\u6743\u5168\u56fd\u80a1\u8f6c\u516c\u53f8\u5411\u672c\u6b21\u53d1\u884c\u80a1\u7968\u7684\u53d1\u884c\u4eba\u548c\u76f8\u5e94\u4e3b\u627f\u9500\u5546\u63d0\u4f9b\u5176\u62a5\u4ef7\u4fe1\u606f\u53ca\u5fc5\u8981\u7684\u8eab\u4efd\u4fe1\u606f\uff1b2.\u6295\u8d44\u8005\u53ef\u4ee5\u591a\u6b21\u53c2\u4e0e\u8be2\u4ef7\uff0c\u8be2\u4ef7\u4ee5\u6700\u540e\u4e00\u7b14\u6709\u6548\u7533\u62a5\u4e3a\u51c6\uff1b3.\u6295\u8d44\u8005\u53c2\u4e0e\u8be2\u4ef7\u7533\u62a5\uff0c\u4e14\u8be2\u4ef7\u6709\u6548\uff0c\u5219\u5fc5\u987b\u6309\u65f6\u5c65\u884c\u7533\u8d2d\u4e49\u52a1\uff01";
    private boolean isInstruction = false;
    private String instructionPanelType = "";
    private boolean isExecution = false;
    private boolean isIssue = false;
    private boolean isInquiry = false;
    private BooleanProperty isLimitJXC = new SimpleBooleanProperty(false);
    MxDialog mxDialog;

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
        if (!this.isIssue) {
            // empty if block
        }
    }

    protected void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        if (!this.AmtIsEmpty()) {
            this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        }
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
        if (this.buy) {
            this.labInfo.setText(BUY_INFO);
            this.labInfo.visibleProperty().bind((ObservableValue)this.isLimitJXC);
        } else if (this.isIssue) {
            this.labInfo.setText(ISSUE_INFO);
            this.colInstrument.setVisible(true);
        } else if (this.isInquiry) {
            this.labInfo.setText(INQUIRY_INFO);
            this.colInstrument.setVisible(true);
        } else {
            this.labInfo.setText(SELL_INFO);
            this.labInfo.visibleProperty().bind((ObservableValue)this.isLimitJXC);
        }
        if (this.priceStg != null && "49".equals(this.priceStg.getRaw())) {
            this.colPrice.setText("\u4fdd\u62a4\u4ef7\u683c");
        }
        if (this.isHk()) {
            this.gdPane.setVisible(false);
        } else {
            this.gdPane.setVisible(true);
        }
    }

    private void calTotalInfo() {
        if (this.list.get(0) != null && ((NewCcsSingleEntrust)this.list.get(0)).getMarket().equals("XHKG")) {
            return;
        }
        for (NewCcsSingleEntrust item : this.list) {
            double money = this.getMoney(item);
            if (this.isBuy(item)) {
                Double num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            this.totalCount += item.getQuantity();
            this.totalAmt += money;
            if (!this.showWarning) continue;
            if (this.checkSufficient(item)) {
                this.triggered = true;
            }
            if (this.isLimitJXC.get()) continue;
            this.isLimitJXC.set(50 == item.getOrderType() && "\u7cbe\u9009\u5c42".equals(item.getLevelInfo()));
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        StringBuilder bld = new StringBuilder();
        if (!this.showWarning) {
            return;
        }
        for (FundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getAvailable() < this.accBuyMap.get(acc))) continue;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t");
        }
        this.strTip = bld.toString();
    }

    private boolean checkSufficient(NewCcsSingleEntrust item) {
        switch (item.getSide()) {
            case "49": {
                item.setInsufficient(this.getMoney(item) > item.getFundAccount().getAvailable());
                item.setTip(item.isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "50": {
                item.setInsufficient(item.getQuantity() > item.getCanSell());
                item.setTip(item.isInsufficient() ? "\u53ef\u5356\u6570\u4e0d\u8db3" : "");
            }
        }
        return item.isInsufficient();
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).secProperty());
        this.colName.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((NewCcsSingleEntrust)m.getValue()).getMarket()).getValue()));
        if (this.isIssue || this.isInquiry) {
            this.colInstrument.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).secInstrumentProperty());
        }
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).sideProperty());
        this.colCount.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(m -> {
            ((NewCcsSingleEntrust)m.getValue()).setUnit(this.unit);
            return ((NewCcsSingleEntrust)m.getValue()).unitProperty();
        });
        if (this.isAlgo()) {
            this.colPrice.setCellValueFactory(data -> new SimpleObjectProperty((Object)this.custom));
            this.colPrice.setText("\u7b97\u6cd5\u540d\u79f0");
        } else if (!this.priceIsEmpty()) {
            this.colPrice.setCellFactory(cell -> new ItemPriceCell());
            this.colPrice.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).priceProperty());
        }
        if (!this.AmtIsEmpty()) {
            this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
            this.colAmt.setCellValueFactory(m -> new SimpleDoubleProperty(this.getMoney((NewCcsSingleEntrust)m.getValue())));
        }
        this.colAcc.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).investorSecIdProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((NewCcsSingleEntrust)m.getValue()).tipProperty());
        if (this.isHk()) {
            this.tableItems.getColumns().remove(this.colUnit);
            this.tableItems.getColumns().remove(this.colAmt);
            this.tableItems.getColumns().remove(this.colSecAcc);
            this.tableItems.getColumns().remove(this.colTip);
            this.tableItems.getColumns().remove(this.colInstrument);
        }
        this.tableItems.setItems(this.list);
    }

    private boolean isBuy(NewCcsSingleEntrust item) {
        return item.getSide() == "49";
    }

    private double getMoney(NewCcsSingleEntrust item) {
        return (double)item.getQuantity() * item.getPrice();
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    private MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setList(List<NewCcsSingleEntrust> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeMktStg() {
        return this.priceTypeMktStg;
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStg = priceTypeMktStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isBuy() {
        return this.buy;
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public boolean isIssue() {
        return this.isIssue;
    }

    public void setIssue(boolean isIssue) {
        this.isIssue = isIssue;
    }

    public void setInquiry(boolean isInquiry) {
        this.isInquiry = isInquiry;
    }

    public boolean isHk() {
        return this.hk;
    }

    public void setHk(boolean hk) {
        this.hk = hk;
    }

    public void setDialog(MxDialog mxDialog) {
        this.mxDialog = mxDialog;
        this.dialogHeightChanged();
    }

    private void dialogHeightChanged() {
        if (this.mxDialog == null) {
            return;
        }
        this.vBox.setMaxHeight(200.0);
        this.vBox.setMaxWidth(650.0);
        this.tableItems.setMaxHeight(150.0);
        this.tableItems.setMaxWidth(650.0);
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<NewCcsSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            NewCcsSingleEntrust item = (NewCcsSingleEntrust)NewCcsSingleEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            if (NeeqEntrustConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 49) {
                    this.setText(NeeqEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else if (item.getOrderType() == 50 && item.getPlateLevels() == 0) {
                    double unit;
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double d = unit = NeeqEntrustConfirmDialog.this.getRefItem() != null ? NeeqEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    if (item.getMarket().equals("XHKG")) {
                        unit = 0.001;
                    }
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        if (NeeqEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null) {
                            text = "-";
                        }
                        text = String.valueOf(text) + StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    }
                    if (NeeqEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null && "3".equals(NeeqEntrustConfirmDialog.this.getPriceTypeLimitedStg().getRaw())) {
                        text = "";
                    }
                    this.setText(String.valueOf(NeeqEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null ? NeeqEntrustConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 50 && item.getPlateLevels() != 0) {
                    this.setText(NeeqEntrustConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + NeeqEntrustConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = NeeqEntrustConfirmDialog.this.getRefItem() != null ? NeeqEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    this.setText(text);
                }
            } else if (item.getOrderType() == 49) {
                if (NeeqEntrustConfirmDialog.this.isExecution) {
                    this.setText(NeeqEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.setText(NeeqEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + NeeqEntrustConfirmDialog.this.getPriceStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                }
            } else {
                double unit;
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                double d = unit = NeeqEntrustConfirmDialog.this.getRefItem() != null ? NeeqEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 0.01;
                if (item.getMarket().equals("XHKG")) {
                    unit = 0.001;
                }
                String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                this.setText(text);
            }
        }
    }

    private class SideCell
    extends TableCell<NewCcsSingleEntrust, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            switch (value) {
                case "49": {
                    this.label.setText(NeeqEntrustConfirmDialog.this.buySymbol);
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case "201": {
                    this.label.setText(NeeqEntrustConfirmDialog.this.issueSymbol);
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case "80": {
                    this.label.setText(NeeqEntrustConfirmDialog.this.inquirySymbol);
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case "50": {
                    this.label.setText(NeeqEntrustConfirmDialog.this.sellSymbol);
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                case "53": {
                    this.label.setText(NeeqEntrustConfirmDialog.this.sellShortSymbol);
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<NewCcsSingleEntrust, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

