/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObExecutionNeeq;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.model.NeeqDealModel;
import cms.tmx.query.utils.SideCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NeeqDealPart
extends MxPagePart<Execution, ObExecutionNeeq> {
    @FXML
    private TableColumn<ObExecutionNeeq, MxNode> side;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> lastQty;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> lastPx;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> lastAmount;
    @FXML
    protected TableView<ObExecutionNeeq> tableDealCount;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountSecId;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountSecName;
    @FXML
    private TableColumn<ObExecutionNeeq, MxNode> colCountDir;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> colCountVol;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountUnit;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> colCountPrice;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountMkt;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> colCountAmount;
    @FXML
    private TableColumn<ObExecutionNeeq, Number> colCount;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountAcc;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountAccName;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountSecSubType;
    @FXML
    private TableColumn<ObExecutionNeeq, String> colCountSecGroup;
    @FXML
    private TableColumn<ObExecutionNeeq, MxNode> colCountMatchType;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<ObExecutionNeeq> mxCountList = new MxList();
    protected List<ObExecutionNeeq> countList = new LinkedList<ObExecutionNeeq>();
    @Inject
    private NeeqDealModel model;
    @Inject
    private MxAlert alert;
    @FXML
    protected ComboBox<String> cmbAccnt;
    @Inject
    protected IFundAccountService fundApi;
    private static final String ALL = "\u5168\u90e8";
    protected Predicate<ObExecutionNeeq> pdsum = t -> this.predicateSum((ObExecutionNeeq)t);
    protected InvalidationListener lstnSearch = ob -> {
        List<ObExecutionNeeq> list = this.countList;
        synchronized (list) {
            this.mxCountList.filter(this.countList, this.pdsum);
        }
    };

    protected void initialize() {
        super.initialize();
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.setRadio();
        this.initPage();
        this.createCountTable();
        this.initCmbAccnt();
    }

    private void initCmbAccnt() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        if (!this.fundApi.getNeeqFundAccountList().isEmpty()) {
            this.fundApi.getNeeqFundAccountList().forEach(fund -> {
                boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
            });
        }
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.listenerSearch.invalidated(null);
            this.lstnSearch.invalidated(null);
        });
    }

    @PreDestroy
    protected void preDestroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableView.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    private void initPage() {
        this.lbCurrentCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbTotalCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCountSeparator.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbPrevPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbNextPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
    }

    protected String getKey(Execution deal) {
        String key = String.valueOf(deal.getInvestorId()) + deal.getSecurityId() + deal.getSide().getValue();
        return key;
    }

    protected List<ObExecutionNeeq> createCountList(List<Execution> newList) {
        HashMap<String, Execution> map = new HashMap<String, Execution>();
        LinkedList<Execution> list = new LinkedList<Execution>();
        LinkedList<ObExecutionNeeq> listOb = new LinkedList<ObExecutionNeeq>();
        int i = 0;
        while (i < newList.size()) {
            Execution deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                Execution newDeal = new Execution();
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmount(newDeal.getLastPx() * newDeal.getLastQty());
                newDeal.setDealCount(1);
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                Execution oldDeal = (Execution)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double oldQty = oldDeal.getLastQty();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1);
                oldDeal.setLastAmount(oldDeal.getLastAmount() + price * qty);
            }
            ++i;
        }
        for (Execution deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmount() / deal.getLastQty() * 100.0) / 100.0);
            } else {
                deal.setLastPx(0.0);
            }
            ObExecutionNeeq ob = new ObExecutionNeeq();
            ob.update(deal);
            listOb.add(ob);
        }
        return listOb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        super.refreshList();
        ArrayList<Execution> newList = new ArrayList<Execution>();
        List<Execution> list = this.getList();
        synchronized (list) {
            newList.addAll(this.getList());
        }
        this.countList = this.createCountList(newList);
        this.mxCountList.update(this.countList, this.pdsum);
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.side.setCellFactory(cell -> new SideCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.lastPx.setCellFactory(data -> new DoubleTableCell());
        this.lastAmount.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getExecId().compareTo(o1.getExecId()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    protected void createCountTable() {
        this.colCountSecId.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).securityIdProperty());
        this.colCountSecName.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).securityNameProperty());
        this.colCountDir.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).sideProperty());
        this.colCountDir.setCellFactory(cell -> new SideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).lastQtyProperty());
        this.colCountUnit.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).unitProperty());
        this.colCountPrice.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).lastPxProperty());
        this.colCountPrice.setCellFactory(data -> new DoubleTableCell());
        this.colCountMkt.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).marketProperty());
        this.colCountAmount.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).lastAmountProperty());
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).dealCountProperty());
        this.colCountAcc.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).investorIdProperty());
        this.colCountAccName.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).investorNameProperty());
        this.colCountSecSubType.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).securitySubTypeProperty());
        this.colCountSecGroup.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).securityGroupProperty());
        this.colCountMatchType.setCellValueFactory(data -> ((ObExecutionNeeq)data.getValue()).matchTypeProperty());
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealCount);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected boolean predicate(Execution t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        if (this.checkAcc(t).booleanValue()) {
            return false;
        }
        return code.contains(text) || t.getInstrument().getSymbol().contains(text);
    }

    protected boolean predicateSum(ObExecutionNeeq t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getSecurityId().toUpperCase();
        if (this.checkAcc(t).booleanValue()) {
            return false;
        }
        return code.contains(text) || t.getSecurityName().contains(text);
    }

    private Boolean checkAcc(ObExecutionNeeq order) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return false;
        }
        String[] split = accntNow.split("__");
        if (!ALL.equals(accntNow) && !order.getInvestorId().contains(split[0])) {
            return true;
        }
        return false;
    }

    private Boolean checkAcc(Execution order) {
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return false;
        }
        String[] split = accntNow.split("__");
        if (!ALL.equals(accntNow) && !order.getInvestorId().contains(split[0])) {
            return true;
        }
        return false;
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listExec, (String)"\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
    }

    protected MxModel getModel() {
        return this.model;
    }
}

