/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.query.current.views.CcsAcctDetailPart;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class NeeqAcctDetailPart
extends CcsAcctDetailPart {
    protected Predicate<FundAccount> pd = item -> item.isNeeqEnable();
    protected InvalidationListener lstnNeeqTable = ob -> {
        this.mxList.update(this.serviceFundAccount.getFundAccountList("CCS"));
        this.updateWithMarket();
    };

    public void initialize() {
        super.initialize();
        this.colDesCapital.setVisible(false);
        this.colAsset.setVisible(true);
        this.serviceFundAccount.changedProperty().removeListener(this.lstnTable);
        this.serviceFundAccount.changedProperty().addListener(this.lstnNeeqTable);
        this.updateWithMarket();
    }

    protected void createTableView() {
        this.tableAcc.setPlaceholder((Node)new Label());
        this.tableAcc.setItems(this.mxList.getList());
        this.colAcc.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).investIdProperty());
        this.colAccName.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).accountNameProperty());
        this.colAvailable.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).availableProperty());
        this.colAvailable.setCellFactory(column -> new DoubleTableCell());
        this.colDesCapital.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).withdrawQuotaProperty());
        this.colDesCapital.setCellFactory(column -> new DoubleTableCell());
        this.colAsset.setCellValueFactory(data -> ((CcsFundAccount)data.getValue()).newAssetAmtProperty());
        this.colAsset.setCellFactory(column -> new DoubleTableCell());
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        MenuItem itemExcel = new MenuItem("\u5bfc\u51faEXCEL");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        menu.getItems().add((Object)itemExcel);
        itemCopy.setOnAction(event -> this.copy());
        itemRefresh.setOnAction(event -> this.query());
        itemExcel.setOnAction(event -> this.exportExcel());
        this.tableAcc.setContextMenu(menu);
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.colAcc.getText()) + "\t" + this.colAvailable.getText() + "\t" + this.colAsset.getText() + '\n');
        for (FundAccount item : this.mxList.getList()) {
            CcsFundAccount cur = (CcsFundAccount)CcsFundAccount.class.cast(item);
            clipboardString.append(String.valueOf(cur.getInvestId()) + "\t" + cur.getAvailable() + "\t" + cur.getNewAssetAmt() + '\n');
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    protected void query() {
        super.query();
        this.updateWithMarket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithMarket() {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.update((List)this.mxList.getList(), this.pd);
        }
        Platform.runLater(() -> this.tableAcc.layout());
    }
}

