/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.accnt.dto.AccntAggreement;
import cms.tmx.http.api.Instrument;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.neeq.model.NeeqAccntAggreementQueryModel;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqAccntAggreementQueryPart
extends MxPart {
    @FXML
    private ComboBox<CcsFundAccount> cmbAccnt;
    @FXML
    private ComboBox<SecAccount> cmbSecAccnt;
    @FXML
    private TableView<AccntAggreement> tableAggreement;
    @FXML
    private TableView<Instrument> tableStockLimit;
    @FXML
    private TableColumn<AccntAggreement, String> id;
    @FXML
    private TableColumn<AccntAggreement, String> name;
    @FXML
    private TableColumn<Instrument, String> securityName;
    @FXML
    private TableColumn<Instrument, String> securityId;
    @FXML
    private Button btnRefresh;
    @Inject
    private NeeqAccntAggreementQueryModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private MEventService es;
    private ObservableList<CcsFundAccount> accntList = FxUtils.newList();
    private ObservableList<AccntAggreement> accntAggreements = FxUtils.newList();
    private ObservableList<Instrument> stocksLimit = FxUtils.newList();

    @FXML
    public void initialize() {
        this.initValues();
        this.addLisetener();
        this.initControls();
        this.createTable();
    }

    private void initValues() {
        this.accntList.addAll(this.model.getNeeqAccntList());
    }

    private void addLisetener() {
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((oldValue, observ, newValue) -> {
            if (newValue != null) {
                this.getSecAccnt((CcsFundAccount)newValue);
            }
        });
        this.cmbSecAccnt.getSelectionModel().selectedItemProperty().addListener((oldValue, observ, newValue) -> {
            if (newValue != null) {
                CcsFundAccount ccsFundAccount = (CcsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
                this.getAccntAggrement(ccsFundAccount, (SecAccount)newValue);
                this.getSotcksLimit((SecAccount)newValue);
            }
        });
    }

    private void getSotcksLimit(SecAccount newValue) {
        try {
            ObservableList<Instrument> secList = this.model.getSecList(newValue.getExtSecAccntId());
            this.stocksLimit.setAll(secList);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error((Object)e, e);
        }
    }

    private void getSecAccnt(CcsFundAccount newValue) {
        List<SecAccount> neeqSecAccntList = this.model.getNeeqSecAccntList(newValue);
        ObservableList newList = FxUtils.newList();
        newList.addAll(neeqSecAccntList);
        this.cmbSecAccnt.getItems().clear();
        this.cmbSecAccnt.setItems(newList);
        if (!newList.isEmpty()) {
            this.cmbSecAccnt.getSelectionModel().select(0);
        }
    }

    private void getAccntAggrement(CcsFundAccount newValue, SecAccount secAccount) {
        try {
            ObservableList newList = this.model.queryAccntAggreement(newValue.getNewCashAccntId(), secAccount.getExtSecAccntId());
            newList.forEach(item -> item.initType());
            newList = FXCollections.observableList(newList.stream().distinct().collect(Collectors.toList()));
            this.accntAggreements.setAll((Collection)newList);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error((Object)e, e);
        }
    }

    private void initControls() {
        this.cmbAccnt.setItems(this.accntList);
        if (!this.accntList.isEmpty()) {
            this.cmbAccnt.getSelectionModel().select(0);
        }
    }

    private void createTable() {
        TableUtils.isAuto(this.id);
        this.name.setCellValueFactory(data -> new SimpleStringProperty(this.getAggreementName(((AccntAggreement)data.getValue()).getAggreementId())));
        this.tableAggreement.setPlaceholder((Node)new Label());
        this.tableAggreement.setItems(this.accntAggreements);
        this.securityId.setCellValueFactory(data -> new SimpleStringProperty(((Instrument)data.getValue()).getSecurityId()));
        this.securityName.setCellValueFactory(data -> new SimpleStringProperty(((Instrument)data.getValue()).getSymbol()));
        this.tableStockLimit.setPlaceholder((Node)new Label());
        this.tableStockLimit.setItems(this.stocksLimit);
    }

    private String getAggreementName(String type) {
        switch (type) {
            case "1": 
            case "2": {
                return "\u4e00\u7c7b\u5408\u683c\u6295\u8d44\u8005";
            }
            case "3": 
            case "4": {
                return "\u4e24\u7f51\u9000\u5e02\u6295\u8d44\u8005\u4ea4\u6613\u6743\u9650";
            }
            case "5": 
            case "6": {
                return "\u56db\u7c7b\u5408\u683c\u6295\u8d44\u8005";
            }
            case "B": 
            case "C": {
                return "\u4e8c\u7c7b\u5408\u683c\u6295\u8d44\u8005";
            }
            case "D": 
            case "E": {
                return "\u4e09\u7c7b\u5408\u683c\u6295\u8d44\u8005";
            }
            case "Z": {
                return "\u53d7\u9650\u6295\u8d44\u8005\u534f\u8bae";
            }
        }
        return "";
    }

    protected void afterTableRestore() {
        this.tableAggreement.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableStockLimit.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    @FXML
    private void refresh() {
        try {
            this.btnRefresh.setDisable(true);
            ObservableList items = this.cmbAccnt.getItems();
            if (items == null || items.isEmpty()) {
                return;
            }
            for (CcsFundAccount ccsFundAccount : items) {
                List<SecAccount> neeqSecAccntList = this.model.getNeeqSecAccntList(ccsFundAccount);
                for (SecAccount secAccount : neeqSecAccntList) {
                    this.getAccntAggrement(ccsFundAccount, secAccount);
                    this.getSotcksLimit(secAccount);
                }
            }
            if (this.cmbAccnt.getSelectionModel().getSelectedItem() != null && this.cmbSecAccnt.getSelectionModel().getSelectedItem() != null) {
                this.getAccntAggrement((CcsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem(), (SecAccount)this.cmbSecAccnt.getSelectionModel().getSelectedItem());
                this.getSotcksLimit((SecAccount)this.cmbSecAccnt.getSelectionModel().getSelectedItem());
            }
            this.es.sendEvent("reload.neeq.rights", null);
        }
        finally {
            this.btnRefresh.setDisable(false);
        }
    }
}

