/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model.distribution.business;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.pricingit.SecurityServiceApi;
import cms.tmx.http.data.GetIssuesReq;
import cms.tmx.http.data.GetIssuesResp;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IUserService;
import cms.tmx.neeq.model.NeeqRfqResultModel;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NeeqIssueInfoInquiryModel
extends MxModel {
    @Inject
    private HttpBaseApi httpBaseApi;
    @Inject
    private SecurityServiceApi refMngApi;
    @Inject
    private NeeqRfqResultModel rfqModel;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected ScheduledExecutorService ses;
    protected List<IssueInfo> list = new LinkedList<IssueInfo>();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected Gson gson = new Gson();

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
        if (this.list.size() == 0) {
            try {
                this.query();
            }
            catch (MException | Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @PreDestroy
    private void destory() {
    }

    public void query() throws IOException, MException {
        GetIssuesReq req = new GetIssuesReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setMarket("NEEQ");
        Fragment fragment = new Fragment();
        fragment.setOffset(0);
        fragment.setSize(200);
        req.setFragment(fragment);
        try {
            GetIssuesResp resp = this.refMngApi.getIssues(req);
            this.list.clear();
            if (resp.getIssue() == null) {
                return;
            }
            this.list.addAll(resp.getIssue());
            int queryTimes = (int)Math.ceil((double)resp.getFragment().getTotal() * 1.0 / 200.0);
            while (--queryTimes > 0) {
                fragment.setOffset(resp.getFragment().getOffset());
                req.setFragment(fragment);
                resp = this.refMngApi.getIssues(req);
                this.list.addAll(resp.getIssue());
            }
            for (IssueInfo info : this.list) {
                info.setExtraFields();
                info.getIssueId();
            }
        }
        catch (MException e) {
            this.logger.error("load neeq issues failed" + e.getMessage(), (Throwable)e);
        }
        this.list = this.list.stream().distinct().filter(item -> "I".equals(item.getParams().getUnderlying().getSecuritySubType())).collect(Collectors.toList());
        this.changed();
    }

    public List<IssueInfo> getList() {
        return this.list;
    }
}

