/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model.distribution.business;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.IAccountService;
import cms.tmx.neeq.factory.NeeqSingleEntrustFactory;
import cms.tmx.neeq.model.NeeqIssueAccountDistributionModel;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NeeqApplicationPurchaseTradeBaseModel
extends MxModel {
    private StringProperty insrumentId = new SimpleStringProperty("");
    private StringProperty underlyingId = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private LongProperty issueQty = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private static final Logger logger = LogManager.getLogger(NeeqApplicationPurchaseTradeBaseModel.class);
    @Inject
    private MObjFactory of;
    @Inject
    protected NeeqIssueAccountDistributionModel accTreeModel;
    @Inject
    protected NeeqSingleEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    protected IssueInfo info;

    @PostConstruct
    public void init() {
        this.accTreeModel.securityProperty().bind((ObservableValue)this.underlyingId);
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_count_filter", "1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        this.issueQty.bindBidirectional((Property)this.accTreeModel.canBuyProperty());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.accTreeModel.moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.accTreeModel.percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.accTreeModel.changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public void onSecChange() {
        this.accTreeModel.setInfo(this.getInfo());
        this.filterAcc();
    }

    private void onDistStgChange() {
        this.accTreeModel.setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.accTreeModel.setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        ((CcsAccountDistribution)this.accTreeModel.getRoot().getValue()).setCount(this.getCount());
        if (this.getCount() == 0L) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        this.calCountDistribution();
        if (!this.accTreeModel.isActive() && this.accTreeModel.getInstructType().equals("3")) {
            this.accTreeModel.allocateCount();
        }
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            this.accTreeModel.setPrice(this.getPrice());
            this.accTreeModel.calCanBuy();
        });
    }

    private void onMoneyChange() {
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.accTreeModel.setAccFilterStg(this.getAccFilterStg().getRaw());
        this.accTreeModel.setCustomSecAccCount(this.accTreeModel.getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        long total = this.accTreeModel.allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    public void filterAcc() {
        if (!this.isValidRef()) {
            this.accTreeModel.setRefItem(null);
            this.accTreeModel.clearCanBuySell(this.accTreeModel.getRoot());
            this.accTreeModel.filterAcc();
            return;
        }
        this.accTreeModel.setInfo(this.getValidRef());
        this.accTreeModel.calAccountCanBuy();
        this.accTreeModel.calAccountCanSell();
        this.accTreeModel.filterAcc();
    }

    protected void changeQuantityUnit() {
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized Result submit(TreeItem<CcsAccountDistribution> root) {
        Result result = new Result();
        for (NewCcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                en.newApplyForThePurchase();
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u65b0\u4e09\u677f\u59d4\u6258\u63d0\u4ea4\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getMessage());
                logger.error("\u65b0\u4e09\u677f\u59d4\u6258\u63d0\u4ea4\u51fa\u9519" + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized Result submitAdvice() throws MException {
        Result result = new Result();
        return result;
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is(Integer.toString(50));
    }

    protected void changeMarketPriceType() {
    }

    protected void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            node.removeOthers("1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        return this.info != null;
    }

    public IssueInfo getValidRef() {
        return this.info;
    }

    private int getUnit() {
        return this.accTreeModel.getUnit();
    }

    protected int getCvt() {
        return this.accTreeModel.getUnitConvert();
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return false;
    }

    public boolean isContinuousMatching() {
        if (!this.isValidRef()) {
            return false;
        }
        return false;
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return false;
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return false;
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return false;
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    public NewCcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createNewCcsSingle(acc, secAcc);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.accTreeModel.clearSelect();
        this.accTreeModel.selectSecAcc(secAcc, mkt);
    }

    public void setPresetPstAcct(String secAcc, String mkt) {
        this.accTreeModel.selectSecAcc(secAcc, mkt);
    }

    public List<NewCcsSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<NewCcsSingleEntrust> enList = new LinkedList<NewCcsSingleEntrust>();
        for (TreeItem acc : this.accTreeModel.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                NewCcsSingleEntrust en = this.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                en.setSide("201");
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                en.setMarket("NEEQ");
                en.setSecType(this.info.getSecurity().getInstrument().getSecurityType());
                en.setLevelInfo("\u7cbe\u9009\u5c42");
                en.setPrice(this.getPrice());
                en.setMarketIndicate("COMMON_ISSUE");
                en.setApplId("800");
                en.setMarketGroup("CCS");
                en.setOrderType(50);
                en.setSecInstrument(this.getInsrumentId());
                en.setSec(this.info.getParams().getUnderlying().getSecurityId());
                en.setSecName(this.info.getSecurity().getInstrument().getSymbol());
                enList.add(en);
            }
        }
        return enList;
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public void create(String instructType) {
        this.accTreeModel.setInstructType(instructType);
        this.accTreeModel.setIssueType("1");
        try {
            this.accTreeModel.create();
        }
        catch (MException | Exception e) {
            logger.error("\u521b\u5efa\u8d26\u53f7\u6811\u51fa\u9519", e);
        }
    }

    public DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public NeeqIssueAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    public final StringProperty insrumentIdProperty() {
        return this.insrumentId;
    }

    public final String getInsrumentId() {
        return (String)this.insrumentIdProperty().get();
    }

    public final void setInsrumentId(String insrumentId) {
        this.insrumentIdProperty().set((Object)insrumentId);
    }

    public final StringProperty underlyingIdProperty() {
        return this.underlyingId;
    }

    public final String getUnderlyingId() {
        return (String)this.underlyingIdProperty().get();
    }

    public final void setUnderlyingId(String underlyingId) {
        this.underlyingIdProperty().set((Object)underlyingId);
    }

    public IssueInfo getInfo() {
        return this.info;
    }

    public void setInfo(IssueInfo info) {
        this.info = info;
    }

    public final LongProperty issueQtyProperty() {
        return this.issueQty;
    }

    public final long getIssueQty() {
        return this.issueQtyProperty().get();
    }

    public final void setIssueQty(long issueQty) {
        this.issueQtyProperty().set(issueQty);
    }
}

