/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model.distribution.business;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersReq;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.neeq.model.NeeqOrderModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NeeqApplicationOrderModel
extends NeeqOrderModel {
    private static final String COMMON_ISSUE = "COMMON_ISSUE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!"NEEQ".equals(order.getInstrument().getMarket())) {
                return;
            }
            if (!COMMON_ISSUE.equals(order.getInstrument().getMarketIndicator())) {
                return;
            }
            if (!Side.SIDE_STOCK_ISSUE.equals((Object)order.getSide())) {
                return;
            }
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setInvestorSecId(this.accntMap.getAllCcsInverstorSecId(order.getExtSecAccntId()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210+++" : "\u59d4\u6258+++") + " (sysOrderId:" + order.getOrderId() + ", orderId:" + order.getOrderId() + ", price:" + order.getPrice() + ", status:" + order.getOrdStatus() + ", qty:" + order.getOrderQty() + ", dealQty:" + order.getCumQty() + ")" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
            ConcurrentHashMap concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = (Integer)this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210---" : "\u59d4\u6258---") + ", sysOrderId:" + sysOrderId + ", statusOld:" + statusOld + ", statusNow:" + statusNow + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.getCanCancelFlag() == 1) {
                        this.list.updatePart((MxObject)order);
                    } else if (this.list.getListMap().get(order) != null) {
                        this.list.remove((MxObject)order);
                    }
                } else {
                    this.list.updatePart((MxObject)order);
                }
            }
        }
        this.changed();
    }

    @Override
    public void query() throws IOException, MException {
        GetSingleOrdersReq req = new GetSingleOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("CCS");
        req.setApplId("800");
        req.setSide(Side.SIDE_STOCK_ISSUE);
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator(COMMON_ISSUE);
        req.setInstrument(instrument);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        LinkedList<String> ids = new LinkedList<String>();
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount fundAccount : fundAccountList) {
            ids.add(fundAccount.getNewCashAccntId());
        }
        req.setExtCashAccntId(ids);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSingleOrdersResp resp = this.api.getOrders(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getOrder());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetSingleOrdersResp res = this.api.getOrders(req);
            this.list.addAll(res.getOrder());
        }
        for (SingleOrder order : this.list.getList()) {
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setInvestorSecId(this.accntMap.getAllCcsInverstorSecId(order.getExtSecAccntId()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.map.put(order.getOrderId(), order);
        }
        this.changed();
    }

    public List<SingleOrder> getOrdersById(String id) {
        LinkedList<SingleOrder> datas = new LinkedList();
        datas = this.list.getList().stream().filter(item -> id.equals(item.getIssueId())).collect(Collectors.toList());
        return datas;
    }

    public List<SingleOrder> getSuccessOrdersById(String id) {
        LinkedList<SingleOrder> datas = new LinkedList();
        datas = this.list.getList().stream().filter(item -> id.equals(item.getIssueId()) && (item.getOrdStatus() == OrdStatus.ORD_STATUS_NEW || item.getOrdStatus() == OrdStatus.ORD_STATUS_FILLED || item.getOrdStatus() == OrdStatus.ORD_STATUS_PARTIALLY_FILLED || item.getOrdStatus() == OrdStatus.ORD_STATUS_DONE_FOR_DAY)).collect(Collectors.toList());
        return datas;
    }

    public boolean hasEffectiveOrder(String id) {
        for (SingleOrder order : this.list.getList()) {
            if (!order.getIssueId().equals(id) || order.getOrdStatus() != OrdStatus.ORD_STATUS_NEW && order.getOrdStatus() != OrdStatus.ORD_STATUS_FILLED && order.getOrdStatus() != OrdStatus.ORD_STATUS_PARTIALLY_FILLED && order.getOrdStatus() != OrdStatus.ORD_STATUS_DONE_FOR_DAY) continue;
            return true;
        }
        return false;
    }

    public boolean hasEffectiveOrder(String id, String investorId, String investorSecId) {
        for (SingleOrder order : this.list.getList()) {
            if (!order.getIssueId().equals(id) || order.getOrdStatus() != OrdStatus.ORD_STATUS_NEW && order.getOrdStatus() != OrdStatus.ORD_STATUS_FILLED && order.getOrdStatus() != OrdStatus.ORD_STATUS_PARTIALLY_FILLED && order.getOrdStatus() != OrdStatus.ORD_STATUS_DONE_FOR_DAY || !investorId.equals(order.getInvestorId()) || !investorSecId.equals(order.getInvestorSecId())) continue;
            return true;
        }
        return false;
    }
}

