/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.neeq.model.NeeqOrderModel;
import cmx.tmx.data.INewRefMng;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NeeqUnfinishedOrderModel
extends NeeqOrderModel {
    @Inject
    private INewRefMng refMng;
    @Inject
    private MarketDataModel marketMng;
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    private MxNode nodeHandicap;

    @Override
    @PostConstruct
    protected void init() {
        this.isUnfinishedOrder = true;
        super.init();
        this.nodeHandicap = MxNodeFactory.createNew((String)"handicap", (String)"0");
        this.initPriceType(this.nodeHandicap);
        this.setPriceType(this.nodeHandicap);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "100");
        node.addNode("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
        node.addNode("-100");
    }

    private void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public final StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public final String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public final void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public final StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public final String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public final void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public void queryMarketItem(List<SingleOrder> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (SingleOrder order : list) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem);
        }
    }

    private MarketItem getMktItemByOrder(SingleOrder order) {
        RefItem refItem = this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId());
        if (refItem == null) {
            return null;
        }
        MarketItem mktItem = (MarketItem)((Map)this.marketMng.getMapInfo().get(refItem)).get(String.valueOf(refItem.getMarket()) + refItem.getCode());
        return mktItem;
    }

    public double getNewPrice(SingleOrder order, int priceType, String floatUnit, String priceFloat) {
        double price = 0.0;
        MarketItem mktItem = this.getMktItemByOrder(order);
        if (mktItem == null) {
            return 0.0;
        }
        price = this.getPrice(priceType, mktItem);
        int scale = mktItem.getRefItem().getScale();
        BigDecimal bg = new BigDecimal(String.valueOf(price));
        price = bg.setScale(scale, 4).doubleValue();
        if (floatUnit.equals("\u5143")) {
            price += Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat);
        } else if (floatUnit.equals("%")) {
            BigDecimal floatP = new BigDecimal(1).add(new BigDecimal(Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat)).multiply(new BigDecimal(0.01)));
            price = new BigDecimal(price).multiply(floatP).doubleValue();
        }
        if (!"BOND".equals(order.getInstrument().getSecurityType()) && !"REPO".equals(order.getInstrument().getSecurityType()) && !"PLEDGE".equals(order.getInstrument().getSecurityType()) && mktItem.getUpLimitPrice() > 0.0 && price > mktItem.getUpLimitPrice()) {
            price = mktItem.getUpLimitPrice();
        } else if (!"BOND".equals(order.getInstrument().getSecurityType()) && !"REPO".equals(order.getInstrument().getSecurityType()) && !"PLEDGE".equals(order.getInstrument().getSecurityType()) && mktItem.getDownLimitPrice() > 0.0 && price < mktItem.getDownLimitPrice()) {
            price = mktItem.getDownLimitPrice();
        }
        bg = new BigDecimal(String.valueOf((double)Math.round(price * 10000.0) / 10000.0));
        if ("49".equals(order.getSide().getValue())) {
            price = bg.setScale(scale, 1).doubleValue();
        } else if ("50".equals(order.getSide().getValue())) {
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    private double getPrice(int i, MarketItem mktItem) {
        double price = 0.0;
        if (i == 0) {
            price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
        } else if (i == 100) {
            price = mktItem.getUpLimitPrice() > 0.0 ? mktItem.getUpLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i == -100) {
            price = mktItem.getDownLimitPrice() > 0.0 ? mktItem.getDownLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i > 0) {
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListBuyHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListBuyHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        } else if (i < 0) {
            i = Math.abs(i);
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListSellHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListSellHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        }
        return price;
    }
}

