/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.OrderCancelReplaceRequest;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.ExecTask;
import cms.tmx.http.instruction.dto.ExecuteTaskReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.instruction.dto.TaskArgument;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.IAccountService;
import cms.tmx.neeq.factory.NeeqSingleEntrustFactory;
import cms.tmx.neeq.model.NeeqAccountDistributionModel;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NeeqTradeBaseModel {
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private ObSimpleInstruction instruction = new ObSimpleInstruction();
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeMktStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeAfterHours = new SimpleObjectProperty();
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private final int INIT_UNIT = 100;
    private static final Logger logger = LogManager.getLogger(NeeqTradeBaseModel.class);
    @Inject
    private MObjFactory of;
    protected MarketItem mktItem;
    @Inject
    private MarketDataModel mktMng;
    @Inject
    protected INewRefMng refMng;
    @Inject
    private InstructionServiceApi newInsApi;
    @Inject
    protected NeeqAccountDistributionModel accTreeModel;
    @Inject
    protected NeeqSingleEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    @Inject
    private TradeServiceApi api;
    @Inject
    private WorkflowTemplateApi workflowApi;
    @Inject
    private InstructionServiceApi insApi;
    @Inject
    private MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    private Map<String, WorkflowTemplate> workFlowAccountMap = new HashMap<String, WorkflowTemplate>();
    private MEventHandler cancelAndOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        for (Object obj : list) {
            if (!(obj instanceof SingleOrder)) continue;
            SingleOrder order = (SingleOrder)SingleOrder.class.cast(obj);
            try {
                if (order.getNewPrice() <= 0.0) {
                    throw new MException(999997, "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a");
                }
                this.cancelReplaceOrderSingle(order);
                ++countSuc;
            }
            catch (MException | Exception e) {
                ++countFailed;
                logger.error("\u64a4\u5355\u5931\u8d25", e);
                str.append(String.valueOf(order.getOrderId()) + e.getMessage() + "\n");
            }
            event.put((Object)"suc.count", (Object)countSuc);
            event.put((Object)"fail.count", (Object)countFailed);
            event.put((Object)"fail.message", (Object)str.toString());
        }
    };
    private MEventHandler cancelOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        for (Object obj : list) {
            if (!(obj instanceof SingleOrder)) continue;
            SingleOrder order = (SingleOrder)SingleOrder.class.cast(obj);
            try {
                this.cancel(order);
                ++countSuc;
            }
            catch (MException e) {
                ++countFailed;
                logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
                str.append(String.valueOf(order.getOrderId()) + e.getMessage() + "\n");
            }
            event.put((Object)"suc.count", (Object)countSuc);
            event.put((Object)"fail.count", (Object)countFailed);
            event.put((Object)"fail.message", (Object)str);
        }
    };

    @PostConstruct
    public void init() {
        this.accTreeModel.securityProperty().bind((ObservableValue)this.security);
        this.mktItem = this.mktMng.createItem(10);
        this.accTreeModel.buyProperty().bind((ObservableValue)this.buy);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type", "50");
        node.removeNode("99");
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
        this.setPriceTypeLimitedStg(node);
        this.limitStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
        this.initPriceGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
        this.initMarketType(node);
        this.setPriceTypeMktStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_after_hours", "1");
        this.initAfterHoursType(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_count_filter", "1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.accTreeModel.moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.accTreeModel.percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.accTreeModel.changedProperty().addListener(ob -> this.calCountDistribution());
        this.es.subscribe("neeq.cancel.order", this.cancelOrder);
        this.es.subscribe("neeq.cancel.and.order", this.cancelAndOrder);
    }

    public void cancel(SingleOrder singleOrder) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = singleOrder.getInstrument();
        instrument.setMarketGroup(MarketUtils.getMarketGroup((String)instrument.getMarket()));
        order.setInstrument(instrument);
        order.setOrderId(singleOrder.getOrderId());
        order.setExtCashAccntId(singleOrder.getExtCashAccntId());
        order.setExtSecAccntId(singleOrder.getExtSecAccntId());
        this.api.orderCancel(order);
    }

    public void cancelReplaceOrderSingle(SingleOrder order) throws MException {
        OrderCancelReplaceRequest req = new OrderCancelReplaceRequest();
        req.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = order.getInstrument();
        req.setInstrument(instrument);
        req.setOrderId(order.getOrderId());
        req.setExtCashAccntId(order.getExtCashAccntId());
        req.setPrice(order.getNewPrice());
        req.setOrdType(OrdType.ORD_TYPE_LIMIT);
        this.api.orderCancelReplace(req);
    }

    private void initAfterHoursType(MxNode node) {
        this.setPriceTypeAfterHours(node);
    }

    public void onSecChange() {
        this.accTreeModel.setRepo(this.isReverseRepo());
        this.mktMng.dye(this.mktItem);
        if ("4".equals(this.accTreeModel.getInstructType()) || "0".equals(this.accTreeModel.getInstructType()) || "1".equals(this.accTreeModel.getInstructType())) {
            this.setPrice(this.mktItem.getNowPrice());
        }
        if (!this.mktItem.getRefItem().isStopFlag()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changePriceStg();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
        this.setMktPrice();
        this.setBidAskPrice();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.accTreeModel.setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.accTreeModel.setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            if (this.isMktPrice()) {
                this.setCount(this.getPriceProtected() != 0.0 ? (long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            } else {
                this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            }
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        ((CcsAccountDistribution)this.accTreeModel.getRoot().getValue()).setCount(this.getCount());
        if (this.getCount() == 0L) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        this.calCountDistribution();
        if (!this.accTreeModel.isActive() && this.accTreeModel.getInstructType().equals("3")) {
            this.accTreeModel.allocateCount();
        }
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    public void setMktPrice() {
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
    }

    private void onPriceStgChange() {
        this.accTreeModel.setCountStg(this.getCountStg().getRaw());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        } else if (this.isBidAskPrice()) {
            this.setBidAskPrice();
        } else {
            this.setPrice(0.0);
        }
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            if (this.isMktPrice()) {
                this.accTreeModel.setPrice(this.getPriceProtected());
            } else {
                this.accTreeModel.setPrice(this.getPrice());
            }
            this.filterAcc();
            if (this.isCountOrSell()) {
                this.accTreeModel.calCanBuy();
                return;
            }
            boolean clear = false;
            if (this.isMktPrice()) {
                clear = this.getPriceProtected() == 0.0;
            } else {
                boolean bl = clear = this.getPrice() == 0.0 && !this.isUnlimited();
            }
            if (clear) {
                this.accTreeModel.clearCount(this.accTreeModel.getRoot());
                this.accTreeModel.clearCanBuy(this.accTreeModel.getRoot());
                return;
            }
            if (this.getCountStg().getRaw().equals("5")) {
                this.setCount((long)(this.getMoney() / this.accTreeModel.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
                return;
            }
            this.calCountDistribution();
        });
    }

    private void onMoneyChange() {
        if (this.isMktPrice()) {
            if (this.getPriceProtected() != 0.0) {
                this.setCount((long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            }
        } else if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.accTreeModel.setAccFilterStg(this.getAccFilterStg().getRaw());
        this.accTreeModel.setCustomSecAccCount(this.accTreeModel.getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        long total = this.accTreeModel.allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    public void filterAcc() {
        if (!this.isValidRef()) {
            this.accTreeModel.setRefItem(null);
            this.accTreeModel.clearCanBuySell(this.accTreeModel.getRoot());
            this.accTreeModel.filterAcc();
            return;
        }
        this.accTreeModel.setRefItem(this.getValidRef());
        this.accTreeModel.calAccountCanBuy();
        this.accTreeModel.calAccountCanSell();
        this.accTreeModel.filterAcc();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.accTreeModel.setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.accTreeModel.setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized Result submit(TreeItem<CcsAccountDistribution> root) {
        Result result = new Result();
        for (NewCcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                en.newOrderSingle();
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u65b0\u4e09\u677f\u59d4\u6258\u63d0\u4ea4\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized Result submit(TreeItem<CcsAccountDistribution> root, ObSimpleInstruction ins) {
        Result result = new Result();
        for (NewCcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                ExecuteTaskReq req = new ExecuteTaskReq();
                req.setInstructionId(ins.getId());
                ExecTask execTask = new ExecTask();
                req.setInstructionId(ins.getId());
                execTask.setInstructionId(ins.getId());
                RefItem refItem = this.refMng.getItem(this.instruction.getSecType(), this.instruction.getSecMarket(), this.instruction.getSecurityCode());
                TaskArgument taskArg = new TaskArgument();
                taskArg.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
                taskArg.setType("type.googleapis.com/proto.instruction.TaskArgument");
                AccountId accountId = new AccountId();
                accountId.setCashAccntId(en.getAcc());
                accountId.setSecAccntId(en.getSecAcc());
                taskArg.setAccountId(accountId);
                Instrument instrument = ins.getOrderDetail().getInstrument();
                instrument.setApplId("800");
                instrument.setMarketIndicator("COMMON_STOCK");
                instrument.setSecurityGroup(refItem.getLevelInfo());
                instrument.setSecuritySubType(refItem.getSubSecurityType());
                taskArg.setInstrument(instrument);
                taskArg.setMatchType(MatchType.getMatchTypeByRefKey((String)refItem.getTransferMethodCode()).getValue());
                taskArg.setOrderQty((double)en.getQuantity());
                taskArg.setPrice(en.getPrice());
                execTask.setArgument(Arrays.asList(taskArg));
                taskArg.setSide(Side.get((String)this.instruction.getSide()));
                req.getTask().add(execTask);
                this.insApi.execInstructionTask(req);
                result.operate(true);
                TaskLog log = new TaskLog();
                log.setWorkflowId(this.instruction.getEntryId());
                log.setOpUser(this.baseApi.getBaseApi().getUserId());
                log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId);
                List workflowTasks = this.instruction.getWorkflowTasks();
                for (WorkflowTask workflowTask : workflowTasks) {
                    Node node = workflowTask.getNode();
                    if (!node.getNodeName().contains("\u6267\u884c") || !node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) continue;
                    log.setNodeId(node.getNodeId());
                    log.setNodeName(node.getNodeName());
                    break;
                }
                this.workflowApi.recordTaskLog(log);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u6267\u884c\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u65b0\u4e09\u677f\u6307\u4ee4\u6267\u884c\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized Result submitAdvice() throws MException {
        Result result = new Result();
        for (NewInstructionReq req : this.getOrderAdvices()) {
            try {
                OpStatus status = this.newInsApi.newInstruction(req);
                InstructionSubmitResult submitResult = new InstructionSubmitResult();
                submitResult.setInstructionId(status.getData());
                submitResult.setReason(status.getReason());
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
            }
        }
        this.workFlowAccountMap.clear();
        return result;
    }

    public void newInstruction(NewInstructionReq req) throws MException {
        this.newInsApi.newInstruction(req);
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is(Integer.toString(50));
    }

    protected void changeMarketPriceType() {
        MxNode node = this.getPriceTypeMktStg();
        if (node == null) {
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("NEEQ")) {
            this.neeqMarket(node);
        } else {
            this.initMarketType(node);
        }
    }

    private void changePriceStg() {
        MxNode node = this.getPriceStg();
        if (node == null) {
            return;
        }
        String old = node.getRaw();
        if (!this.isContinuousMatching()) {
            node.removeOthers("50");
            node.addNode("0");
            node.setRaw("50");
        } else {
            this.getPriceStg().addNode("49");
            node.removeNode("99");
            if (old.equals("99")) {
                node.setRaw("50");
            }
        }
        this.setPriceStg(node);
    }

    protected void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            node.removeOthers("1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    private int getUnit() {
        return this.accTreeModel.getUnit();
    }

    protected int getCvt() {
        return this.accTreeModel.getUnitConvert();
    }

    private void setCvt() {
        this.accTreeModel.setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isContinuousMatching() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getLevelInfo() != null && MatchType.CONTINUOUS_MATCHING.getRefKey().equals(this.getValidRef().getTransferMethodCode());
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    protected void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        MxNode nodeDistStg = this.getDistStg();
        if (this.isBuy()) {
            this.countStgBuy(nodeCountStg);
            this.limitStgBuy(this.getPriceTypeLimitedStg());
            this.distStgBuy(nodeDistStg);
        } else {
            this.countStgSell(nodeCountStg);
            this.limitStgSell(this.getPriceTypeLimitedStg());
            this.distStgSell(nodeDistStg);
        }
        if (this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        if (this.accTreeModel.isActive()) {
            this.filterAcc();
        }
    }

    public NewCcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createNewCcsSingle(acc, secAcc);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.accTreeModel.clearSelect();
        this.accTreeModel.selectSecAcc(secAcc, mkt);
    }

    public void setPresetPstAcct(String secAcc, String mkt) {
        this.accTreeModel.selectSecAcc(secAcc, mkt);
    }

    public List<NewCcsSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<NewCcsSingleEntrust> enList = new LinkedList<NewCcsSingleEntrust>();
        for (TreeItem acc : this.accTreeModel.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                NewCcsSingleEntrust en;
                block20: {
                    block22: {
                        block21: {
                            block19: {
                                en = this.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                                en.setSide(this.buy.get() ? "49" : "50");
                                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                                en.setMarket(this.mktItem.getRefItem().getMarket());
                                en.setSecType(this.mktItem.getRefItem().getType());
                                en.setLevelInfo(this.mktItem.getRefItem().getLevelInfo());
                                en.setMatchType(this.mktItem.getRefItem().getTransferMethodCode());
                                en.setSecSubType(this.mktItem.getRefItem().getSubSecurityType());
                                en.setPrice(this.getPrice());
                                en.setMarketIndicate("COMMON_STOCK");
                                en.setApplId("800");
                                en.setMarketGroup("CCS");
                                if (!"50".equals(this.getPriceStg().getRaw())) break block19;
                                en.setOrderType(50);
                                en.setPrice(this.getPrice());
                                if (0.0 == this.getPrice() && "3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                                    en.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
                                }
                                break block20;
                            }
                            if (!"0".equals(this.getPriceStg().getRaw())) break block21;
                            en.setOrderType(50);
                            en.setPrice(this.getPrice());
                            en.setPlateLevels(Integer.valueOf(this.getPriceTypeBidAskStg().getRaw()).intValue());
                            break block20;
                        }
                        if (!"99".equals(this.getPriceStg().getRaw())) break block22;
                        en.setOrderType(99);
                        en.setPrice(this.getPrice());
                        break block20;
                    }
                    en.setOrderType(49);
                    en.setPrice(this.getPriceProtected());
                    switch (this.getPriceTypeMktStg().getRaw()) {
                        case "SH1": {
                            en.setMaxLevels(5);
                            en.setTif(66);
                            break;
                        }
                        case "SH2": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SH3": {
                            en.setMaxLevels(1);
                            en.setTif(48);
                            break;
                        }
                        case "SH4": {
                            en.setMaxLevels(0);
                            en.setTif(48);
                            break;
                        }
                    }
                }
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setSecName(this.mktItem.getRefItem().getName());
                enList.add(en);
            }
        }
        return enList;
    }

    public List<NewInstructionReq> getOrderAdvices() throws MException {
        LinkedList<NewInstructionReq> adviceList = new LinkedList<NewInstructionReq>();
        for (TreeItem acc : this.accTreeModel.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            SimpleDetail detail;
            Instruction ins;
            NewInstructionReq req;
            block23: {
                block24: {
                    block22: {
                        WorkflowTemplate workflowTemplate = this.workFlowAccountMap.get(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                        if (workflowTemplate == null) continue;
                        req = new NewInstructionReq();
                        ins = new Instruction();
                        Instrument instrument = new Instrument();
                        detail = new SimpleDetail();
                        ins.setName(this.mktItem.getRefItem().getName());
                        ins.setType("SimpleDetail");
                        ins.setFlowAttrId(workflowTemplate.getInstanceId());
                        ins.setProductId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
                        if ("1".equals(workflowTemplate.getNode().getFrozenCapital())) {
                            ins.setDoFreezeCash();
                        }
                        if ("1".equals(workflowTemplate.getNode().getFrozenVouchers())) {
                            ins.setDoFreezeSec();
                        }
                        if ("1".equals(workflowTemplate.getNode().getFastApprove())) {
                            ins.setDoFastApprove();
                        }
                        ins.setDoRiskCheck();
                        detail.setType("type.googleapis.com/proto.instruction.SimpleDetail");
                        detail.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
                        instrument.setSecurityId(this.mktItem.getRefItem().getCode());
                        instrument.setSymbol(this.mktItem.getRefItem().getName());
                        instrument.setMarketGroup(MarketUtils.findMarketGrp((String)this.mktItem.getRefItem().getMarket()));
                        instrument.setMarket(this.mktItem.getRefItem().getMarket());
                        instrument.setApplId("800");
                        instrument.setMarketIndicator("COMMON_STOCK");
                        instrument.setSecurityType(this.mktItem.getRefItem().getType());
                        instrument.setCurrencyId("CNY");
                        instrument.setSecurityGroup(this.mktItem.getRefItem().getLevelInfo());
                        instrument.setSecuritySubType(this.mktItem.getRefItem().getSubSecurityType());
                        detail.setInstrument(instrument);
                        detail.setSide(this.buy.get() ? Side.SIDE_BUY : Side.SIDE_SELL);
                        detail.setPrice(this.price.get());
                        if (!"50".equals(this.getPriceStg().getRaw())) break block22;
                        detail.setOrdType(OrdType.ORD_TYPE_LIMIT);
                        detail.setPriceRestriction(Integer.valueOf(this.getPriceTypeLimitedStg().getRaw()).intValue());
                        detail.setPrice(this.getPrice());
                        if ("3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                            detail.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
                        }
                        break block23;
                    }
                    if (!"0".equals(this.getPriceStg().getRaw())) break block24;
                    detail.setOrdType(OrdType.ORD_TYPE_LIMIT);
                    detail.setPlateLevels(Integer.valueOf(this.getPriceTypeBidAskStg().getRaw()) + 11);
                    detail.setPrice(this.getPrice());
                    break block23;
                }
                if ("99".equals(this.getPriceStg().getRaw())) break block23;
                detail.setOrdType(OrdType.ORD_TYPE_MARKET);
                detail.setPrice(this.getPriceProtected());
                detail.setStopPrice(this.getPriceProtected());
                switch (this.getPriceTypeMktStg().getRaw()) {
                    case "SH1": {
                        detail.setMaxPriceLevels(5);
                        detail.setTif(TimeInForce.TIF_GFD);
                        break;
                    }
                    case "SH2": {
                        detail.setTif(TimeInForce.TIF_IOC);
                        detail.setMaxPriceLevels(5);
                        break;
                    }
                    case "SH3": {
                        detail.setMaxPriceLevels(1);
                        detail.setTif(TimeInForce.TIF_DAY);
                        break;
                    }
                    case "SH4": {
                        detail.setMaxPriceLevels(0);
                        detail.setTif(TimeInForce.TIF_DAY);
                        break;
                    }
                }
            }
            ArrayList<AccntSecInfo> list = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSecInfo = new AccntSecInfo();
                AccountId accountID = new AccountId();
                accountID.setCashAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId());
                accountID.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSecInfo.setAccountId(accountID);
                accntSecInfo.setOrderQty((double)(orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount()));
                accntSecInfo.setOrderAmount((double)orderQty * detail.getPrice());
                list.add(accntSecInfo);
            }
            detail.setAccntSecInfo(list);
            ins.setDetail((Object)detail);
            req.setInstruction(ins);
            adviceList.add(req);
        }
        return adviceList;
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public void create(String instructType) {
        this.accTreeModel.setInstructType(instructType);
        try {
            this.accTreeModel.create();
        }
        catch (MException | Exception e) {
            logger.error("\u521b\u5efa\u8d26\u53f7\u6811\u51fa\u9519", e);
        }
    }

    public ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public ObjectProperty<MxNode> priceTypeMktStgProperty() {
        return this.priceTypeMktStg;
    }

    public MxNode getPriceTypeMktStg() {
        return (MxNode)this.priceTypeMktStgProperty().get();
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStgProperty().set((Object)priceTypeMktStg);
    }

    public ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    public boolean isSpecify() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("2");
    }

    public boolean isAfterHours() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public boolean isUpLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("1");
    }

    public boolean isDownLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("4");
    }

    private void limitStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("1");
        node.addNode("3");
        node.setRaw(oldNodeRaw.equals("4") ? "1" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void limitStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("4");
        node.addNode("3");
        node.setRaw(oldNodeRaw.equals("1") ? "4" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void initPriceGear(MxNode node) {
        node.removeOthers("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    private MxNode initMarketType(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.setRaw("0");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode neeqMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SH1");
        node.addNode("SH2");
        node.addNode("SH3");
        node.addNode("SH4");
        node.removeNode("0");
        node.setRaw("SH1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    public boolean isMktPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("49");
    }

    public boolean isBidAskPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("0");
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public ObjectProperty<MxNode> priceTypeAfterHoursProperty() {
        return this.priceTypeAfterHours;
    }

    public MxNode getPriceTypeAfterHours() {
        return (MxNode)this.priceTypeAfterHoursProperty().get();
    }

    public void setPriceTypeAfterHours(MxNode priceTypeAfterHours) {
        this.priceTypeAfterHoursProperty().set((Object)priceTypeAfterHours);
    }

    public DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public NeeqAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    public Map<String, WorkflowTemplate> getWorkFlowAccountMap() {
        return this.workFlowAccountMap;
    }

    public void setWorkFlowAccountMap(Map<String, WorkflowTemplate> workFlowAccountMap) {
        this.workFlowAccountMap = workFlowAccountMap;
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }
}

