/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.neeq.Creation;
import cms.tmx.http.neeq.CreationServiceApi;
import cms.tmx.http.neeq.GetRfqResultsReq;
import cms.tmx.http.neeq.GetRfqResultsResp;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.http.neeq.RfqStatus;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NeeqRfqResultModel
extends MxModel {
    @Inject
    protected CreationServiceApi api;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected List<RfqResult> list = new LinkedList<RfqResult>();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected Gson gson = new Gson();
    protected Map<String, Creation> map = new HashMap<String, Creation>();

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | Exception e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
        if (this.list.size() == 0) {
            try {
                this.query();
            }
            catch (MException | Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @PreDestroy
    private void destory() {
    }

    public void query() throws Exception, MException {
        try {
            LinkedList<String> ids = new LinkedList<String>();
            List fundAccountList = this.fundApi.getNeeqFundAccountList();
            for (FundAccount fundAccount : fundAccountList) {
                ids.add(fundAccount.getNewCashAccntId());
            }
            this.list.clear();
            for (String id : ids) {
                try {
                    GetRfqResultsReq req = new GetRfqResultsReq();
                    req.setOpUser(this.baseApi.getHttpOpUser());
                    req.setApplId("800");
                    req.setMarketGroup("CCS");
                    req.setCashAccntId(id);
                    Fragment fragment = new Fragment();
                    fragment.setOffset(0);
                    fragment.setSize(200);
                    req.setFragment(fragment);
                    GetRfqResultsResp resp = this.api.getRfqResults(req);
                    if (resp.getData() == null) continue;
                    this.list.addAll(resp.getData());
                    int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / 200.0);
                    while (--queryTimes > 0) {
                        fragment.setOffset(fragment.getOffset());
                        req.setFragment(fragment);
                        GetRfqResultsResp res = this.api.getRfqResults(req);
                        this.list.addAll(res.getData());
                    }
                }
                catch (MException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.list = this.list.stream().distinct().collect(Collectors.toList());
            for (RfqResult rfq : this.list) {
                rfq.setExtraFields();
            }
            this.changed();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public List<RfqResult> getList() {
        return this.list;
    }

    public List<RfqResult> getFaildList(String id) {
        LinkedList<RfqResult> fail = new LinkedList<RfqResult>();
        for (RfqResult rfqResult : this.list) {
            if (!rfqResult.getInstrument().getSecurityId().equals(id) || rfqResult.getStatus() != RfqStatus.kStatusCanceled) continue;
            fail.add(rfqResult);
        }
        return fail;
    }

    public List<RfqResult> getListById(String id) {
        LinkedList<RfqResult> data = new LinkedList<RfqResult>();
        for (RfqResult rfqResult : this.list) {
            if (!rfqResult.getInstrument().getSecurityId().equals(id)) continue;
            data.add(rfqResult);
        }
        return data;
    }

    public List<RfqResult> getSuccessList(String id) {
        LinkedList<RfqResult> success = new LinkedList<RfqResult>();
        for (RfqResult rfqResult : this.list) {
            if (!rfqResult.getInstrument().getSecurityId().equals(id) || rfqResult.getStatus() != RfqStatus.kStatusCreated) continue;
            success.add(rfqResult);
        }
        return success;
    }

    public List<RfqResult> getSuccessList(String id, String investorId, String investorSecId) {
        LinkedList<RfqResult> success = new LinkedList<RfqResult>();
        for (RfqResult rfqResult : this.list) {
            if (!rfqResult.getInstrument().getSecurityId().equals(id) || rfqResult.getStatus() != RfqStatus.kStatusCreated || !investorId.equals(rfqResult.getInvestorId()) || !investorSecId.equals(rfqResult.getInvestorSecId())) continue;
            success.add(rfqResult);
        }
        return success;
    }
}

