/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MScheduler;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.http.query.Condition;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.NewPositionModel;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.INewRefMng;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
public class NeeqPositionModel
extends NewPositionModel<ObPosition> {
    @Inject
    private FundAccountMngServiceImpl accntMngService;
    @Inject
    protected MarketDataModel marketMng;
    @Inject
    protected INewRefMng refMng;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private EPartService eps;
    @Inject
    protected ScheduledExecutorService ses;
    @Inject
    private FundAccName fundAccName;
    private Map<String, Position> map = new HashMap<String, Position>();
    private static final List<String> parts = Arrays.asList("cms.tmx.neeq.part.regular.position.query");
    private Map<String, ObPosition> ccsPstMap;
    protected BooleanProperty mapChange = new SimpleBooleanProperty(true);
    private InvalidationListener lst = ob -> {
        this.ccsPstMap = this.getList().stream().collect(Collectors.toMap(ObPosition::unique, p -> p, (old, now) -> old));
        this.mapChange();
    };

    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        this.setMarketIndicator("");
        this.setMarkets(new String[]{"NEEQ"});
        super.init();
        this.changed.addListener(this.lst);
    }

    protected List<String> getParts() {
        return parts;
    }

    public Set<String> getNewSecAccntIds() {
        return this.accntMap.getNewSecAccntIds(new String[]{"NEEQ"});
    }

    public QueryFilter getQueryFilter() {
        QueryFilter filter = new QueryFilter();
        HashMap<String, Condition> arg = new HashMap<String, Condition>();
        Condition market = new Condition();
        market.setStringVal("NEEQ");
        market.setOp(Condition.OP.EQ);
        arg.put("market", market);
        filter.setArg(arg);
        return filter;
    }

    protected void update(List<PositionNew> listSrc) {
        List<ObPosition> listPosition = this.updatePosition(listSrc, true);
        this.list.update(listPosition);
        this.changed();
    }

    private List<ObPosition> updatePosition(List<PositionNew> listSrc, boolean isAll) {
        ArrayList<ObPosition> listOb = new ArrayList<ObPosition>();
        for (PositionNew posNew : listSrc) {
            if (!this.getMarkets().contains(posNew.getInstrument().getMarket())) continue;
            this.afterUpdate(posNew);
            ObPosition obPos = new ObPosition();
            obPos.update((Object)posNew);
            obPos.setUnit(QueryUtils.getUnit((String)obPos.getSecType(), (String)obPos.getMarket().getRaw()));
            obPos.setInvestorName(this.fundAccName.getFundName(obPos.getInvestorId()));
            listOb.add(obPos);
        }
        this.exe.execute(() -> {
            if (isAll) {
                this.queryAndGetNewPrice(listOb);
                this.list.update(listOb);
            }
            this.changed();
        });
        return listOb;
    }

    protected void updatePosition(Position position) {
        this.afterUpdate(position);
        position.setUnit(QueryUtils.getUnit((String)position.getInstrument().getSecurityType(), (String)position.getInstrument().getMarket()));
        String key = String.valueOf(position.getPosAccnt().getSecAccntId()) + position.getInstrument().getSecurityId() + position.getPosStatistic().getStatus();
        Position old = this.map.get(key);
        if (old == null) {
            this.map.put(key, position);
            ObPosition ob = new ObPosition();
            ob.update((Object)position);
            ob.setInvestorName(this.fundAccName.getFundName(ob.getInvestorId()));
            this.list.add((MxObject)ob);
        } else {
            old.update((Object)position);
        }
        this.changed();
    }

    private void afterUpdate(PositionNew position) {
        if (position.getAccntId() != null) {
            position.setInvestorId(this.accntMngService.getCcsInvesId(position.getAccntId()));
        }
        if (position.getSecAccntId() != null) {
            position.setInvestorSecId(this.accntMap.getAllCcsInverstorSecId(position.getSecAccntId()));
        }
    }

    private void afterUpdate(Position position) {
        if (position.getPosAccnt().getAccntId() != null) {
            position.setInvestorId(this.accntMngService.getCcsInvesId(position.getPosAccnt().getAccntId()));
        }
        if (position.getPosAccnt().getSecAccntId() != null) {
            position.setInverstorSecId(this.accntMap.getAllCcsInverstorSecId(position.getPosAccnt().getSecAccntId()));
        }
    }

    public void queryNewPrice() {
        try {
            boolean isVisible = false;
            for (String partId : parts) {
                MPart findPart = this.eps.findPart(partId);
                if (findPart == null || !this.eps.isPartVisible(findPart)) continue;
                isVisible = true;
                this.logger.info(String.valueOf(partId) + "\u53ef\u89c1");
                break;
            }
            if (isVisible) {
                this.queryAndGetNewPrice(this.getList());
            } else {
                this.logger.info("\u65e0\u8d44\u91d1\u8d26\u53f7\u6301\u4ed3\u9875\u9762\u53ef\u89c1");
            }
        }
        catch (Exception e) {
            this.logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    public synchronized void queryAndGetNewPrice(List<ObPosition> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (ObPosition t : posList) {
            RefItem item = this.refMng.getItem(t.getInstrument().getSecurityType(), t.getInstrument().getMarket(), t.getInstrument().getSecurityId());
            if (item == null) continue;
            listItem.add(item);
        }
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem);
        }
        for (ObPosition posi : posList) {
            BigDecimal b;
            double cost;
            RefItem refItem = this.refMng.getItem(posi.getInstrument().getSecurityType(), posi.getInstrument().getMarket(), posi.getInstrument().getSecurityId());
            if (refItem == null) continue;
            MarketItem marketItem = (MarketItem)((Map)this.marketMng.getMapInfo().get(refItem)).get(String.valueOf(refItem.getMarket()) + refItem.getCode());
            if (marketItem != null) {
                posi.setClosePrice(marketItem.getClosePrice());
                if (marketItem.getNowPrice() == 0.0) {
                    posi.setNowPrice(marketItem.getClosePrice());
                } else {
                    posi.setNowPrice(marketItem.getNowPrice());
                }
            }
            if ((cost = (b = new BigDecimal(posi.getCost())).setScale(4, 4).doubleValue()) == 0.0) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            if (posi.getNowPrice() == 0.0) continue;
            posi.setMarketValue(QueryUtils.calAmountByMarketAndSecType((String)posi.getInstrument().getMarket(), (String)posi.getInstrument().getSecurityType(), (double)new Double(posi.getSecBalance()).longValue(), (double)posi.getNowPrice()));
            posi.setFloatPnl(posi.getMarketValue() - posi.getHoldCostAmt());
        }
        this.changed();
    }

    protected void mapChange() {
        this.mapChangeProperty().set(!this.mapChangeProperty().get());
    }

    public BooleanProperty mapChangeProperty() {
        return this.mapChange;
    }

    public boolean isMapChange() {
        return this.mapChangeProperty().get();
    }

    public void setMapChange(boolean mapChange) {
        this.mapChangeProperty().set(mapChange);
    }

    public double getCanSell(SecAccount secAcc, String security) {
        ObPosition pos = this.getPosition(secAcc, security);
        if (pos != null) {
            return pos.getSecAvail();
        }
        return 0.0;
    }

    public ObPosition getPosition(SecAccount account, String code) {
        return this.getPosition(account.getExtSecAccntId(), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObPosition getPosition(String account, String code) {
        ObPosition item = null;
        if (this.ccsPstMap == null || this.ccsPstMap.isEmpty()) {
            MxList mxList = this.list;
            synchronized (mxList) {
                for (ObPosition pos : this.getList()) {
                    if (!account.equals(pos.getSecAccntId()) || !code.equals(pos.getSecurityId())) continue;
                    item = pos;
                    break;
                }
            }
        } else {
            item = this.ccsPstMap.get(String.valueOf(account) + code + "0");
        }
        return item;
    }
}

