/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersReq;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NeeqOrderModel
extends MxModel {
    private static final String COMMON_STOCK = "COMMON_STOCK";
    @Inject
    protected OrderServiceApi api;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<SingleOrder> list = new MxList();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    protected boolean isUnfinishedOrder = false;
    protected Map<String, SingleOrder> map = new HashMap<String, SingleOrder>();
    protected ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    Map<String, FundAccount> accMap = new HashMap<String, FundAccount>();
    LinkedList<String> ids = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!"NEEQ".equals(order.getInstrument().getMarket())) {
                return;
            }
            if (!COMMON_STOCK.equals(order.getInstrument().getMarketIndicator())) {
                return;
            }
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210+++" : "\u59d4\u6258+++") + " (sysOrderId:" + order.getOrderId() + ", orderId:" + order.getOrderId() + ", price:" + order.getPrice() + ", status:" + order.getOrdStatus() + ", qty:" + order.getOrderQty() + ", dealQty:" + order.getCumQty() + ")" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210---" : "\u59d4\u6258---") + ", sysOrderId:" + sysOrderId + ", statusOld:" + statusOld + ", statusNow:" + statusNow + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.accMap.get(order.getInvestorId()) != null) {
                    order.setInvestorName(this.accMap.get(order.getInvestorId()).getAccountName());
                }
                if (this.isUnfinishedOrder) {
                    if (order.getCanCancelFlag() == 1) {
                        this.list.updatePart((MxObject)order);
                    } else if (this.list.getListMap().get(order) != null) {
                        this.list.remove((MxObject)order);
                    }
                } else {
                    this.list.updatePart((MxObject)order);
                }
            }
        }
        this.changed();
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    protected Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount fundAccount : fundAccountList) {
            this.ids.add(fundAccount.getNewCashAccntId());
            this.accMap.put(fundAccount.getInvestId(), fundAccount);
        }
        if (this.list.getList().size() == 0) {
            try {
                this.query();
            }
            catch (MException | Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query() throws IOException, MException {
        GetSingleOrdersReq req = new GetSingleOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("CCS");
        req.setApplId("800");
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator(COMMON_STOCK);
        req.setInstrument(instrument);
        if (this.isUnfinishedOrder) {
            req.setCanCancelFlag(1);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount fundAccount : fundAccountList) {
            this.ids.add(fundAccount.getNewCashAccntId());
            this.accMap.put(fundAccount.getInvestId(), fundAccount);
        }
        if (this.ids.isEmpty()) {
            return;
        }
        req.setExtCashAccntId(this.ids);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSingleOrdersResp resp = this.api.getOrders(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getOrder());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetSingleOrdersResp res = this.api.getOrders(req);
            this.list.addAll(res.getOrder());
        }
        for (SingleOrder order : this.list.getList()) {
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setInvestorName(this.accMap.get(order.getInvestorId()).getAccountName());
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.map.put(order.getOrderId(), order);
        }
        this.changed();
    }

    public List<SingleOrder> getList() {
        return this.list.getList();
    }
}

