/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.http.accnt.dto.AccntAggreement;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.neeq.model.NeeqAccountDistributionModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NeeqInquiryAccountDistributionModel
extends NeeqAccountDistributionModel {
    @Inject
    private MEventService es;
    protected IssueInfo info;
    protected String issueType = "";

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("neeq.one.key.check.accnt", event -> {
            String str = event.getStr("type");
            if (str == null || !this.issueType.equals(str)) {
                return;
            }
            LinkedList<CcsFundAccount> list = new LinkedList<CcsFundAccount>();
            for (CcsAccountDistribution item : this.accMxList.getOrList()) {
                if (!item.isSelected()) continue;
                list.add(item.getAcc());
            }
            event.put((Object)"data", list);
            LinkedList<SecAccount> secAccounts = new LinkedList<SecAccount>();
            for (String each : this.mapSecDisMxList.keySet()) {
                for (CcsAccountDistribution sub : ((MxTreeList)this.mapSecDisMxList.get(each)).getOrList()) {
                    if (!sub.isSelected()) continue;
                    secAccounts.add(sub.getSecAcc());
                }
            }
            event.put((Object)"para", secAccounts);
        });
    }

    public void selectInvestorSec(String investorSec, String mkt) {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (CcsAccountDistribution sub : ((MxTreeList)this.mapSecDisMxList.get(each)).getOrList()) {
                if (!sub.getSecAcc().getInverstorSecId().equals(investorSec) || !sub.getSecAcc().getExchange().getRaw().equals(mkt)) continue;
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    @Override
    protected void checkSingle() {
        this.setSingle(this.accMxList.getObList().size() == 1);
        if (!this.isSingle()) {
            return;
        }
        for (MxTreeList secMxList : this.mapSecDisMxList.values()) {
            int neeq = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("NEEQ")).size();
            this.setSingle(neeq < 2);
            if (this.isSingle()) continue;
            return;
        }
        this.mapSecDisMxList.values().forEach(each -> each.getOrList().forEach(sec -> sec.setSelected(true)));
        this.accMxList.getObList().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(true));
    }

    @Override
    protected void filterSecAcc() {
        String exchange = this.info.getSecurity().getInstrument().getMarket();
        if (exchange.equals("NEEQ")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showNEEQ((MxTreeList<CcsAccountDistribution>)((MxTreeList)this.mapSecDisMxList.get(each))));
        }
    }

    @Override
    protected void showNEEQ(MxTreeList<CcsAccountDistribution> distList) {
        for (CcsAccountDistribution dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("NEEQ")) {
                dist.setShow(false);
                continue;
            }
            if (!dist.isHasAgreementsException() && !this.checkAcc(dist, this.refItem)) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean checkAcc(CcsAccountDistribution dist, RefItem refItem) {
        String accId = dist.getAccParentCashId();
        String extSecAccntId = dist.getSecAcc().getExtSecAccntId();
        try {
            AccntAggreement agrmt;
            List<AccntAggreement> accntAggreement = this.agreementModel.getAccntAggreement(accId, extSecAccntId);
            Iterator<AccntAggreement> iterator = accntAggreement.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (this.getWeight(agrmt = iterator.next()) <= 75);
            return true;
        }
        catch (MException | Exception e) {
            dist.setHasAgreementsException(true);
            this.logger.error("\u6821\u9a8c\u8d26\u53f7\u65b0\u4e09\u677f\u6295\u8d44\u6743\u9650\u5931\u8d25\uff1a", e);
            return true;
        }
    }

    @Override
    public synchronized void filterAcc() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        if (this.info == null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll((MxTreeList)this.mapSecDisMxList.get(each)));
            this.showAll(this.accMxList);
        } else {
            this.filterSecAcc();
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.calCount();
    }

    public IssueInfo getInfo() {
        return this.info;
    }

    public void setInfo(IssueInfo info) {
        this.info = info;
    }
}

