/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.GetExecutionsReq;
import cms.tmx.http.api.strategy.dto.GetExecutionsResp;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NeeqDealModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    protected ScheduledExecutorService ses;
    private Gson gson = new Gson();
    private List<Execution> list = new ArrayList<Execution>();
    private Map<String, Execution> map = new HashMap<String, Execution>();
    private Map<String, FundAccount> accMap = new HashMap<String, FundAccount>();
    private LinkedList<String> ids = new LinkedList();
    private MEventHandler handler = event -> this.onPush(event);

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)this.gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution exec : execEvent.getExecution()) {
            if (!"NEEQ".equals(exec.getInstrument().getMarket())) {
                return;
            }
            exec.setExtraFields();
            exec.setUnit("\u80a1");
            exec.setAccountName(this.accMap.get(exec.getInvestorId()).getAccountName());
            this.map.put(exec.getExecId(), exec);
            this.list.add(exec);
        }
        this.changed();
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("uap.push.ExecEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount acc : fundAccountList) {
            this.ids.add(acc.getNewCashAccntId());
            this.accMap.put(acc.getInvestId(), acc);
        }
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.ExecEvent", this.handler);
    }

    public void query() throws IOException, MException {
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("CCS");
        req.setApplId("800");
        if (this.ids.isEmpty()) {
            return;
        }
        req.setExtCashAccntId(this.ids);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = LocalDate.now().format(formatter);
        req.setBeginDate(date);
        req.setEndDate(date);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExecutionsResp resp = this.api.getDeals(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getExecution());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExecutionsResp res = this.api.getDeals(req);
            this.list.addAll(res.getExecution());
        }
        for (Execution exe : this.list) {
            exe.setExtraFields();
            exe.setUnit("\u80a1");
            exe.setAccountName(this.accMap.get(exe.getInvestorId()).getAccountName());
            this.map.put(exe.getExecId(), exe);
        }
        this.changed();
    }

    public Map<String, FundAccount> getAccMap() {
        return this.accMap;
    }

    public List<Execution> getList() {
        return this.list;
    }
}

