/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.neeq.Creation;
import cms.tmx.http.neeq.CreationServiceApi;
import cms.tmx.http.neeq.GetCreationsReq;
import cms.tmx.http.neeq.GetCreationsResp;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NeeqCreationModel
extends MxModel {
    @Inject
    protected CreationServiceApi api;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected List<Creation> list = new LinkedList<Creation>();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected Gson gson = new Gson();
    protected Map<String, Creation> map = new HashMap<String, Creation>();
    private String startDate;
    private String endDate;
    @Inject
    private ExecutorService exe;

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | Exception e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
    }

    @PreDestroy
    private void destory() {
    }

    public void query() throws Exception, MException {
        this.exe.execute(() -> {
            LinkedList<String> ids = new LinkedList<String>();
            List fundAccountList = this.fundApi.getNeeqFundAccountList();
            for (FundAccount fundAccount : fundAccountList) {
                ids.add(fundAccount.getNewCashAccntId());
            }
            this.list.clear();
            for (String id : ids) {
                try {
                    GetCreationsReq req = new GetCreationsReq();
                    req.setOpUser(this.baseApi.getHttpOpUser());
                    req.setApplId("800");
                    req.setMarketGroup("CCS");
                    req.setCashAccntId(id);
                    req.setBeginDate(this.startDate);
                    req.setEndDate(this.endDate);
                    Fragment fragment = new Fragment();
                    fragment.setOffset(0);
                    fragment.setSize(200);
                    req.setFragment(fragment);
                    GetCreationsResp resp = this.api.getCreations(req);
                    if (resp.getData() == null) continue;
                    this.list.addAll(resp.getData());
                    int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / 200.0);
                    while (--queryTimes > 0) {
                        fragment.setOffset(fragment.getOffset());
                        req.setFragment(fragment);
                        GetCreationsResp res = this.api.getCreations(req);
                        this.list.addAll(res.getData());
                    }
                    for (Creation creation : this.list) {
                        creation.setExtraFields();
                    }
                }
                catch (MException | Exception e) {
                    this.logger.error((Object)e, e);
                }
            }
            this.list = this.list.stream().distinct().collect(Collectors.toList());
            this.changed();
        });
    }

    public List<Creation> getList() {
        return this.list;
    }

    public boolean hasEffectiveCreation(String id) {
        for (Creation creation : this.list) {
            if (!creation.getInstrument().getSecurityId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}

