/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.accnt.dto.AccntAggreement;
import cms.tmx.http.api.Instrument;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.neeq.model.NeeqAccntAggreementQueryModel;
import cms.tmx.neeq.model.NeeqPositionModel;
import cms.tmx.query.current.models.InstructionAccountModelNew;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import com.alibaba.druid.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NeeqAccountDistributionModel
extends CcsAccountDistributionModel {
    private ObSimpleInstruction instruction;
    @Inject
    private NeeqPositionModel posModel;
    @Inject
    protected NeeqAccntAggreementQueryModel agreementModel;
    @Inject
    private MxAlert alert;
    @Inject
    private InstructionAccountModelNew instructionAccModel;
    @Inject
    private MEventService es;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    protected void checkSingle() {
        this.setSingle(this.accMxList.getObList().size() == 1);
        if (!this.isSingle()) {
            return;
        }
        for (MxTreeList secMxList : this.mapSecDisMxList.values()) {
            int neeq = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("NEEQ")).size();
            this.setSingle(neeq < 2);
            if (this.isSingle()) continue;
            return;
        }
        this.mapSecDisMxList.values().forEach(each -> each.getOrList().forEach(sec -> sec.setSelected(true)));
        this.accMxList.getObList().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(true));
    }

    protected void filterSecAcc() {
        String exchange = this.refItem.getMarket();
        if (exchange.equals("NEEQ")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showNEEQ((MxTreeList<CcsAccountDistribution>)((MxTreeList)this.mapSecDisMxList.get(each))));
        }
    }

    protected void showNEEQ(MxTreeList<CcsAccountDistribution> distList) {
        for (CcsAccountDistribution dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("NEEQ")) {
                dist.setShow(false);
                continue;
            }
            if (!this.isBuy() && dist.getCanSell() == 0L && !this.isRepo()) {
                dist.setShow(false);
                continue;
            }
            if (!dist.isHasAgreementsException() && this.refItem != null && !this.checkAcc(dist, this.refItem)) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    protected void createTree() {
        ((CcsAccountDistribution)this.root.getValue()).setSelected(this.isSelected());
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new ConcurrentHashMap(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, this.root.getChildren(), accList);
        if (this.getAccountMap() == null) {
            return;
        }
        this.mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(this.getAccountMap());
        HashSet accSet = new HashSet(this.mapAccount.keySet());
        StringBuilder sb = new StringBuilder("");
        for (FundAccount acc : accSet) {
            if (!acc.isNeeqEnable()) continue;
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(acc);
            CcsAccountDistribution accDst = new CcsAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.setWeight(this.mapWeight.get(fundAcc.getNewCashAccntId()) == null ? 0 : (Integer)this.mapWeight.get(fundAcc.getNewCashAccntId()));
            accDst.setCount(this.mapQuantiy.get(fundAcc.getNewCashAccntId()) == null ? 0L : (Long)this.mapQuantiy.get(fundAcc.getNewCashAccntId()));
            accList.add(accDst);
            this.logger.info("accList size " + accList.size());
            this.accMxList.update(accList);
            this.logger.info("accMxList size " + this.accMxList.getObList().size());
            this.logger.info("children size " + this.root.getChildren().size());
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : (List)this.mapAccount.get(acc)) {
                if (!"NEEQ".equals(secAcc.getExchange().getRaw())) continue;
                CcsAccountDistribution secDst = new CcsAccountDistribution();
                try {
                    secDst.setAgreements(this.agreementModel.getAccntAggreement(fundAcc.getNewCashAccntId(), secAcc.getExtSecAccntId()));
                }
                catch (MException | Exception e) {
                    sb.append(String.valueOf(fundAcc.getInvestId()) + " " + secAcc.getInverstorSecId() + " \u67e5\u8be2\u65b0\u4e09\u677f\u534f\u8bae\u51fa\u9519 \r\n");
                    this.logger.error(String.valueOf(secAcc.getInverstorSecId()) + "\u67e5\u8be2\u65b0\u4e09\u677f\u534f\u8bae\u51fa\u9519:", e);
                }
                secAccList.add(secDst);
                secDst.setAccParentId(fundAcc.getParentId());
                secDst.setAccParentCashId(fundAcc.getNewCashAccntId());
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setWeight(this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 1 : (Integer)this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()));
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setSelected(this.isSelected());
                secDst.selectedProperty().addListener(ob -> this.onSecAccSelectChange());
                secDst.setCount(this.mapQuantiy.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 0L : (Long)this.mapQuantiy.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()));
            }
            this.logger.info("children size " + this.root.getChildren().size());
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem)this.root.getChildren().get(accList.size() - 1), ((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        if (this.instruction == null && !"".equals(sb.toString())) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, sb.toString()));
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.checkSingle();
    }

    protected void onSecAccSelectChange() {
        this.calCount();
    }

    public synchronized TreeItem<CcsAccountDistribution> create() throws MException {
        this.es.subscribe("reload.neeq.rights", e -> this.reloadNeeqRights());
        this.posModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstPosition));
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.queryPostition();
        this.buy.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    public void refresh() {
        this.fundAccMng.queryFundAccountList();
        this.posModel.query();
    }

    protected void queryPostition() {
        this.exe.execute(() -> this.posModel.initQuery());
    }

    protected void reloadNeeqRights() {
        StringBuilder sb = new StringBuilder("");
        ObservableList accounts = this.root.getChildren();
        for (TreeItem account : accounts) {
            ObservableList secAccounts = account.getChildren();
            for (TreeItem secAccount : secAccounts) {
                try {
                    List<AccntAggreement> aggrements = this.agreementModel.getAccntAggreement(((CcsAccountDistribution)account.getValue()).getAcc().getNewCashAccntId(), ((CcsAccountDistribution)secAccount.getValue()).getSecAcc().getExtSecAccntId());
                    ((CcsAccountDistribution)secAccount.getValue()).setAgreements(aggrements);
                }
                catch (MException | Exception e) {
                    sb.append(String.valueOf(((CcsAccountDistribution)account.getValue()).getAcc().getInvestId()) + " " + ((CcsAccountDistribution)secAccount.getValue()).getSecAcc().getInverstorSecId() + " \u67e5\u8be2\u65b0\u4e09\u677f\u534f\u8bae\u51fa\u9519 \r\n");
                    this.logger.error(String.valueOf(((CcsAccountDistribution)secAccount.getValue()).getSecAcc().getInverstorSecId()) + "\u67e5\u8be2\u65b0\u4e09\u677f\u534f\u8bae\u51fa\u9519:", e);
                }
            }
        }
        if (this.instruction == null && !"".equals(sb.toString())) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, sb.toString()));
        }
    }

    public void calCanBuy() {
        if (this.calSelectedFundAcc() != 1) {
            this.setCanBuy(0L);
            return;
        }
        TreeItem item = (TreeItem)this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).get(0);
        if (item == null) {
            return;
        }
        if (this.isBuy()) {
            if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
                this.setCanBuy(0L);
                return;
            }
            long canBuy = (long)(((CcsAccountDistribution)item.getValue()).getAcc().getAvailable() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            this.setCanBuy(canBuy);
        } else {
            FilteredList subItemList = item.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
            if (subItemList.size() == 1) {
                long cansell = new Double(this.posModel.getCanSell(((CcsAccountDistribution)((TreeItem)subItemList.get(0)).getValue()).getSecAcc(), this.getSecurity())).longValue();
                this.setCanBuy(cansell);
            } else {
                this.setCanBuy(0L);
            }
        }
    }

    public void calAccountCanSell() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (CcsAccountDistribution subItem : ((MxTreeList)this.mapSecDisMxList.get(strEach)).getOrList()) {
                long canSell = new Double(this.posModel.getCanSell(subItem.getSecAcc(), this.getSecurity())).longValue();
                subItem.setCanSell(canSell);
                canSellTotal += canSell;
            }
            for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanSell(canSellTotal);
            }
        }
    }

    protected long calByCanSell(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                CcsAccountDistribution secAccItem = (CcsAccountDistribution)eachSub.getValue();
                long cansell = new Double(this.posModel.getCanSell(secAccItem.getSecAcc(), this.getSecurity())).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((CcsAccountDistribution)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    public void updateFund() {
        for (CcsAccountDistribution each : this.accMxList.getOrList()) {
            FundAccount acc;
            if (StringUtils.isEmpty((String)each.getAcc().getNewCashAccntId()) || (acc = this.fundAccMng.getFundAccountNew(each.getAcc().getNewCashAccntId(), "CCS")) == null) continue;
            each.getAcc().update(CcsFundAccount.class.cast(acc));
            if (this.getPrice() > 0.0 && this.getUnit() != 0) {
                long canBuy = (long)(each.getAcc().getAvailable() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                each.setCanBuy(canBuy);
                continue;
            }
            each.setCanBuy(0L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkAcc(CcsAccountDistribution dist, RefItem refItem) {
        if (!this.isBuy() && this.posModel.getCanSell(dist.getSecAcc(), this.getSecurity()) > 0.0) {
            return true;
        }
        String accId = dist.getAccParentCashId();
        String extSecAccntId = dist.getSecAcc().getExtSecAccntId();
        try {
            AccntAggreement agrmt;
            List<Instrument> secAccountPool = this.agreementModel.getSecAccountPool(dist.getSecAcc().getExtSecAccntId());
            if (secAccountPool != null) {
                for (Instrument instrument : secAccountPool) {
                    if (!instrument.getSecurityId().equals(refItem.getCode())) continue;
                    return true;
                }
            }
            List<AccntAggreement> accntAggreement = this.agreementModel.getAccntAggreement(accId, extSecAccntId);
            Iterator<AccntAggreement> iterator = accntAggreement.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (this.getWeight(agrmt = iterator.next()) <= this.getWeight(refItem));
            return true;
        }
        catch (MException | Exception e) {
            dist.setHasAgreementsException(true);
            this.logger.error("\u6821\u9a8c\u8d26\u53f7\u65b0\u4e09\u677f\u6295\u8d44\u6743\u9650\u5931\u8d25\uff1a", e);
            return true;
        }
    }

    protected int getWeight(AccntAggreement agrmt) {
        switch (agrmt.getAggreementId()) {
            case "1": 
            case "2": {
                return 100;
            }
            case "3": 
            case "4": {
                return 70;
            }
            case "5": 
            case "6": {
                return 70;
            }
            case "B": 
            case "C": {
                return 90;
            }
            case "D": 
            case "E": {
                return 80;
            }
            case "Z": {
                return 70;
            }
        }
        return 100;
    }

    protected int getWeight(RefItem refItem) {
        switch (refItem.getLevelInfo()) {
            case "\u57fa\u7840\u5c42": {
                return 95;
            }
            case "\u521b\u65b0\u5c42": {
                return 85;
            }
            case "\u7cbe\u9009\u5c42": {
                return 75;
            }
        }
        return 100;
    }

    public void fillAccount(ObSimpleInstruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.instruction = instruction;
        List list = instruction.getOrderDetail().getAccntSecInfo();
        if (instruction.getIsOrderStep()) {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getAvailableQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getAvailableQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        } else {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getOrderQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        }
        this.setActive(false);
        this.setSelected(true);
        this.createTree();
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    public final boolean isActive() {
        return this.activeProperty().get();
    }

    public final void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public final StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public final String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public final void setInstructType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public InstructionAccountModelNew getInstructionAccModel() {
        return this.instructionAccModel;
    }

    public void setInstructionAccModel(InstructionAccountModelNew instructionAccModel) {
        this.instructionAccModel = instructionAccModel;
    }
}

