/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.model;

import cms.tmx.core.MException;
import cms.tmx.entity.AccountStatus;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.factory.AccountStatusFactory;
import cms.tmx.http.accnt.GetAccntAggreementReq;
import cms.tmx.http.accnt.GetAccntAggreementResp;
import cms.tmx.http.accnt.MarketServiceApi;
import cms.tmx.http.accnt.dto.AccntAggreement;
import cms.tmx.http.accnt.dto.GetAccntSessionResp;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.data.GetSecPoolsReq;
import cms.tmx.http.data.Scope;
import cms.tmx.http.data.SecPoolServiceApi;
import cms.tmx.http.neeq.CreationServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NeeqAccntAggreementQueryModel
extends MxModel {
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    private CreationServiceApi api;
    @Inject
    private SecPoolServiceApi secPoolsApi;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MarketServiceApi newMarketApi;
    @Inject
    private AccountStatusFactory asf;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount;
    private List<CcsFundAccount> neeqs = new LinkedList<CcsFundAccount>();
    private List<String> neeqIds = new LinkedList<String>();
    private Map<String, List<AccntAggreement>> agreementMap = new HashMap<String, List<AccntAggreement>>();
    private Map<String, List<Instrument>> secPoolMap = new HashMap<String, List<Instrument>>();

    @PostConstruct
    private void init() {
        try {
            this.mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(this.accountMap.getAccountMap());
            this.mapAccount.keySet().forEach(item -> {
                if (item.isNeeqEnable()) {
                    this.neeqs.add((CcsFundAccount)item);
                    this.neeqIds.add(item.getParentId());
                }
            });
            ObservableList loginStatus = FxUtils.newList();
            GetAccntSessionResp accountLoginStatus = this.newMarketApi.getAccountLoginStatus(this.neeqIds);
            if (accountLoginStatus.getAccntSession() != null) {
                accountLoginStatus.getAccntSession().stream().forEach(item -> {
                    AccountStatus accnt = this.asf.create();
                    accnt.update(item);
                    loginStatus.add((Object)accnt);
                });
            }
            LinkedList<String> logoutList = new LinkedList<String>();
            for (AccountStatus accountStatus : loginStatus) {
                if (accountStatus.getStatus() == null || "X003".equals(accountStatus.getStatus().getRaw())) continue;
                logoutList.add(accountStatus.getInvestorId());
            }
            Iterator<CcsFundAccount> it = this.neeqs.iterator();
            while (it.hasNext()) {
                CcsFundAccount next = it.next();
                if (!logoutList.contains(next.getInvestId())) continue;
                it.remove();
            }
        }
        catch (MException | Exception e) {
            this.logger.error("\u65b0\u4e09\u677f\u8d26\u53f7\u6743\u9650\u67e5\u8be2\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    public ObservableList<Instrument> getSecList(String secAccntId) throws MException {
        ObservableList newList = FxUtils.newList();
        if (secAccntId.isEmpty()) {
            return newList;
        }
        GetSecPoolsReq req = new GetSecPoolsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setScopeRef(secAccntId);
        req.setScope(Scope.kScopeSecAccnt);
        List secPools = this.secPoolsApi.getSecPools(req);
        newList.addAll((Collection)secPools);
        this.secPoolMap.put(secAccntId, (List<Instrument>)newList);
        return newList;
    }

    public ObservableList<AccntAggreement> queryAccntAggreement(String accntId, String secAccntId) throws MException {
        ObservableList newList = FxUtils.newList();
        if (accntId.isEmpty()) {
            return newList;
        }
        GetAccntAggreementReq req = new GetAccntAggreementReq();
        req.setCashAccntId(accntId);
        req.setSecAccntId(secAccntId);
        req.setMarketGroup("CCS");
        req.setApplId("800");
        req.setOpUser(this.baseApi.getHttpOpUser());
        GetAccntAggreementResp resp = this.api.getAccntAggreementReq(req);
        if (resp.getData() != null) {
            newList.addAll((Collection)resp.getData());
        }
        this.agreementMap.put(String.valueOf(accntId) + secAccntId, (List<AccntAggreement>)newList);
        return newList;
    }

    public List<AccntAggreement> getAccntAggreement(String accntId, String secAccntId) throws MException {
        if (this.agreementMap.get(String.valueOf(accntId) + secAccntId) == null) {
            this.agreementMap.put(String.valueOf(accntId) + secAccntId, (List<AccntAggreement>)this.queryAccntAggreement(accntId, secAccntId));
        }
        return this.agreementMap.get(String.valueOf(accntId) + secAccntId);
    }

    public List<Instrument> getSecAccountPool(String secAccountId) throws MException {
        if (this.secPoolMap.get(secAccountId) == null) {
            this.secPoolMap.put(secAccountId, (List<Instrument>)this.getSecList(secAccountId));
        }
        return this.secPoolMap.get(secAccountId);
    }

    public List<CcsFundAccount> getNeeqAccntList() {
        return this.neeqs;
    }

    public List<SecAccount> getNeeqSecAccntList(CcsFundAccount ccsFundAccount) {
        List<SecAccount> list = this.mapAccount.get(ccsFundAccount);
        if (list == null) {
            return new LinkedList<SecAccount>();
        }
        list = list.stream().filter(item -> "NEEQ".equals(item.getExchange().getRaw())).collect(Collectors.toList());
        return list;
    }

    public boolean checkAuth(FundAccount fundAcc, SecAccount sec, List<Integer> authList) {
        List<AccntAggreement> aggreements;
        try {
            aggreements = this.getAccntAggreement(fundAcc.getNewCashAccntId(), sec.getExtSecAccntId());
        }
        catch (MException e) {
            this.logger.error("\u4e00\u952e\u7533\u8d2d\u83b7\u53d6\u65b0\u4e09\u6295\u8d44\u6743\u9650\u5931\u8d25", (Throwable)e);
            return false;
        }
        aggreements.stream().forEach(aggItem -> aggItem.initType());
        for (AccntAggreement agg : aggreements) {
            if (!authList.contains(agg.getType())) continue;
            return true;
        }
        return false;
    }
}

