/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.addon;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MAddon;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FuncModule;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.neeq.model.NeeqRfqResultModel;
import cms.tmx.neeq.model.distribution.business.NeeqApplicationOrderModel;
import cms.tmx.neeq.model.distribution.business.NeeqIssueInfoPurchaseModel;
import cms.tmx.rights.IRightService;
import cms.tmx.rights.imp.RightServiceImpl;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class NeeqAddon
extends MAddon {
    @Inject
    private MEventService es;
    @Inject
    private ExecutorService exe;
    @Inject
    protected ScheduledExecutorService ses;
    @Inject
    private MObjFactory of;
    private NeeqApplicationOrderModel orderModel;
    private NeeqIssueInfoPurchaseModel purchaseModel;
    private NeeqRfqResultModel rfqModel;
    private IRightService irs;
    @Inject
    private MxAlert alert;
    private static final String ID = "cms.tmx.neeq.part.application.purchase";

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.pre.login", event -> this.onLogin());
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.onLogin(), 30L, TimeUnit.SECONDS);
        });
    }

    private void onLogin() {
        this.exe.execute(() -> {
            try {
                List<IssueInfo> list;
                Thread.sleep(5000L);
                if (this.irs == null) {
                    this.irs = (IRightService)this.of.create(RightServiceImpl.class);
                }
                boolean hasRight = false;
                List userFuncList = this.irs.getUserFuncList();
                for (FuncModule funcModule : userFuncList) {
                    if (funcModule.getControlId() == null || !ID.equals(funcModule.getControlId().getRaw())) continue;
                    hasRight = true;
                    break;
                }
                if (!hasRight) {
                    return;
                }
                if (this.orderModel == null) {
                    this.orderModel = (NeeqApplicationOrderModel)((Object)((Object)this.of.create(NeeqApplicationOrderModel.class)));
                }
                if (this.purchaseModel == null) {
                    this.purchaseModel = (NeeqIssueInfoPurchaseModel)((Object)((Object)this.of.create(NeeqIssueInfoPurchaseModel.class)));
                }
                if (this.rfqModel == null) {
                    this.rfqModel = (NeeqRfqResultModel)((Object)((Object)this.of.create(NeeqRfqResultModel.class)));
                }
                if ((list = this.purchaseModel.getList()).isEmpty()) {
                    this.purchaseModel.query();
                    list = this.purchaseModel.getList();
                }
                for (IssueInfo issueInfo : list) {
                    List<RfqResult> successList = this.rfqModel.getSuccessList(issueInfo.getSecurity().getInstrument().getSecurityId());
                    if (successList.isEmpty()) continue;
                    for (RfqResult rfq : successList) {
                        if (this.orderModel.hasEffectiveOrder(rfq.getInstrument().getSecurityId(), rfq.getInvestorId(), rfq.getInvestorSecId())) continue;
                        Platform.runLater(() -> this.alert.alert(Alert.AlertType.WARNING, "\u60a8\u5b58\u5728\u6709\u6548\u8be2\u4ef7\uff0c\u6309\u7167\u80a1\u8f6c\u8981\u6c42\uff0c\u5fc5\u987b\u53c2\u4e0e\u7533\u8d2d\uff0c\u8bf7\u524d\u5f80\u6302\u724c\u80a1\u7968\u53d1\u884c-\u7533\u8d2d\u9875\u9762\u5b8c\u6210\u7533\u8d2d"));
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        });
    }
}

