/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core.imps;

import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.utils.JAXB;
import cms.tmx.core.utils.PageXml;
import cms.tmx.core.utils.XmlConfig;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

@Creatable
@Singleton
public class UIServiceImpl
implements IUIService {
    @Inject
    private JAXB jaxb;
    @Inject
    private EPartService ps;
    @Inject
    private MEventService es;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    private List<MStackElement> children;
    private static final Logger logger = LogManager.getLogger(UIServiceImpl.class);

    @PostConstruct
    private void init() {
        this.es.subscribe("ui.navigate", event -> Platform.runLater(() -> {
            boolean bl = this.navigate(event);
        }));
        this.es.subscribe("ui.navigate.multi_open_custom", event -> Platform.runLater(() -> this.multiOpenSync(event)));
        this.es.subscribe("ui.navigate.multi_open", event -> this.multiOpen(event));
        this.es.subscribe("ui.navigate.multi_open.hk", event -> Platform.runLater(() -> this.multiHKOpenSync(event)));
        this.es.subscribe("close.part", event -> Platform.runLater(() -> this.closePart(event)));
    }

    private synchronized void multiOpenSync(MEvent event) {
        String name = event.getStr("part_name");
        String id = event.getStr("id");
        MPart part = this.ps.findPart(id);
        MPart newPart = this.ps.createPart(part.getElementId());
        if (newPart == null) {
            this.createDesc(this.ms, this.app, part, "cms.tmx.app.ps.right".equals(part.getParent().getElementId()));
            newPart = this.ps.createPart(part.getElementId());
        }
        if (newPart != null) {
            newPart.setElementId(String.valueOf(part.getElementId()) + ":" + UUID.randomUUID());
            newPart.setLabel(name);
            part.getParent().getChildren().add(newPart);
            newPart.setToBeRendered(true);
            newPart.setVisible(true);
            this.ps.showPart(newPart, EPartService.PartState.ACTIVATE);
            event.put("new_part", newPart);
        }
    }

    private synchronized void multiHKOpenSync(MEvent event) {
        XmlConfig formXML = this.jaxb.getFormXML();
        event.getStr("part_name");
        String id = event.getStr("id");
        MPart part = this.ps.findPart(id);
        if (formXML == null || part == null) {
            return;
        }
        for (PageXml page : formXML.getPage()) {
            MPart newPart = this.ps.createPart(part.getElementId());
            if (newPart == null) {
                this.createDesc(this.ms, this.app, part, "cms.tmx.app.ps.right".equals(part.getParent().getElementId()));
                newPart = this.ps.createPart(part.getElementId());
            }
            if (newPart == null) continue;
            newPart.setElementId(String.valueOf(part.getElementId()) + ":" + UUID.randomUUID());
            newPart.setLabel(page.getLabel());
            part.getParent().getChildren().add(newPart);
            newPart.setToBeRendered(true);
            newPart.setVisible(true);
            this.ps.showPart(newPart, EPartService.PartState.ACTIVATE);
            part.setElementId(newPart.getElementId());
            part.setVisible(false);
            part.setToBeRendered(false);
            page.setPageId(newPart.getObject() + "=" + newPart.getElementId());
            event.put("new_part", newPart);
        }
        part.setElementId(String.valueOf(part.getElementId()) + "*_*");
        this.jaxb.writeXML();
    }

    private synchronized void multiOpen(MEvent event) {
        FutureTask<Boolean> newPartTask = new FutureTask<Boolean>(() -> {
            String name = event.getStr("part_name");
            String id = event.getStr("id");
            MPart part = this.ps.findPart(id);
            MPart newPart = this.ps.createPart(part.getElementId());
            if (newPart == null) {
                this.createDesc(this.ms, this.app, part, "cms.tmx.app.ps.right".equals(part.getParent().getElementId()));
                newPart = this.ps.createPart(part.getElementId());
            }
            if (newPart != null) {
                newPart.setElementId(String.valueOf(part.getElementId()) + ":" + UUID.randomUUID());
                newPart.setLabel(name);
                part.getParent().getChildren().add(newPart);
                newPart.setToBeRendered(true);
                newPart.setVisible(true);
                this.ps.showPart(newPart, EPartService.PartState.ACTIVATE);
                event.put("new_part", newPart);
            }
            return true;
        });
        Platform.runLater(newPartTask);
        try {
            newPartTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("\u521b\u5efa\u65b0\u9762\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    private synchronized boolean navigate(String perId, String partId, String partName) {
        MPart part = this.ps.findPart(partId);
        if (part == null) {
            return false;
        }
        part.setLabel(partName);
        this.refreshStackChildren();
        if (!part.isToBeRendered()) {
            MCompositePart comPart;
            this.swap(this.children, this.children.indexOf(part));
            if (part instanceof MCompositePart && !(comPart = (MCompositePart)MCompositePart.class.cast(part)).isHorizontal()) {
                this.calHeightIfCompositepart(part);
            }
        }
        if (part != null) {
            part.setVisible(true);
            part.setToBeRendered(true);
            this.ps.showPart(part, EPartService.PartState.ACTIVATE);
        }
        return true;
    }

    private void calHeightIfCompositepart(MPart part) {
        try {
            List findElements = this.ms.findElements((MUIElement)this.app, "cms.tmx.app.ps.right", MPartStack.class, null);
            WLayoutedWidgetImpl cast = (WLayoutedWidgetImpl)WLayoutedWidgetImpl.class.cast(((MPartStack)MPartStack.class.cast(findElements.get(1))).getWidget());
            BorderPane borderPane = (BorderPane)BorderPane.class.cast(cast.getWidgetNode());
            List sChildren = ((MCompositePart)MCompositePart.class.cast(part)).getChildren();
            if (sChildren.size() == 2 && Toolkit.getDefaultToolkit().getScreenSize().height >= 900) {
                double doubleValue = new BigDecimal(523.0 / borderPane.getHeight()).setScale(3, 1).doubleValue();
                ((MPartSashContainerElement)sChildren.get(0)).setContainerData(Double.toString(100000.0 * doubleValue));
                ((MPartSashContainerElement)sChildren.get(1)).setContainerData(Double.toString(100000.0 * (1.0 - doubleValue)));
            } else if (sChildren.size() == 2 && Toolkit.getDefaultToolkit().getScreenSize().height < 900) {
                double doubleValue = new BigDecimal(494.0 / borderPane.getHeight()).setScale(3, 1).doubleValue();
                ((MPartSashContainerElement)sChildren.get(0)).setContainerData(Double.toString(100000.0 * doubleValue));
                ((MPartSashContainerElement)sChildren.get(1)).setContainerData(Double.toString(100000.0 * (1.0 - doubleValue)));
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u4ea4\u6613\u9762\u677f\u9ad8\u5ea6\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public boolean navigate(MEvent event) {
        boolean success = false;
        String name = event.getStr("part_name");
        String type = event.getStr("type");
        if ("dialog".equals(type)) {
            event.put("MethodName", event.getStr("id"));
            this.es.sendEvent("dialogEvent", event);
            success = true;
        } else {
            success = this.navigate(event.getStr("per"), event.getStr("id"), name);
        }
        return success;
    }

    public synchronized void closePart(MEvent event) {
        MPart mPart = event.get(MPart.class, "close_part");
        this.refreshStackChildren();
        int old = this.children.indexOf(mPart);
        int i = old + 1;
        while (i < this.children.size()) {
            if (this.children.get(i).isToBeRendered()) {
                this.ps.activate((MPart)MPart.class.cast(this.children.get(i)), true);
                return;
            }
            ++i;
        }
        i = old - 1;
        while (i > 0) {
            if (this.children.get(i).isToBeRendered()) {
                this.ps.activate((MPart)MPart.class.cast(this.children.get(i)), true);
                return;
            }
            --i;
        }
    }

    private void refreshStackChildren() {
        List findElements = this.ms.findElements((MUIElement)this.app, "cms.tmx.app.ps.right", MPartStack.class, null);
        if (findElements.isEmpty() || !(findElements.get(1) instanceof PartStackImpl)) {
            logger.error("==============find all parts error=================");
            return;
        }
        this.children = ((PartStackImpl)PartStackImpl.class.cast(findElements.get(1))).getChildren();
    }

    public <T> void swap(List<T> list, int oldPosition) {
        T tempElement = list.get(oldPosition);
        list.remove(oldPosition);
        list.add(tempElement);
    }

    @Override
    public void showPart(String partId) {
        try {
            MPart part = this.ps.findPart(partId);
            this.ps.showPart(part, EPartService.PartState.ACTIVATE);
        }
        catch (Exception e) {
            logger.error("\u8df3\u8f6c\u9875\u9762\u5931\u8d25:" + partId, (Throwable)e);
        }
    }

    private void createDesc(EModelService ms, MApplication app, MPart part, boolean closeable) {
        MPartDescriptor desc = (MPartDescriptor)ms.createModelElement(MPartDescriptor.class);
        desc.setElementId(part.getElementId());
        desc.setContributorURI(part.getContributorURI());
        desc.setContributionURI(part.getContributionURI());
        desc.setLabel(part.getLabel());
        desc.setCloseable(closeable);
        desc.setIconURI(part.getIconURI());
        desc.setTooltip(part.getTooltip());
        desc.getTags().addAll(part.getTags());
        desc.getVariables().addAll(part.getVariables());
        desc.getProperties().putAll(part.getProperties());
        desc.getPersistedState().putAll(part.getPersistedState());
        desc.getBindingContexts().addAll(part.getBindingContexts());
        app.getDescriptors().add(desc);
    }

    public static void main(String[] args) {
        int a = 463;
        int b = 931;
        double f1 = new BigDecimal((float)a / (float)b).setScale(3, 1).doubleValue();
        System.out.println("ddd===" + f1 * 100000.0);
    }
}

