/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core.imps;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class MEventServiceImp
implements MEventService {
    private Logger logger;
    private static final String CORE_EVENT = "core_event";
    private static final int SCEDULED_POOL_SIZE = 8;
    private static final int FIXED_QUERY_POOL_SIZE = 8;
    private static final int FIXED_POST_POOL__SIZE = 4;
    private ExecutorService esCached = Executors.newCachedThreadPool(new NamedTreadFactory("es-cached-pool"));
    private ExecutorService postCached = Executors.newFixedThreadPool(4, new NamedTreadFactory("post-cached-pool"));
    private ScheduledExecutorService esScheduled = Executors.newScheduledThreadPool(8, new NamedTreadFactory("scheduled-pool"));
    private ExecutorService fixedQueryPool = Executors.newFixedThreadPool(8, new NamedTreadFactory("fixed-query-pool"));
    private ExecutorService fixedMiseferPool = Executors.newFixedThreadPool(8, new NamedTreadFactory("misefer-pool"));
    private ExecutorService fileorderPool = Executors.newFixedThreadPool(8, new NamedTreadFactory("fileorder-pool"));
    private Map<String, CopyOnWriteArrayList<MEventHandler>> mapHandler = new ConcurrentHashMap<String, CopyOnWriteArrayList<MEventHandler>>();
    private static final String UNIQ_APP_ID = UUID.randomUUID().toString().replaceAll("-", "");
    private final Thread.UncaughtExceptionHandler handle = (thread, throwable) -> {
        block3: {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            if (this.logger != null) {
                this.logger.error("\u7ebf\u7a0b\u5f02\u5e38" + thread.getName() + " " + writer.getBuffer().toString());
            }
            try {
                writer.close();
            }
            catch (Exception e) {
                if (this.logger == null) break block3;
                this.logger.error("\u5173\u95ed\u7ebf\u7a0b\u5f02\u5e38\u8f93\u51fa\u6d41\u51fa\u9519", (Throwable)e);
            }
        }
    };
    public Map<String, AtomicInteger> countMap = new ConcurrentHashMap<String, AtomicInteger>();

    @PostConstruct
    private void init(IEclipseContext ctxt) {
        Thread.setDefaultUncaughtExceptionHandler(this.handle);
        MEvent eCore = new MEvent();
        eCore.put("uuid", UNIQ_APP_ID);
        ctxt.set(CORE_EVENT, (Object)eCore);
        ctxt.set(ExecutorService.class, (Object)this.esCached);
        ctxt.set(ScheduledExecutorService.class, (Object)this.esScheduled);
        ctxt.set("fixed.query.pool", (Object)this.fixedQueryPool);
        ctxt.set("fixed.post.pool", (Object)this.postCached);
        ctxt.set("fixed.mise.pool", (Object)this.fixedMiseferPool);
        ctxt.set("fixed.fileorder.pool", (Object)this.fileorderPool);
    }

    @PreDestroy
    private void close() {
        this.esCached.shutdownNow();
        this.postCached.shutdownNow();
        this.esScheduled.shutdownNow();
        this.fixedQueryPool.shutdownNow();
        this.fixedMiseferPool.shutdownNow();
        this.mapHandler.clear();
    }

    @Override
    public synchronized boolean subscribe(String topic, MEventHandler handler) {
        if (topic == null || topic.isEmpty() || handler == null) {
            return false;
        }
        CopyOnWriteArrayList<MEventHandler> list = this.mapHandler.get(topic);
        if (list != null) {
            if (!list.contains(handler)) {
                list.add(handler);
            }
        } else {
            list = new CopyOnWriteArrayList();
            list.add(handler);
            this.mapHandler.put(topic, list);
        }
        return true;
    }

    @Override
    public synchronized void unSubscribe(String topic, MEventHandler handler) {
        List list = this.mapHandler.get(topic);
        if (list != null) {
            list.remove(handler);
        }
    }

    @Override
    public void sendEvent(String topic, MEvent event) {
        List list = this.mapHandler.get(topic);
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            try {
                if (list.get(i) != null) {
                    ((MEventHandler)list.get(i)).onEvent(event);
                }
            }
            catch (Exception e) {
                this.logger.error("sendEvent\u5931\u8d25,topic:" + topic, (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public void postEvent(String topic, MEvent event) {
        AtomicInteger count;
        List list = this.mapHandler.get(topic);
        if (list == null) {
            return;
        }
        String topicCal = topic;
        if (event != null && event.getObj() != null) {
            topicCal = String.valueOf(topic) + "|" + event.getObj().getClass().getSimpleName();
        }
        if ((count = this.countMap.get(topicCal)) == null) {
            count = new AtomicInteger(0);
            if (event != null) {
                event.getObj();
            }
            this.countMap.put(topicCal, count);
        }
        for (MEventHandler handler : list) {
            count.getAndIncrement();
            if (count.get() % 1000 == 0 && this.logger != null) {
                this.logger.info("topic: " + topicCal + " count:" + count.get());
            }
            this.postCached.execute(() -> handler.onEvent(event));
        }
    }

    @Override
    public void sendEvent(String topic, MEvent event, MEventHandler handler) {
    }

    @Override
    public String getAppId() {
        return UNIQ_APP_ID;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    class NamedTreadFactory
    implements ThreadFactory {
        AtomicInteger count = new AtomicInteger();
        String poolName = "";

        public NamedTreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName(String.valueOf(this.poolName) + "-" + this.count.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

