/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core.imps;

import cms.tmx.core.MCrontabService;
import cms.tmx.core.MObjFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;

@Creatable
@Singleton
public class MCrontabServiceImpl
implements MCrontabService {
    private static final Logger logger = LogManager.getLogger(MCrontabServiceImpl.class);
    private static final String JOB_GROUP = "job_group";
    private Scheduler scheduler;
    List<JobKey> jobKeyList = new ArrayList<JobKey>();
    @Inject
    private MObjFactory of;
    private JobFactory jobFactory = (bundle, scheduler) -> {
        JobDetail jobDetail = bundle.getJobDetail();
        Class jobClass = jobDetail.getJobClass();
        return (Job)this.of.create(jobClass);
    };

    @PostConstruct
    private void init() {
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            this.scheduler.setJobFactory(this.jobFactory);
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            logger.error("quartz init failed" + e.getMessage());
        }
    }

    @Override
    public void addJob(Class<? extends Job> clazz, String cron, int interval, String jobId, String triggerId) throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.setJobFactory(this.jobFactory);
            this.scheduler.start();
        }
        JobDetail job = JobBuilder.newJob(clazz).withIdentity(jobId, JOB_GROUP).build();
        Trigger trigger = null;
        if (cron != null && !"".equals(cron)) {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerId, JOB_GROUP).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
        } else if (interval > 0) {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerId, JOB_GROUP).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)interval)).build();
        }
        if (trigger == null) {
            return;
        }
        this.scheduler.scheduleJob(job, trigger);
    }

    @Override
    public boolean resetJob(Class<? extends Job> clazz, String cron, int interval, String jobId, String triggerId) {
        this.removeJobGroup(this.jobKeyList);
        JobKey jobKey = new JobKey(jobId, JOB_GROUP);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.addJob(clazz, cron, interval, jobId, triggerId);
            return true;
        }
        catch (SchedulerException e) {
            logger.error("\u91cd\u7f6e\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff0cjobId\uff1a" + jobId, (Throwable)e);
            return false;
        }
    }

    @Override
    public void removeJob(String jobId) {
        JobKey jobKey = new JobKey(jobId, JOB_GROUP);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            logger.error("\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff0cjobId\uff1a" + jobId, (Throwable)e);
        }
    }

    private void removeJobGroup(List<JobKey> jobKeyList) {
        if (!jobKeyList.isEmpty()) {
            try {
                this.scheduler.deleteJobs(jobKeyList);
            }
            catch (SchedulerException e) {
                logger.error("\u5220\u9664\u5b9a\u65f6\u7ec4\u4efb\u52a1\u51fa\u9519\uff0cjobKeyList\uff1a" + jobKeyList, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean resetJobGroup(Class<? extends Job> clazz, List<String> crons, int interval, String jobId, String triggerId) {
        this.removeJob(jobId);
        this.jobKeyList.clear();
        try {
            if (this.scheduler == null) {
                this.scheduler = StdSchedulerFactory.getDefaultScheduler();
                this.scheduler.setJobFactory(this.jobFactory);
                this.scheduler.start();
            }
            JobDetail job = null;
            Trigger trigger = null;
            JobBuilder exJobClass = JobBuilder.newJob(clazz);
            TriggerBuilder exTrigger = TriggerBuilder.newTrigger();
            int i = 0;
            while (true) {
                if (i >= crons.size()) {
                    return true;
                }
                JobKey jobKey = new JobKey(String.valueOf(jobId) + i, JOB_GROUP);
                if (this.scheduler.checkExists(jobKey)) {
                    this.scheduler.deleteJob(jobKey);
                }
                String cron = crons.get(i);
                job = exJobClass.withIdentity(String.valueOf(jobId) + i, JOB_GROUP).build();
                if (cron != null && !"".equals(cron)) {
                    trigger = exTrigger.withIdentity(String.valueOf(triggerId) + i, JOB_GROUP).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
                }
                if (trigger == null) {
                    return false;
                }
                this.jobKeyList.add(jobKey);
                this.scheduler.scheduleJob(job, trigger);
                ++i;
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }
}

