/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core.imps;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MProps;
import cms.tmx.core.imps.MEventServiceImp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MConfServiceImp
implements MConfService {
    private Logger logger = LogManager.getLogger(MConfServiceImp.class);
    private MProps propsApp = new MProps();
    private MProps propsUser = new MProps();
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private MEventServiceImp ms;
    private String userDir;
    private String dataDir;
    private String confPath;
    private String baseDir;

    @PostConstruct
    public void init(IEclipseContext ctxt) {
        try {
            this.baseDir = System.getProperty("user.dir");
            ctxt.set("base.path", (Object)this.baseDir);
            this.userDir = Paths.get(this.baseDir, "users").toString();
            new File(this.userDir).mkdirs();
            this.dataDir = Paths.get(this.baseDir, "data").toString();
            new File(this.dataDir).mkdirs();
            Path path = Paths.get(this.baseDir, "conf");
            ctxt.set("conf.path", (Object)path.toString());
            path.toFile().mkdirs();
            this.confPath = path.toString();
            System.setProperty("log4j.configurationFile", String.valueOf(path.toString()) + File.separator + "log4j2.xml");
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            File log4j2 = new File(path.toString(), "log4j2.xml");
            ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(log4j2));
            Configurator.initialize(null, (ConfigurationSource)source);
            this.logger = LogManager.getLogger(MConfServiceImp.class);
            path = Paths.get(path.toString(), "client.properties");
            this.propsApp.load(path.toFile());
            path = Paths.get(this.confPath.toString(), "user.properties");
            this.propsUser.load(path.toFile());
            this.coverProps();
            this.delLog(this.getDelLogDate());
            this.eCore.put("client.type", this.getValueAsInt("client.type", 0));
            this.ms.setLogger(this.logger);
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
    }

    private void coverProps() {
        Set<Object> keySet = this.propsUser.keySet();
        for (Object key : keySet) {
            String keyStr = String.valueOf(key);
            this.propsApp.setValue(keyStr, this.propsUser.get(keyStr));
        }
    }

    private void delLog(String name) {
        File file = new File(Paths.get(this.baseDir, "log").toString());
        File[] files = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return !f.isDirectory();
            }
        });
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(name)) {
                files[i].delete();
            }
            ++i;
        }
    }

    private String getDelLogDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calc = Calendar.getInstance();
        calc.setTime(new Date());
        calc.add(5, -30);
        Date delDate = calc.getTime();
        return sdf.format(delDate);
    }

    @Override
    public String getValue(String key, String def) {
        return this.propsApp.get(key, def);
    }

    @Override
    public void setValue(String key, Object value) {
        this.propsApp.setValue(key, value);
    }

    @Override
    public List<String> getValues(String key) {
        return this.propsApp.getValues(key);
    }

    @Override
    public void setValues(String key, List<String> values) {
        this.propsApp.setValues(key, values);
    }

    @Override
    public String getValue(String key) {
        return this.propsApp.get(key);
    }

    @Override
    public MProps getProps(String file) {
        MProps props = new MProps();
        try {
            props.load(Paths.get(this.confPath, file).toFile());
        }
        catch (Exception e) {
            this.logger.error("[conf service] load props file failed: " + file, (Throwable)e);
        }
        return props;
    }

    @Override
    public File getFile(String name) {
        File file = null;
        try {
            Path path = Paths.get(this.confPath, name);
            file = path.toFile();
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {}
        return file;
    }

    @Override
    public boolean getValueAsBool(String key, boolean def) {
        return this.propsApp.getBool(key, def);
    }

    @Override
    public double getValueAsDouble(String key, double def) {
        return this.propsApp.getDouble(key, def);
    }

    @Override
    public int getValueAsInt(String key, int iDefault) {
        return this.propsApp.getInt(key, iDefault);
    }

    @Override
    public MProps getUserProps() {
        return this.propsUser;
    }
}

