/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core;

import cms.tmx.core.MEventHandler;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MScheduler {
    private static final int MIN_INTERVAL = 100;
    private static final int DEFAULT_INTERVAL = 1000;
    private long timeLast = 0L;
    private boolean sceduled = false;
    private boolean hit = false;
    private int interval = 1000;
    private Lock lock = new ReentrantLock();
    @Inject
    private ScheduledExecutorService ses;

    public void setInterval(int interval) {
        this.interval = interval < 100 ? 100 : interval;
    }

    public void schedule(MEventHandler handler) {
        this.lock.lock();
        if (this.sceduled) {
            this.hit = true;
            this.lock.unlock();
            return;
        }
        this.sceduled = true;
        long now = new Date().getTime();
        long delay = (long)this.interval - (now - this.timeLast < 0L ? 0L : now - this.timeLast);
        if (delay < 0L) {
            delay = 0L;
        }
        this.lock.unlock();
        this.ses.schedule(() -> this.run(handler), delay, TimeUnit.MILLISECONDS);
    }

    public void schedule(MEventHandler handler, boolean alwaysDelay) {
        this.lock.lock();
        if (this.sceduled) {
            this.hit = true;
            this.lock.unlock();
            return;
        }
        this.sceduled = true;
        long now = new Date().getTime();
        long delay = 0L;
        if (alwaysDelay) {
            delay = this.interval;
        } else {
            delay = (long)this.interval - (now - this.timeLast);
            if (delay < 0L) {
                delay = 0L;
            }
        }
        this.lock.unlock();
        this.ses.schedule(() -> this.run(handler), delay, TimeUnit.MILLISECONDS);
    }

    private void done(MEventHandler handler) {
        this.lock.lock();
        this.timeLast = new Date().getTime();
        this.sceduled = false;
        if (this.hit) {
            this.hit = false;
            this.schedule(handler);
        }
        this.lock.unlock();
    }

    private void start() {
        this.lock.lock();
        this.hit = false;
        this.lock.unlock();
    }

    private void run(MEventHandler handler) {
        this.start();
        try {
            handler.onEvent(null);
        }
        finally {
            this.done(handler);
        }
    }
}

