/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core;

import cms.tmx.core.utils.DesEncrypt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javafx.collections.ObservableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MProps
extends Properties {
    private static final Logger logger = LogManager.getLogger(MProps.class);
    private static final long serialVersionUID = -6163567056341850134L;
    private File file;

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            this.file.createNewFile();
            this.store(new FileOutputStream(this.file), "");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void load(File file) {
        this.file = file;
        if (file != null) {
            try {
                file.createNewFile();
                this.load(new FileInputStream(file));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public Enumeration<Object> keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        keyList.sort(null);
        return keyList.elements();
    }

    public String get(String key, String def) {
        String val = this.getProperty(key);
        return val == null ? def : val.trim();
    }

    public String get(String key) {
        return this.get(key, "");
    }

    public int getInt(String key, int def) {
        int ret = def;
        String value = this.get(key);
        if (!value.isEmpty()) {
            ret = Integer.parseInt(value);
        }
        return ret;
    }

    public double getDouble(String key, double def) {
        double ret = def;
        String value = this.get(key);
        if (!value.isEmpty()) {
            ret = Double.parseDouble(value);
        }
        return ret;
    }

    public boolean getBool(String key, boolean def) {
        boolean ret = def;
        String value = this.get(key);
        if (!value.isEmpty()) {
            ret = Boolean.parseBoolean(value);
        }
        return ret;
    }

    public List<String> getValues(String key) {
        String value = this.get(key, "");
        if (!value.isEmpty()) {
            String[] values = value.split("\\|");
            return new ArrayList<String>(Arrays.asList(values));
        }
        return new ArrayList<String>();
    }

    public String getDesValue(String key) {
        String result = "";
        try {
            result = DesEncrypt.decrypt(this.get(key, ""), "SsdfDfdLfFgAsJafSFgasN2f14wfe");
        }
        catch (Exception e) {
            logger.error("properties\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public List<String> getDesValues(String key) {
        String value = this.getDesValue(key);
        if (!value.isEmpty()) {
            String[] values = value.split("\\|");
            return new ArrayList<String>(Arrays.asList(values));
        }
        return new ArrayList<String>();
    }

    public void setValue(String key, Object value) {
        if (key != null && value != null) {
            this.setProperty(key, value.toString().trim());
            this.save();
        }
    }

    public void deleteValue(String key) {
        if (key != null) {
            this.remove(key);
            this.save();
        }
    }

    public void setDesValue(String key, Object value) {
        if (key != null && value != null) {
            try {
                this.setProperty(key, DesEncrypt.encrypt(value.toString().trim()));
                this.save();
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5931\u8d25 key:" + key + " value:" + value, (Throwable)e);
            }
        }
    }

    public void setValues(String key, List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            String raw = value.trim();
            if (sb.length() == 0) {
                sb.append(raw);
                continue;
            }
            sb.append("|");
            sb.append(raw);
        }
        this.setValue(key, sb.toString());
    }

    public void setDesValues(String key, Map<String, ObservableList<String>> map) {
        Set<String> keys = map.keySet();
        StringBuilder sb = new StringBuilder();
        for (String ip : keys) {
            if (map.get(ip).size() == 1) {
                String port = (String)map.get(ip).get(0);
                if (sb.length() == 0) {
                    sb.append(String.valueOf(ip.trim()) + ":" + port.trim());
                    continue;
                }
                sb.append("|" + ip.trim() + ":" + port.trim());
                continue;
            }
            List ports = (List)map.get(ip);
            for (String port : ports) {
                if (sb.length() == 0) {
                    sb.append(String.valueOf(ip.trim()) + ":" + port.trim());
                    continue;
                }
                sb.append("|" + ip.trim() + ":" + port.trim());
            }
        }
        this.setDesValue(key, sb.toString());
    }
}

