/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.core;

import cms.tmx.core.MException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MEvent
extends HashMap<String, Object> {
    private static final String CODE = "event.code";
    private static final String DESC = "event.message";
    private static final String OBJECT = "event.object";
    private int FunctionCode;
    private String id;
    private boolean consumed = false;
    public List<MEvent> children = new LinkedList<MEvent>();
    private static final long serialVersionUID = 8986209755320973468L;

    public MEvent() {
    }

    public MEvent(int initialCapacity) {
        super(initialCapacity);
    }

    public MEvent(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MEvent(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public MEvent(int code, String desc) {
        this.setRes(code, desc);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    public synchronized List<MEvent> getChildren() {
        if (this.children == null) {
            this.children = new LinkedList<MEvent>();
        }
        return this.children;
    }

    public void putStr(String key, Object value) {
        if (value == null) {
            this.put(key, "");
        } else {
            this.put(key, value.toString());
        }
    }

    public <T> T get(Class<T> clazz, String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Override
    public MEvent clone() {
        MEvent event = new MEvent(this);
        return event;
    }

    public void clearResponse() {
        this.remove(CODE);
        this.remove(DESC);
    }

    public void setOK() {
        this.setCode(0);
        this.setDesc("");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObj(Object obj) {
        if (obj != null) {
            this.put(OBJECT, obj);
        }
    }

    public Object getObj() {
        return this.get(OBJECT);
    }

    public Object takeObj() {
        return this.remove(OBJECT);
    }

    public <T> T takeObj(Class<T> clazz) {
        Object obj = this.remove(OBJECT);
        return clazz.cast(obj);
    }

    public <T> T getObj(Class<T> clazz) {
        return this.get(OBJECT, clazz);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object obj = this.get(key);
        return clazz.cast(obj);
    }

    public void copy(MEvent event, String key) {
        this.put(key, event.get(key));
    }

    public void genID(int id) {
        this.id = UUID.randomUUID().toString();
    }

    public int getCode() {
        return this.getInt(CODE);
    }

    public String getDesc() {
        return this.getStr(DESC);
    }

    public void setCode(int code) {
        this.put(CODE, code);
    }

    public void setDesc(String desc) {
        this.put(DESC, desc);
    }

    public void setRes(int code, String desc) {
        this.setCode(code);
        this.setDesc(desc);
    }

    public void setRes(MException e) {
        this.setCode(e.getCode());
        this.setDesc(e.getMessage());
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean getBool(String key) {
        boolean value = false;
        Object obj = this.get(key);
        if (obj instanceof Boolean) {
            value = (Boolean)Boolean.class.cast(obj);
        }
        return value;
    }

    @Override
    public String toString() {
        return "MEvent toString is shield";
    }

    public int getInt(String key) {
        int value = 0;
        Object obj = this.get(key);
        if (obj instanceof String) {
            BigDecimal bd = new BigDecimal((String)String.class.cast(obj));
            return bd.intValue();
        }
        if (obj instanceof Integer) {
            value = (Integer)Integer.class.cast(obj);
        }
        return value;
    }

    public long getLong(String key) {
        long value = 0L;
        Object obj = this.get(key);
        if (obj instanceof String) {
            BigDecimal bd = new BigDecimal((String)String.class.cast(obj));
            value = bd.longValue();
        } else if (obj instanceof Long) {
            value = (Long)Long.class.cast(obj);
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        int value = this.getInt(key);
        return value == 0 ? defaultValue : value;
    }

    public long getLong(String key, long defaultValue) {
        long value = this.getInt(key);
        return value == 0L ? defaultValue : value;
    }

    public double getDouble(String key) {
        double value = 0.0;
        Object obj = this.get(key);
        if (obj instanceof String) {
            value = Double.valueOf((String)String.class.cast(obj));
        } else if (obj instanceof Integer) {
            value = ((Integer)Integer.class.cast(obj)).intValue();
        } else if (obj instanceof Double) {
            value = (Double)Double.class.cast(obj);
        }
        return value;
    }

    public double getDouble(String key, double defaultValue) {
        double value = this.getDouble(key);
        return value == 0.0 ? defaultValue : value;
    }

    public String getStr(String key) {
        String value = "";
        Object obj = this.get(key);
        if (obj instanceof String) {
            value = (String)String.class.cast(obj);
        } else if (obj instanceof Integer) {
            value = String.valueOf(Integer.class.cast(obj));
        } else if (obj instanceof Double) {
            value = String.valueOf(Double.class.cast(obj));
        }
        return value;
    }

    public String getStr(String key, String defaultValue) {
        String value = this.getStr(key);
        if (value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public byte[] getBytes(String key) {
        byte[] value = null;
        Object obj = this.get(key);
        value = obj instanceof byte[] ? (byte[])byte[].class.cast(obj) : this.getStr(key).getBytes();
        return value;
    }

    public int getFunctionCode() {
        return this.FunctionCode;
    }

    public void setFunctionCode(int functionCode) {
        this.FunctionCode = functionCode;
    }

    public static void main(String[] args) throws Exception {
    }
}

