/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.views.rationed;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.RationedStock;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.stock.models.RightsIssueModel;
import cms.tmx.stock.views.rationed.InstructionRationedStockBasePart;
import cms.tmx.stock.views.rationed.LoadPartModel;
import java.net.URL;
import java.util.Map;
import javafx.application.Platform;
import javax.inject.Inject;

public class InstructionRationedStockPassivePart
extends InstructionRationedStockBasePart {
    @Inject
    private RightsIssueModel rightsModel;
    protected MEvent instructEvent = new MEvent();
    protected OrderAdvice advice;
    protected Instruction instruction;
    protected boolean initFinished = false;
    protected MEventHandler hSetCode = event -> Platform.runLater(() -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        if (!this.validOrderFill()) {
            return;
        }
        this.instruction = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        this.doSetCode();
    });
    @Inject
    private LoadPartModel load;

    protected void doSetCode() {
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        if (this.instruction.getType().getRaw().equals("2")) {
            this.advice = this.instruction.getOrderAdvice();
            this.model.setInstruction(this.instruction);
            if (this.advice == null) {
                return;
            }
            RefItem refItem = (RefItem)this.getRefMap().get(String.valueOf(this.advice.getSecType()) + this.advice.getMarket() + this.advice.getSec());
            this.doSecurityChange(refItem, this.advice.getSec());
        }
    }

    private void doSecurityChange(RefItem refItem, String secCode) {
        super.onSecurityChange(refItem);
        this.doOrderFill();
    }

    private void doOrderFill() {
        long effectiveQuantity;
        long l = effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        if (this.quantitySpn == null) {
            System.out.println("quantitySpn == null");
        }
        if (this.quantitySpn.getEditor() == null) {
            System.out.println("quantitySpn.getEditor() == null");
        }
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.model.getAccDisModel().fillAccount(this.instruction);
    }

    protected boolean validOrderFill() {
        return false;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private Map<String, RationedStock> getRefMap() {
        return this.rightsModel.mapRef;
    }
}

