/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.views.portfolio;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.SubResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.stock.models.NewStockSubResultModel;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewStockPortfolioSubResultPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(NewStockPortfolioSubResultPart.class);
    private MxList<SubResult> mlist = new MxList();
    @FXML
    private TableView<SubResult> tableSubResult;
    @FXML
    private TextField searchText;
    @Inject
    private NewStockSubResultModel model;
    @Inject
    private MxAlert alert;
    private Predicate<SubResult> pd = new Predicate<SubResult>(){

        @Override
        public boolean test(SubResult t) {
            return t.getCode().contains(NewStockPortfolioSubResultPart.this.searchText.getText().trim());
        }
    };
    private InvalidationListener invalid = ob -> {
        this.mlist.update(this.model.getList(), this.pd);
        this.tableSubResult.sort();
    };
    private InvalidationListener lstnSearch = ob -> this.mlist.filter(this.model.getList(), this.pd);

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.invalid);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.refresh();
    }

    private void createTable() {
        this.tableSubResult.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableSubResult);
        this.tableSubResult.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        this.model.queryPortfolioResult();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableSubResult);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableSubResult, (String)"\u4e2d\u7b7e\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

