/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.views;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.http.data.ObRightsIssues;
import cms.tmx.http.data.RightsIssues;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.stock.models.RightsIssueModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class RightsIssueInfoPart
extends MxPart {
    private static final Integer PAGE_SIZE = 500;
    @FXML
    private TableView<RightsIssues> tableRightsIssue;
    @FXML
    private TableColumn<RightsIssues, String> accnt;
    @FXML
    private TableColumn<RightsIssues, String> securityId;
    @FXML
    private TableColumn<RightsIssues, String> symbol;
    @FXML
    private TableColumn<RightsIssues, Number> qtyUpperLimit;
    @FXML
    private TableColumn<RightsIssues, String> unit;
    @FXML
    private TableColumn<RightsIssues, String> secAccnt;
    @FXML
    private TableColumn<RightsIssues, Number> subscriptionPrice;
    @FXML
    private TableColumn<RightsIssues, Number> priceUpperLimit;
    @FXML
    private TextField searchText;
    protected MxList<RightsIssues> mxList = new MxList();
    protected MxList<ObRightsIssues> list = new MxList();
    private Predicate<RightsIssues> pd = en -> {
        String text = this.searchText.getText().trim();
        return en.getAccnt().contains(text) || en.getSecAccnt().contains(text) || en.getInstrument().getSecurityId().contains(text);
    };
    @Inject
    private RightsIssueModel model;
    private InvalidationListener lstnModel = ob -> {
        ArrayList<RightsIssues> newList = new ArrayList<RightsIssues>();
        List<RightsIssues> list = this.getModel().getList();
        synchronized (list) {
            newList.addAll(this.getModel().getList());
        }
        this.mxList.filter(newList, this.pd);
        System.out.println();
        Platform.runLater(() -> {
            this.tableRightsIssue.sort();
            this.tableRightsIssue.refresh();
        });
    };

    @FXML
    protected void initialize() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.refresh();
        this.createTable();
    }

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    protected void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    public void createTable() {
        this.accnt.setCellValueFactory(data -> new SimpleStringProperty(((RightsIssues)data.getValue()).getAccnt()));
        this.securityId.setCellValueFactory(data -> new SimpleStringProperty(((RightsIssues)data.getValue()).getInstrument().getSecurityId()));
        this.symbol.setCellValueFactory(data -> new SimpleStringProperty(((RightsIssues)data.getValue()).getInstrument().getSymbol()));
        this.secAccnt.setCellValueFactory(data -> new SimpleStringProperty(((RightsIssues)data.getValue()).getSecAccnt()));
        this.qtyUpperLimit.setCellValueFactory(data -> new SimpleDoubleProperty(((RightsIssues)data.getValue()).getQtyUpperLimit().doubleValue()));
        this.qtyUpperLimit.setCellFactory(cell -> new NumberTableCell());
        this.unit.setCellValueFactory(data -> new SimpleStringProperty(((RightsIssues)data.getValue()).getUnit()));
        this.subscriptionPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((RightsIssues)data.getValue()).getSubscriptionPrice().doubleValue()));
        this.subscriptionPrice.setCellFactory(cell -> new AvgPriceCell());
        this.priceUpperLimit.setCellValueFactory(data -> new SimpleDoubleProperty(((RightsIssues)data.getValue()).getPriceUpperLimit().doubleValue()));
        this.priceUpperLimit.setCellFactory(cell -> new DoubleTableCell());
        this.tableRightsIssue.setItems(this.mxList.getList());
    }

    public RightsIssueModel getModel() {
        return this.model;
    }

    public void setModel(RightsIssueModel model) {
        this.model = model;
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableRightsIssue, (ObservableList)this.mxList.getList());
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableRightsIssue, (List)this.mxList.getList(), (String)"\u53ef\u7533\u8d2d\u914d\u80a1\u67e5\u8be2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AvgPriceCell
    extends DoubleTableCell<RightsIssues> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

