/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.rights.IUiRightService;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewStockInfoPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(NewStockInfoPart.class);
    private MxList<ConvertibleBond> mxList = new MxList();
    @FXML
    private TableView<ConvertibleBond> tableNewStock;
    @FXML
    private Button btnOneKey;
    @FXML
    private TableColumn<ConvertibleBond, String> code;
    @FXML
    private TableColumn<ConvertibleBond, String> market;
    @Inject
    private IUiRightService rightsModel;
    @FXML
    protected TextField searchText;
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MxAlert alert;
    private List<ConvertibleBond> listInfo = new LinkedList<ConvertibleBond>();
    private Predicate<ConvertibleBond> pd = en -> {
        String text = this.searchText.getText().trim();
        if (en.getCode().contains(text)) {
            return true;
        }
        return en.getName().contains(text);
    };
    protected InvalidationListener lstnModel = ob -> {
        this.mxList.filter(this.listInfo, this.pd);
        this.tableNewStock.refresh();
        this.tableNewStock.sort();
    };
    private InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.listInfo, this.pd);
        this.tableNewStock.refresh();
        this.tableNewStock.sort();
    };

    @FXML
    public void initialize() {
        this.checkRights();
        this.refMng.changedProperty().addListener(ob -> this.refresh());
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.createTableView();
        this.tableNewStock.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            if (event.getClickCount() == 2) {
                ConvertibleBond bond = (ConvertibleBond)this.tableNewStock.getSelectionModel().getSelectedItem();
                MEvent e = new MEvent();
                e.setObj((Object)bond);
                this.es.sendEvent("double_clicked_sub", e);
            }
        });
        this.refresh();
        FxUtils.makePC((Node)this.btnOneKey, (String)"strong", (boolean)true);
    }

    private void checkRights() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String cancel = "cms.tmx.bond.part.newstock.info_onekey";
        switch (parentId) {
            case "CMS-TMX-BOND-PART-NEWSTOCK-INFO": {
                cancel = "cms.tmx.bond.part.newstock.info_onekey";
                break;
            }
            case "CMS-TMX-PORTFOLIO-BOND-PART-NEWSTOCK-INFO": {
                cancel = "cms.tmx.portfolio.bond.part.newstock.info_onekey";
                break;
            }
        }
        if (this.btnOneKey != null) {
            this.rightsModel.registerCheck((Control)this.btnOneKey, new String[]{cancel});
        }
    }

    @FXML
    public void refresh() {
        this.listInfo.clear();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u65b0\u80a1\u7533\u8d2d")) continue;
            this.listInfo.add((ConvertibleBond)item);
        }
        this.lstnModel.invalidated(null);
    }

    @FXML
    public void oneKey() {
        MEvent ev = new MEvent();
        this.es.sendEvent("one_key_sub", ev);
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableNewStock);
        this.market.setCellValueFactory(data -> {
            String market = ((ConvertibleBond)data.getValue()).getMarket();
            SimpleStringProperty ssp = new SimpleStringProperty("");
            if (market.equals("XSHG")) {
                ssp.set("\u4e0a\u4ea4\u6240");
            } else if (market.equals("XSHE")) {
                ssp.set("\u6df1\u4ea4\u6240");
            }
            return ssp;
        });
        this.tableNewStock.setPlaceholder((Node)new Label());
        this.tableNewStock.setItems(this.mxList.getList());
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.code.setSortType(TableColumn.SortType.ASCENDING);
        this.tableNewStock.getSortOrder().add(this.code);
        this.tableNewStock.sort();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableNewStock);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableNewStock, (String)"\u53ef\u7533\u8d2d\u65b0\u80a1\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38");
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

