/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.NewStockAuth;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.stock.models.InstructionNewStockModel;
import cms.tmx.stock.models.NewStockAcctDistModel;
import cms.tmx.stock.views.InstructionNewStockPassivePart;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.trade.views.CcsTradePart;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionNewStockBasePart
extends MxPart {
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> accNameCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, NewStockAuth> subAuthCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    protected Button btnOrder;
    @FXML
    protected ComboBox<MxNode> cmbAccFilter;
    @FXML
    protected TextField txtSearch;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private SecConverter secCvt;
    public static final Logger logger = LogManager.getLogger(CcsTradePart.class);
    @Inject
    protected ExecutorService exe;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected SecSuggest spCode = new SecSuggest();
    private InvalidationListener lstnRefMng = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    public static final int SECURITY_TYPE = 1;
    @Inject
    protected InstructionNewStockModel model;
    private MEventHandler hDoubleClickedSub = event -> Platform.runLater(() -> this.doubleClickedSub(event));
    private MEventHandler hOneKeySub = event -> this.oneKey(event);
    private String buySymbol = "\u65b0\u80a1\u7533\u8d2d";
    private String confirmSymbol = "";
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = data -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            TreeTableRow row = this.getTreeTableRow();
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else if (this.getTreeTableRow().getItem() != null) {
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                if (!InstructionNewStockBasePart.this.model.getAccDisModel().isActive()) {
                    checkBox.setDisable(true);
                } else if (treeItem != null && treeItem.getValue() != null && ((CcsAccountDistribution)treeItem.getValue()).getNewStockAuth() != null) {
                    checkBox.setDisable(!((CcsAccountDistribution)treeItem.getValue()).getNewStockAuth().isAuth());
                }
                if (treeItem == null) {
                    return;
                }
                if (treeItem.isLeaf()) {
                    checkBox.selectedProperty().addListener((ob, old, now) -> {
                        TreeItem parent = treeItem.getParent();
                        if (now.booleanValue()) {
                            parent.getChildren().forEach(each -> {
                                if (!each.equals(treeItem)) {
                                    ((CcsAccountDistribution)each.getValue()).setSelected(false);
                                }
                            });
                        }
                        InstructionNewStockBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        row.pseudoClassStateChanged(pcMxSelected, now != false && parent.isExpanded());
                    });
                    this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                    this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                } else {
                    checkBox.selectedProperty().addListener((ob, old, newV) -> {
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                        if (newV.booleanValue()) {
                            InstructionNewStockBasePart.this.doCheckParentSelected((TreeItem<CcsAccountDistribution>)treeItem);
                            InstructionNewStockBasePart.this.acctTreeTable.refresh();
                        } else {
                            treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(false));
                        }
                    });
                    treeItem.expandedProperty().addListener(ob -> InstructionNewStockBasePart.this.acctTreeTable.refresh());
                    this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                    this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                }
                this.setGraphic((Node)checkBox);
            }
        }
    };

    @PreDestroy
    protected void close() {
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange((String)newV);
            this.acctTreeTable.refresh();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice(), (Observable[])new Observable[]{this.model.priceStgProperty()}));
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setText("");
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((MxNode)this.cmbPriceType.getValue()).getRaw().equals("50"), (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        this.setPriceUnit();
        this.ctrlCount.ctrl(this.quantitySpn);
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        this.model.getAccDisModel().changedProperty().addListener(ob -> this.acctTreeTable.refresh());
        this.cmbAccFilter.setItems(this.model.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.model.accFilterStgProperty());
        this.txtSearch.textProperty().bindBidirectional((Property)this.model.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(data -> new AccountCollapseCell());
        this.accNameCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accntNameProperty());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.subAuthCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).newStockAuthProperty());
        this.acctTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.model.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void check() {
        if (this.txtCode.getText().length() < 6) {
            return;
        }
        RefItem ref = this.model.getRefItem();
        if (ref == null || ref.getName().equals("") || this.model.getValidRef() == null) {
            this.lbName.setText(INVALID_CODE);
        } else {
            ConvertibleBond bond = (ConvertibleBond)ref;
            if (bond.isGem()) {
                Tooltip tooltip = new Tooltip();
                StringBuilder builder = new StringBuilder();
                builder.append(bond.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
                builder.append("\r\n");
                builder.append(bond.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
                builder.append("\r\n");
                builder.append(bond.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
                builder.append("\r\n");
                builder.append(bond.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
                builder.append("\r\n");
                tooltip.setText(builder.toString());
                this.lbName.setTooltip(tooltip);
                this.lbName.setText(bond.getName());
            } else {
                this.lbName.setText(bond.getName());
                System.err.println(this.model.getName());
                this.lbName.setTooltip(null);
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            this.quantitySpn.getEditor().selectAll();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            this.quantitySpn.getEditor().selectAll();
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    @Inject
    public InstructionNewStockBasePart() {
    }

    @FXML
    public void initialize() {
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.initControls();
        this.createAcctTree();
        this.setBtnOrderText();
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.exe.execute(() -> this.model.getAccDisModel().initLimit());
    }

    protected void setBtnOrderText() {
        this.btnOrder.setText("\u7533\u8d2d");
    }

    @PreDestroy
    private void preDestroy() {
    }

    private void oneKey(MEvent event) {
        if (!NewStockAcctDistModel.done) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.WARNING, "\u6570\u636e\u6b63\u5728\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01"));
            return;
        }
        CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
        obj.setRefItem(this.model.getRefItem());
        this.model.getAccDisModel();
        List<CcsSingleEntrust> list = NewStockAcctDistModel.enList;
        obj.setUnit("\u80a1");
        obj.setList(list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            this.submitAll(list);
        }
    }

    private void doubleClickedSub(MEvent event) {
        if (!NewStockAcctDistModel.done) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6570\u636e\u6b63\u5728\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            return;
        }
        ConvertibleBond bond = (ConvertibleBond)event.getObj(ConvertibleBond.class);
        CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
        obj.setRefItem(this.model.getRefItem());
        this.model.getAccDisModel();
        List<CcsSingleEntrust> list = NewStockAcctDistModel.mapSecurityEntrustList.get(bond.getCode());
        obj.setUnit("\u80a1");
        if (list == null || list.size() == 0) {
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(bond.getCode()) + "\u65e0\u53ef\u7533\u8d2d\u989d\u5ea6");
            return;
        }
        obj.setList(list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            this.submitAll(list);
        }
    }

    private void submitAll(List<CcsSingleEntrust> list) {
        ObservableList<Boolean> listCont = this.model.submit(list);
        this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
    }

    public boolean valid() {
        if (!NewStockAcctDistModel.done) {
            this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u989d\u5ea6\u6570\u636e\u672a\u52a0\u8f7d\u5b8c\u6210, \u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return false;
        }
        if (this.txtCode.getText().isEmpty() && ((Object)((Object)this)).getClass().getSuperclass() == InstructionNewStockPassivePart.class) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u91cd\u65b0\u53cc\u51fb\u56de\u586b\u6570\u636e");
            return false;
        }
        if (!this.alert.check(this.model.getCount() > 0L, Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6570\u91cf")) {
            return false;
        }
        RefItem item = this.model.getRefItem();
        if (item != null && item instanceof ConvertibleBond) {
            ConvertibleBond bond = (ConvertibleBond)ConvertibleBond.class.cast(item);
            double upper = bond.getQtyUpperLimit();
            double base = bond.getTradeUnit();
            for (TreeItem dis : this.model.getAccDisModel().getRoot().getChildren()) {
                for (TreeItem sec : dis.getChildren()) {
                    if (!this.alert.check((double)((CcsAccountDistribution)sec.getValue()).getCount() <= upper, Alert.AlertType.WARNING, "\u5b58\u5728\u8bc1\u5238\u8d26\u53f7\u5206\u914d\u91cf\u8d85\u8fc7\u7533\u8d2d\u4e0a\u9650\u60c5\u51b5, \u8bf7\u786e\u8ba4\u5206\u914d\u91cf")) {
                        return false;
                    }
                    if (this.alert.check((double)((CcsAccountDistribution)sec.getValue()).getCount() % base == 0.0, Alert.AlertType.WARNING, "\u5b58\u5728\u8bc1\u5238\u8d26\u53f7\u5206\u914d\u91cf\u975e\u5355\u4f4d\u57fa\u6570\u6574\u6570\u500d")) continue;
                    return false;
                }
            }
        }
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.model.isLimitPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        return this.alert.check(this.model.getCount() >= 0L && this.model.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5);
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    protected void clear() {
        this.txtCode.clear();
        this.lbName.setText("");
        this.priceSpn.getEditor().clear();
        this.model.setCount(0L);
    }

    @FXML
    public void order() {
        if (this.valid()) {
            CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
            if (!"0".equals(this.model.getAccDisModel().getInstructType()) && !"4".equals(this.model.getAccDisModel().getInstructType())) {
                obj.setIsInstruction(true);
            } else {
                obj.setExecution(true);
            }
            obj.setBuySymbol(this.buySymbol);
            obj.setRefItem(this.model.getRefItem());
            obj.setPriceStg(this.model.getPriceStg());
            obj.setUnit(this.lbUnit.getText());
            obj.setList(this.model.getEntrustList());
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                if (obj.totalCount != this.model.getCount()) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u5206\u914d\u91cf\u603b\u548c\u4e0e\u59d4\u6258\u6570\u91cf\u4e0d\u76f8\u7b49");
                    return;
                }
                if (this.model.overLimit && ((Object)((Object)this)).getClass().getSuperclass() != InstructionNewStockPassivePart.class) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u8d85\u8fc7\u53ef\u7533\u8d2d\u989d\u5ea6");
                    return;
                }
                if (this.model.getInstruction() != null) {
                    this.model.getInstruction().setPostil(obj.getPostil());
                }
                this.model.setPostil(obj.getPostil());
                this.submitOrder();
            }
        }
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    protected void submitOrder() {
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.alert(Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            } else {
                this.alert.alert(Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        this.afterOrder();
    }

    protected void afterOrder() {
    }

    protected ObservableList<Boolean> doAction() throws MException {
        return this.model.submit((TreeItem<CcsAccountDistribution>)this.model.getAccDisModel().getRoot());
    }

    protected void onSecurityChange(String newText) {
        Platform.runLater(() -> {
            RefItem refItem = null;
            Object obj = this.txtCode.getUserData();
            if (obj instanceof RefItem) {
                refItem = (RefItem)RefItem.class.cast(obj);
            }
            this.model.setRefItem(refItem);
            if (this.model.isValidRef()) {
                this.ctrlPrice.setScale(this.model.getRefItem().getScale());
            }
            this.model.onSecChange();
            if (newText.length() >= 6) {
                this.check();
            }
            if (refItem != null) {
                this.txtCode.setText(refItem.getCode());
                this.txtCode.selectEnd();
                this.txtCode.deselect();
            }
            if (this.model.isValidRef()) {
                this.lbUnit.setText("\u80a1");
                RefItem item = this.refMng.getItem("OIS", this.model.getRefItem().getMarket(), this.model.getSecurity());
                if (item != null && item instanceof ConvertibleBond) {
                    ConvertibleBond bond = (ConvertibleBond)ConvertibleBond.class.cast(item);
                    this.model.setPrice(bond.getSubPrice());
                }
                if (!NewStockAcctDistModel.done) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u989d\u5ea6\u6570\u636e\u672a\u52a0\u8f7d\u5b8c\u6210, \u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    if (((Object)((Object)this)).getClass().getSuperclass() == InstructionNewStockPassivePart.class) {
                        this.clear();
                    }
                    return;
                }
            } else {
                this.model.getAccDisModel().clearSelect();
                this.model.setPrice(0.0);
                this.priceSpn.getEditor().setText("0");
            }
        });
    }

    protected void onSecurityChange(RefItem refItem) {
        if (this.model == null) {
            System.out.println("model == null");
            return;
        }
        this.model.setRefItem(refItem);
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(this.model.getRefItem().getScale());
        }
        this.model.onSecChange();
        this.check();
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.model.isValidRef()) {
            this.lbUnit.setText("\u80a1");
            RefItem item = this.refMng.getItem("OIS", this.model.getRefItem().getMarket(), this.model.getSecurity());
            if (item != null && item instanceof ConvertibleBond) {
                ConvertibleBond bond = (ConvertibleBond)ConvertibleBond.class.cast(item);
                this.model.setPrice(bond.getSubPrice());
            }
            if (!NewStockAcctDistModel.done) {
                this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u989d\u5ea6\u6570\u636e\u672a\u52a0\u8f7d\u5b8c\u6210, \u8bf7\u7a0d\u540e\u91cd\u8bd5");
                if (((Object)((Object)this)).getClass().getSuperclass() == InstructionNewStockPassivePart.class) {
                    this.clear();
                }
                return;
            }
        } else {
            this.model.getAccDisModel().clearSelect();
            this.model.setPrice(0.0);
            this.priceSpn.getEditor().setText("0");
        }
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canSellCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanSell() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + secAccDis.getCanSell() + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    protected Collection<RefItem> getRefItems() {
        ArrayList<RefItem> list = new ArrayList<RefItem>();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u65b0\u80a1\u7533\u8d2d")) continue;
            list.add((RefItem)((ConvertibleBond)item));
        }
        return list;
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("");
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    private void doCheckParentSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            block0: for (TreeItem fundItem : prtItem.getChildren()) {
                if (!fundItem.equals(treeItem)) {
                    ((CcsAccountDistribution)fundItem.getValue()).setSelected(false);
                }
                for (TreeItem eachItem : fundItem.getChildren()) {
                    if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                    isSelected = true;
                    continue block0;
                }
            }
            if (!isSelected.booleanValue()) {
                treeItem.getChildren().forEach(secItem -> {
                    if (((CcsAccountDistribution)secItem.getValue()).getNewStockAuth().isAuth()) {
                        ((CcsAccountDistribution)secItem.getValue()).setSelected(true);
                        return;
                    }
                });
            }
        }
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getSuperclass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

