/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.RationedStock;
import cms.tmx.http.accnt.RightsIssuesApi;
import cms.tmx.http.accnt.RightsIssuesReq;
import cms.tmx.http.accnt.RightsIssuesResp;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.data.RightsIssues;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.query.utils.QueryModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class RightsIssueModel
extends MxModel {
    @Inject
    private IFundAccountService fundService;
    @Inject
    private RightsIssuesApi api;
    @Inject
    private FundAccName fundName;
    @Inject
    protected MEventService es;
    @Inject
    protected CcsAccountMap ccsAccountMap;
    @Inject
    protected QueryModel queryModel;
    List<RightsIssues> list = new ArrayList<RightsIssues>();
    List<String> mxlist = new ArrayList<String>();
    MxList<RightsIssues> mxOnelist = new MxList();
    private Map<String, RightsIssues> mapIssues = new HashMap<String, RightsIssues>();
    public Map<String, RationedStock> mapRef = new HashMap<String, RationedStock>();
    private List<RationedStock> listRStock = new LinkedList<RationedStock>();

    @PostConstruct
    public void init() {
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    private void onPush(MEvent event) {
    }

    public void query() throws MException {
        this.mxlist.clear();
        this.list.clear();
        this.listRStock.clear();
        this.mxlist.addAll(this.ccsAccountMap.getExtAccList());
        RightsIssuesReq req = new RightsIssuesReq();
        req.setAccntId(this.mxlist);
        req.setOffset(0);
        req.setLimit(500);
        RightsIssuesResp resp = this.api.getRightsIssues(req);
        HashMap map = new HashMap();
        this.list.addAll(resp.getData());
        this.list.forEach(rIssues -> {
            this.beforeChange((RightsIssues)rIssues);
            Instrument inst = rIssues.getInstrument();
            this.mapIssues.put(String.valueOf(inst.getSecurityId()) + inst.getMarket() + rIssues.getAccntId() + rIssues.getSecAccntId(), (RightsIssues)rIssues);
            RationedStock rStock = (RationedStock)map.get(inst.getSecurityId());
            if (rStock == null) {
                rStock = new RationedStock();
                rStock.update(rIssues);
                this.listRStock.add(rStock);
                this.mapRef.put(String.valueOf(inst.getSecurityType()) + inst.getMarket() + inst.getSecurityId(), rStock);
                map.put(inst.getSecurityId(), rStock);
            }
            rStock.addAccntId(rIssues.getAccntId());
            rIssues.update(rIssues);
            rIssues.update();
        });
        this.mxOnelist.update(this.list);
        this.changed();
        System.out.println();
    }

    public void beforeChange(RightsIssues data) {
        data.setUnit(RightsIssueModel.getUnit(data.getInstrument().getSecurityType(), data.getInstrument().getMarket()));
        String investId = this.queryModel.getInverstorSecId(data.getAccntId());
        data.setAccnt(investId);
        data.setSecAccnt(this.queryModel.getInverstorSecId(data.getSecAccntId()));
        data.setSymbol(data.getInstrument().getSymbol());
        data.setSecurityId(data.getInstrument().getSecurityId());
        data.setPriceUpperLimit(data.getPriceUpperLimit());
        data.setSubscriptionPrice(data.getSubscriptionPrice());
    }

    public RightsIssues getRIssues(String code, String market, String accntId, String secAccntId) {
        return this.mapIssues.get(String.valueOf(code) + market + accntId + secAccntId);
    }

    public static String getUnit(String secType, String market) {
        if ("STOCK".equals(secType) || "OIS".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market) || "STD_BOND".equals(secType) && "XSHG".equals(market) || "REPO".equals(secType) && "XSHG".equals(market) || "PLEDGE".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market) || "STD_BOND".equals(secType) && "XSHE".equals(market) || "REPO".equals(secType) && "XSHE".equals(market) || "PLEDGE".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return "";
    }

    public List<RightsIssues> getList() {
        return this.list;
    }

    public void setList(List<RightsIssues> list) {
        this.list = list;
    }

    public List<String> getMxlist() {
        return this.mxlist;
    }

    public void setMxlist(List<String> mxlist) {
        this.mxlist = mxlist;
    }

    public List<RationedStock> getListRStock() {
        return this.listRStock;
    }

    public MxList<RightsIssues> getMxOnelist() {
        return this.mxOnelist;
    }

    public void setMxOnelist(MxList<RightsIssues> mxOnelist) {
        this.mxOnelist = mxOnelist;
    }
}

