/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.models;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.http.data.RightsIssues;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.stock.models.RightsIssueModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class RationedStockAcctDistModel
extends CcsAccountDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    @Inject
    protected CcsEntrustFactory ef;
    private StringProperty market = new SimpleStringProperty("");
    private Map<String, CcsFundAccount> map = new HashMap<String, CcsFundAccount>();
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    @Inject
    private RightsIssueModel rIssueModel;
    @Inject
    private MEventService es;
    public static boolean done = false;
    private InvalidationListener lstnRIssue = ob -> {
        boolean bl = done = true;
    };
    @Inject
    private ExecutorService exe;

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    public void fillAccount(Instruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.setInstruction(instruction);
        this.setAdvice(instruction.getOrderAdvice());
        List list = this.advice.getAccSecInfoList();
        if (instruction.getIsOrderStep()) {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket());
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderAvailableQuantity());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderAvailableQuantity() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            });
        } else {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket());
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderQty() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            });
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createTree();
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u6295\u7ec4\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public synchronized TreeItem<CcsAccountDistribution> create() throws MException {
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.buy.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    @PostConstruct
    private void init() {
        try {
            Set setList = super.getAccountMap().keySet();
            for (CcsFundAccount set : setList) {
                this.map.put(set.getExtAccntId(), set);
            }
        }
        catch (MException e) {
            this.logger.error("getAccountMap faild:" + (Object)((Object)e));
        }
        if (!this.rIssueModel.getListRStock().isEmpty()) {
            done = true;
        } else {
            try {
                this.rIssueModel.query();
            }
            catch (MException e) {
                e.printStackTrace();
            }
        }
        this.rIssueModel.changedProperty().addListener(this.lstnRIssue);
    }

    public void clearSelect(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setSelected(false);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setSelected(false);
            }
        });
    }

    public void clearCanBuySell(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setCanBuy(0L);
            ((CcsAccountDistribution)each.getValue()).setCanSell(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setCanBuy(0L);
                ((CcsAccountDistribution)sub.getValue()).setCanSell(0L);
                ((CcsAccountDistribution)sub.getValue()).getNewStockAuth().clear();
            }
        });
    }

    public void calAccountCanSell() {
        if (!done) {
            return;
        }
        Platform.runLater(() -> {
            for (String funAccId : this.mapSecDisMxList.keySet()) {
                long canSellTotal = 0L;
                for (TreeItem subItem : ((MxTreeList)this.mapSecDisMxList.get(funAccId)).getObList()) {
                    String secAccId = ((CcsAccountDistribution)subItem.getValue()).getSecAcc().getExtSecAccntId();
                    RightsIssues rIssues = this.rIssueModel.getRIssues(this.getSecurity(), this.getMarket(), funAccId, secAccId);
                    Long count = rIssues == null ? 0L : rIssues.getQtyUpperLimit().longValue();
                    ((CcsAccountDistribution)subItem.getValue()).setCanSell(count.longValue());
                    canSellTotal += count.longValue();
                }
                for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                    if (!accItem.getAcc().getExtAccntId().equals(funAccId)) continue;
                    accItem.setCanSell(canSellTotal);
                }
            }
            this.changed();
        });
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    public final boolean isActive() {
        return this.activeProperty().get();
    }

    public final void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }
}

