/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.models;

import cms.tmx.api.trade.INewStockApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.SubResult;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.utils.QueryModel;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NewStockSubResultModel
extends MxModel {
    @Inject
    private CcsAccountMap accMng;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private INewStockApi api;
    @Inject
    private MObjFactory of;
    @Inject
    private QueryModel queryModel;
    @Inject
    protected MScheduler sdQuery;
    private static final int QUERY_INTERVAL = 1000;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount;
    private Map<CcsFundAccount, List<SecAccount>> mapSubAccount;
    private ObservableList<SubResult> list = FxUtils.newList();

    @PostConstruct
    private void init() {
        this.sdQuery.setInterval(1000);
        try {
            this.mapAccount = this.getAccountMap();
            this.mapSubAccount = this.getPortfolioAccountMap();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    public void queryNumber() {
        this.sdQuery.schedule(event -> {
            this.list.clear();
            for (CcsFundAccount fund : this.mapAccount.keySet()) {
                for (SecAccount sec : this.mapAccount.get(fund)) {
                    try {
                        List applyList = this.api.getNumber(fund.getExtAccntId(), sec.getExtSecAccntId(), sec.getExchange().getRaw());
                        for (PCashService.ApplyNumber apply : applyList) {
                            SubResult result = (SubResult)this.of.create(SubResult.class);
                            result.update((Object)apply);
                            result.setFundAcct(fund.getExtAccntId());
                            this.queryModel.afterUpdate(result);
                            this.list.add((Object)result);
                        }
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.changed();
        });
    }

    public void queryResult() {
        this.sdQuery.schedule(event -> {
            this.list.clear();
            for (CcsFundAccount fund : this.mapAccount.keySet()) {
                for (SecAccount sec : this.mapAccount.get(fund)) {
                    try {
                        List applyList = this.api.getResult(fund.getExtAccntId(), sec.getExtSecAccntId(), sec.getExchange().getRaw());
                        for (PCashService.ApplyNumber apply : applyList) {
                            SubResult result = (SubResult)this.of.create(SubResult.class);
                            result.update((Object)apply);
                            result.setFundAcct(fund.getExtAccntId());
                            this.queryModel.afterUpdate(result);
                            this.list.add((Object)result);
                        }
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.changed();
        });
    }

    public void queryPortfolioResult() {
        this.sdQuery.schedule(event -> {
            this.list.clear();
            for (CcsFundAccount fund : this.mapSubAccount.keySet()) {
                if (!(fund instanceof CcsSubFundAccount)) continue;
                CcsSubFundAccount sub = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fund);
                for (SecAccount sec : this.mapSubAccount.get(fund)) {
                    try {
                        List applyList = this.api.getResult(fund.getExtAccntId(), sec.getExtSecAccntId(), sec.getExchange().getRaw());
                        for (PCashService.ApplyNumber apply : applyList) {
                            SubResult result = (SubResult)this.of.create(SubResult.class);
                            result.update((Object)apply);
                            result.setFundAcct(fund.getExtAccntId());
                            result.setPortfolioId(sub.getPortfolioId());
                            result.setPortfolioName(sub.getPortfolioName());
                            this.queryModel.afterUpdate(result);
                            this.list.add((Object)result);
                        }
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.changed();
        });
    }

    protected Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        return this.accMng.getAccountMap();
    }

    protected Map<CcsFundAccount, List<SecAccount>> getPortfolioAccountMap() throws MException {
        return this.portfolioModel.getSubFundSecMap();
    }

    public ObservableList<SubResult> getList() {
        return this.list;
    }
}

