/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.models;

import cms.tmx.api.trade.INewStockApi;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.NewStockAuth;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NewStockAcctDistModel
extends CcsAccountDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    @Inject
    protected CcsEntrustFactory ef;
    private StringProperty market = new SimpleStringProperty("");
    private Map<String, CcsFundAccount> map = new HashMap<String, CcsFundAccount>();
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    @Inject
    private INewStockApi api;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MEventService es;
    private static Map<String, ConvertibleBond> mapXbondRef = new HashMap<String, ConvertibleBond>();
    private static Map<String, PCashService.ApplyLimit> mapApplyLimit = new HashMap<String, PCashService.ApplyLimit>();
    private static Map<String, Long> mapLimit = new HashMap<String, Long>();
    public static List<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
    public static Map<String, List<CcsSingleEntrust>> mapSecurityEntrustList = new HashMap<String, List<CcsSingleEntrust>>();
    public static boolean done = false;
    @Inject
    private ExecutorService exe;
    private boolean refdone = false;
    private InvalidationListener listenerRefMng = ob -> this.refLimit();

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    public void fillAccount(Instruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.setInstruction(instruction);
        this.setAdvice(instruction.getOrderAdvice());
        List list = this.advice.getAccSecInfoList();
        if (instruction.getIsOrderStep()) {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket());
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderAvailableQuantity());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderAvailableQuantity() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            });
        } else {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + this.advice.getMarket());
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderQty() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + this.advice.getMarket(), accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            });
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createTree();
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u6295\u7ec4\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public synchronized TreeItem<CcsAccountDistribution> create() throws MException {
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.buy.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    @PostConstruct
    private void init() {
        try {
            Set setList = super.getAccountMap().keySet();
            for (CcsFundAccount set : setList) {
                this.map.put(set.getExtAccntId(), set);
            }
        }
        catch (MException e) {
            this.logger.error("getAccountMap faild:" + (Object)((Object)e));
        }
        Collection refList = this.refMng.getItems(new String[]{"OIS"});
        if (refList.size() == 0) {
            this.logger.error("\u65b0\u80a1\u7533\u8d2d, OIS\u6570\u636e\u4e3a\u7a7a");
        }
        for (RefItem item : refList) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u65b0\u80a1\u7533\u8d2d")) continue;
            mapXbondRef.put(bond.getCode(), bond);
        }
        this.refMng.doneProperty().addListener(this.listenerRefMng);
        this.es.subscribe("new.day.requery.data", event -> {
            this.refdone = false;
            mapApplyLimit.clear();
            this.refLimit();
        });
    }

    private void refLimit() {
        if (this.refdone) {
            return;
        }
        this.refdone = true;
        this.logger.info("ref data changed : new stock trade");
        mapXbondRef.clear();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u65b0\u80a1\u7533\u8d2d")) continue;
            mapXbondRef.put(bond.getCode(), bond);
        }
        this.exe.execute(() -> this.initLimit());
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
    }

    public void initLimit() {
        enList.clear();
        mapSecurityEntrustList.clear();
        done = false;
        long start = System.currentTimeMillis();
        HashMap<String, Long> mapCommonLimit = new HashMap<String, Long>();
        HashMap<String, Long> mapInnovateLimit = new HashMap<String, Long>();
        for (ConvertibleBond bond : mapXbondRef.values()) {
            System.err.println(">>>>>>>>>> code: " + bond.getCode() + "  " + this.mapSecDisMxList.size());
            for (String fundAccId : this.mapSecDisMxList.keySet()) {
                System.err.println(">>>>>>>>>> strEach: " + fundAccId);
                for (CcsAccountDistribution subItem : ((MxTreeList)this.mapSecDisMxList.get(fundAccId)).getOrList()) {
                    if (!subItem.getSecAcc().getExchange().getRaw().equals(bond.getMarket())) continue;
                    String secAccId = subItem.getSecAcc().getExtSecAccntId();
                    System.err.println(">>>>>>>>>> extSecAccntId: " + secAccId);
                    try {
                        String key = String.valueOf(bond.getCode()) + bond.getMarket() + fundAccId + secAccId;
                        PCashService.ApplyLimit limit = mapApplyLimit.get(key);
                        if (limit != null) continue;
                        limit = this.api.getSubLine(bond.getCode(), bond.getMarket(), fundAccId, secAccId);
                        if (limit == null) {
                            limit = PCashService.ApplyLimit.newBuilder().build();
                        }
                        mapApplyLimit.put(key, limit);
                        long count = (long)limit.getMaxAmount();
                        if (bond.getCode().startsWith("787")) {
                            count = (long)limit.getInnovateAmount();
                            mapInnovateLimit.put(key, count);
                        } else {
                            mapCommonLimit.put(key, count);
                        }
                        double upLimit = bond.getQtyUpperLimit();
                        if ((double)count > upLimit) {
                            count = (long)upLimit;
                        }
                        mapLimit.put(key, count);
                        if (count <= 0L) continue;
                        CcsSingleEntrust en = this.ef.createCcsSingle(fundAccId, subItem.getSecAcc().getExtSecAccntId());
                        en.setSec(bond.getCode());
                        en.setSecName(bond.getName());
                        en.setFundAccount((FundAccount)this.map.get(fundAccId));
                        en.setSecAccount(subItem.getSecAcc());
                        en.setInvestorId(this.map.get(fundAccId).getInvestId());
                        en.setInvestorSecId(subItem.getSecAcc().getInverstorSecId());
                        en.setSide(201);
                        en.setQuantity(count);
                        en.setCanSell(count);
                        en.setMarket(bond.getMarket());
                        en.setSecType(bond.getType());
                        en.setPrice(bond.getSubPrice());
                        en.setOrderType(50);
                        en.setAppID("130");
                        enList.add(en);
                        if (mapSecurityEntrustList.get(bond.getCode()) == null) {
                            mapSecurityEntrustList.put(bond.getCode(), new ArrayList());
                        }
                        mapSecurityEntrustList.get(bond.getCode()).add(en);
                    }
                    catch (MException e) {
                        this.logger.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        this.logger.error("\u67e5\u8be2\u6240\u6709\u8d26\u53f7\u7684\u7533\u8d2d\u989d\u5ea6\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        this.logger.error("\u975e\u79d1\u521b\u677f\u989d\u5ea6 mapLimit:" + mapCommonLimit);
        this.logger.error("\u79d1\u521b\u677f\u989d\u5ea6 mapInnovateLimit" + mapInnovateLimit);
        done = true;
    }

    public void clearSelect(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setSelected(false);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setSelected(false);
            }
        });
    }

    public void clearCanBuySell(TreeItem<CcsAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((CcsAccountDistribution)each.getValue()).setCanBuy(0L);
            ((CcsAccountDistribution)each.getValue()).setCanSell(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((CcsAccountDistribution)sub.getValue()).setCanBuy(0L);
                ((CcsAccountDistribution)sub.getValue()).setCanSell(0L);
                ((CcsAccountDistribution)sub.getValue()).getNewStockAuth().clear();
            }
        });
    }

    public void calAccountCanSell() {
        if (!done) {
            return;
        }
        Platform.runLater(() -> {
            for (String funAccId : this.mapSecDisMxList.keySet()) {
                long canSellTotal = 0L;
                NewStockAuth authTotal = null;
                NewStockAuth noAuthTotal = null;
                for (TreeItem subItem : ((MxTreeList)this.mapSecDisMxList.get(funAccId)).getObList()) {
                    String secAccId = ((CcsAccountDistribution)subItem.getValue()).getSecAcc().getExtSecAccntId();
                    String key = String.valueOf(this.getSecurity()) + this.getMarket() + funAccId + secAccId;
                    Long count = mapLimit.get(key);
                    if (count == null) {
                        count = 0L;
                    }
                    ((CcsAccountDistribution)subItem.getValue()).setCanSell(count.longValue());
                    canSellTotal += count.longValue();
                    NewStockAuth auth = ((CcsAccountDistribution)subItem.getValue()).getNewStockAuth();
                    auth.checkAuth(this.getRefItem(), ((CcsAccountDistribution)subItem.getValue()).getSecAcc());
                    if (auth.isAuth()) {
                        authTotal = auth;
                    } else {
                        noAuthTotal = auth;
                    }
                    ((CcsAccountDistribution)subItem.getValue()).setDisable(!auth.isAuth());
                }
                for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                    if (!accItem.getAcc().getExtAccntId().equals(funAccId)) continue;
                    accItem.setCanSell(canSellTotal);
                    accItem.setNewStockAuth(authTotal != null ? authTotal : noAuthTotal);
                    if (accItem.getNewStockAuth() == null) continue;
                    accItem.setDisable(!accItem.getNewStockAuth().isAuth());
                }
            }
            this.changed();
        });
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    public final boolean isActive() {
        return this.activeProperty().get();
    }

    public final void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }
}

