/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.stock.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.RationedStock;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.stock.entrust.StockEntrustFactory;
import cms.tmx.stock.entrust.StockSingleEntrust;
import cms.tmx.stock.models.RationedStockAcctDistModel;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.CcsTradeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionRationedStockModel
extends MxModel {
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    protected DoubleProperty money = new SimpleDoubleProperty();
    private StringProperty tradeType = new SimpleStringProperty();
    private final int INIT_UNIT = 100;
    protected static final Logger logger = LogManager.getLogger(CcsTradeModel.class);
    protected RefItem refItem;
    private ObjectProperty<Instruction> instruction = new SimpleObjectProperty((Object)new Instruction());
    private String postil = "";
    @Inject
    protected StockEntrustFactory ef;
    @Inject
    protected RationedStockAcctDistModel accTreeModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    private MObjFactory of;
    protected Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    protected Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private ResourceModel resModel;
    public boolean overLimit = false;

    @PostConstruct
    public void init() {
        this.setTradeType("OIS");
        this.accTreeModel.securityProperty().bind((ObservableValue)this.security);
        this.accTreeModel.buyProperty().bind((ObservableValue)this.buy);
        this.accTreeModel.setCountStg("1");
        MxNode node = MxNodeFactory.createNew((String)"acc_dist_mode", (String)"1");
        this.setDistStg(node);
        this.accTreeModel.setDistStg("1");
        node = MxNodeFactory.create((String)"price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        node = MxNodeFactory.create((String)"acc_count_filter", (String)"1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        ((CcsAccountDistribution)this.accTreeModel.getRoot().getValue()).countProperty().bind((ObservableValue)this.count);
        this.price.addListener(ob -> this.onPriceChange());
        this.accTreeModel.priceProperty().bind((ObservableValue)this.price);
        this.accTreeModel.moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.accTreeModel.percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.accTreeModel.changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public RefItem getRefItem() {
        return this.refItem;
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    public void onSecChange1() {
        this.setCount(0L);
        this.setPrice(0.0);
        this.setRefItem(this.getValidRef());
        this.filterAcc();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
    }

    private void onCountChange() {
        if (this.getCount() == 0L) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
    }

    private void onMoneyChange() {
        if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        long total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public String getLimitOrMarket() {
        return this.isLimitPrice() ? "\u9650\u4ef7" : "\u5e02\u4ef7";
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            this.removeOthers(node, "1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef1() {
        if (this.getRefItem() == null) {
            return false;
        }
        if (this.getRefItem().getType().isEmpty()) {
            return false;
        }
        if (this.getTradeType().equals("CCS")) {
            return true;
        }
        return this.getRefItem().getType().equals(this.getTradeType());
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    protected int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond1() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") && this.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return false;
    }

    protected boolean isCountOrSell() {
        return true;
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public RationedStockAcctDistModel getAccDisModel() {
        return this.accTreeModel;
    }

    public void create(String instructType) {
        this.getAccDisModel().setInstructPanelType(instructType);
        try {
            this.getAccDisModel().create();
        }
        catch (MException | Exception e) {
            logger.error("\u521b\u5efa\u8d26\u53f7\u6811\u51fa\u9519", e);
        }
    }

    protected void onPriceChange() {
        if (this.isCountOrSell()) {
            this.getAccDisModel().calCanBuy();
            return;
        }
        if (this.getPrice() == 0.0) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
    }

    protected void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell((TreeItem<CcsAccountDistribution>)this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            this.changed();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanBuy();
        this.getAccDisModel().filterAcc();
        this.exe.execute(() -> this.getAccDisModel().calAccountCanSell());
    }

    public void onSecChange() {
        RationedStock bond = (RationedStock)this.getValidRef();
        if (bond != null) {
            this.getAccDisModel().setMarket(bond.getMarket());
            this.setName(bond.getName());
        } else {
            this.setName("");
        }
        this.onSecChange1();
        this.changeSHBondCvt();
    }

    protected void changeMarketPriceType() {
    }

    private void changeSHBondCvt() {
        this.accTreeModel.setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getMarket().equals("XSHG");
    }

    public synchronized ObservableList<Boolean> submit(List<CcsSingleEntrust> list) {
        ObservableList returnList = FxUtils.newList();
        for (CcsSingleEntrust en : list) {
            try {
                en.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public synchronized ObservableList<Boolean> submitAdvice() throws MException {
        ObservableList returnList = FxUtils.newList();
        for (OrderAdvice oa : this.getOrderAdvices()) {
            try {
                InstructionSubmitResult submitResult = oa.submit();
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
                returnList.add((Object)true);
            }
            catch (MException e) {
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)e, "");
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public ObservableList<Boolean> submitApprove(Instruction instruction) throws MException {
        ObservableList returnList = FxUtils.newList();
        try {
            this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
            returnList.add((Object)true);
        }
        catch (MException mException) {
            returnList.add((Object)false);
        }
        return returnList;
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public List<OrderAdvice> getOrderAdvices() throws MException {
        LinkedList<OrderAdvice> adviceList = new LinkedList<OrderAdvice>();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            OrderAdvice oa = (OrderAdvice)this.of.create(OrderAdvice.class);
            AppointedTraderSetting traderSetting = this.fundTraderMap.get(((CcsAccountDistribution)acc.getValue()).getAcc());
            String expiredDate = this.insExpiredMap.get(((CcsAccountDistribution)acc.getValue()).getAcc());
            if (traderSetting != null) {
                oa.setTraderUserIds(traderSetting.getAppointedTraderIds());
            }
            oa.setInsExpiredDate(expiredDate);
            oa.setInstructionPanelType(this.getAccDisModel().getInstructType());
            oa.setSide(84);
            oa.setAccntLevel(0);
            oa.setMarket(this.getRefItem().getMarket());
            oa.setSec(this.getRefItem().getCode());
            oa.setSecType(this.getRefItem().getType());
            oa.setSubSecType("RATIONED");
            oa.setSecName(this.getRefItem().getName());
            oa.setProductId(this.accountService.getAccountById(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getProductId());
            List stepList = this.instrAccModel.getWorkflow(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getSteps();
            if (stepList != null && !stepList.isEmpty()) {
                for (AccntStepAttribute step : stepList) {
                    if (1 != step.getStepId()) continue;
                    oa.setFlowAttriId(step.getFlowAttriId());
                    oa.setStepAttrId(step.getStepAttriId());
                    break;
                }
            }
            oa.setInstructionType(2);
            if ("50".equals(this.getPriceStg().getRaw())) {
                oa.setOrdType(50);
                oa.setPriceLimit(2);
                oa.setPrice(this.getPrice());
            }
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSec = new AccntSecInfo();
                accntSec.setAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId());
                accntSec.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                accntSec.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSec.setParentId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                accntSec.setMarket(this.getRefItem().getMarket());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount();
                accntSecList.add(accntSec);
            }
            oa.setAccSecInfoList(accntSecList);
            oa.setOrderQty(orderQty);
            oa.setPostil(this.postil);
            oa.setAmount(this.getMoney(oa));
            if (accntSecList.isEmpty()) continue;
            adviceList.add(oa);
        }
        return adviceList;
    }

    private double getMoney(OrderAdvice item) {
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getOrderQty() * item.getPrice() * 10.0;
        }
        return (double)item.getOrderQty() * item.getPrice();
    }

    public synchronized ObservableList<Boolean> submit(TreeItem<CcsAccountDistribution> root) {
        ObservableList returnList = FxUtils.newList();
        LinkedList<StockSingleEntrust> enList = new LinkedList<StockSingleEntrust>();
        for (TreeItem treeItem : root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : treeItem.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                StockSingleEntrust en = this.createEntrust(((CcsAccountDistribution)treeItem.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setSide(84);
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setMarket(this.getRefItem().getMarket());
                en.setSecType(this.getRefItem().getType());
                en.setSubSecType("RATIONED");
                en.setOrderType(50);
                en.setPrice(this.getPrice());
                en.setSec(this.getRefItem().getCode());
                en.setAppID("131");
                enList.add(en);
            }
        }
        for (CcsSingleEntrust ccsSingleEntrust : enList) {
            try {
                if (this.instruction.get() != null) {
                    ccsSingleEntrust.setInstructionId(((Instruction)this.instruction.get()).getId());
                    if (!((Instruction)this.instruction.get()).getId().isEmpty()) {
                        Resource resource = this.resModel.getResource((Instruction)this.instruction.get());
                        if (resource == null) {
                            returnList.add((Object)false);
                            continue;
                        }
                        ccsSingleEntrust.setResourceId(resource.getId());
                        ccsSingleEntrust.setOrdQuantityCapacity(((Instruction)this.instruction.get()).getOrderAdvice().getOrderQty());
                    }
                }
                ccsSingleEntrust.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public List<CcsSingleEntrust> getEntrustList() {
        this.overLimit = false;
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                StockSingleEntrust en = this.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                en.setSide(84);
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                en.setMarket(this.getRefItem().getMarket());
                en.setSecType(this.getRefItem().getType());
                en.setPrice(this.getPrice());
                if (((CcsAccountDistribution)secAcc.getValue()).getCount() > ((CcsAccountDistribution)secAcc.getValue()).getCanSell()) {
                    if ("1".equals(this.getAccDisModel().getInstructType()) || "2".equals(this.getAccDisModel().getInstructType()) || "0".equals(this.getAccDisModel().getInstructType())) {
                        en.setTip("\u8d85\u8fc7\u53ef\u7533\u8d2d\u989d\u5ea6");
                    }
                    this.overLimit = true;
                }
                if (this.getPriceStg().getRaw().equals("50")) {
                    en.setOrderType(50);
                }
                en.setSec(this.getRefItem().getCode());
                en.setSecName(this.getRefItem().getName());
                en.setAppID("010");
                enList.add(en);
            }
        }
        return enList;
    }

    public StockSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createStockSingle(acc, secAcc);
    }

    public boolean isValidRef() {
        if (this.getRefItem() == null) {
            return false;
        }
        if (this.getRefItem().getType().isEmpty()) {
            return false;
        }
        if (this.getTradeType().equals("OIS")) {
            return true;
        }
        return this.getRefItem().getType().equals(this.getTradeType());
    }

    public RefItem getValidRef() {
        RefItem item = this.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        if (this.getTradeType().equals("OIS")) {
            return item;
        }
        if (item.getType().equals(this.getTradeType())) {
            return item;
        }
        return null;
    }

    public boolean isLimitPrice() {
        return false;
    }

    public final ObjectProperty<Instruction> instructionProperty() {
        return this.instruction;
    }

    public final Instruction getInstruction() {
        return (Instruction)this.instructionProperty().get();
    }

    public final void setInstruction(Instruction instruction) {
        this.instructionProperty().set((Object)instruction);
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }
}

