/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.workflow.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.workflow.dto.CompleteTaskNewReq;
import cms.tmx.http.workflow.dto.GetWorkflowTasksReq;
import cms.tmx.http.workflow.dto.TaskLog;
import cms.tmx.http.workflow.dto.WorkflowTaskListNew;
import cms.tmx.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WorkflowServiceApi
extends HttpService {
    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/workflow/api";
    }

    public Map<String, WorkflowTaskListNew> getWorkflowCurrentTasksNew(List<String> workflowIds) throws MException {
        HashMap<String, WorkflowTaskListNew> resMap = new HashMap<String, WorkflowTaskListNew>();
        for (String flowId : workflowIds) {
            if (StringUtils.isEmpty((String)flowId)) continue;
            GetWorkflowTasksReq req = new GetWorkflowTasksReq();
            req.setUserId(this.httpBaseApi.getHttpOpUser().getUserId());
            req.setPostId(this.httpBaseApi.getHttpOpUser().getPostId());
            req.setWorkflowIds(Arrays.asList(flowId));
            String resp = this.doPostWithUrl("/workflows/tasks/actions/query", this.gson.toJson((Object)req), String.valueOf(this.url) + "/workflows/tasks/actions/query");
            List tasksResp = (List)this.gson.fromJson(resp, new TypeToken<List<WorkflowTaskListNew>>(){}.getType());
            if (tasksResp == null) {
                return resMap;
            }
            for (WorkflowTaskListNew tasks : tasksResp) {
                if (tasks == null) continue;
                resMap.put(tasks.getWorkflowId(), tasks);
            }
        }
        return resMap;
    }

    public void cancelWorkflowNew(List<CompleteTaskNewReq> req) throws MException {
        String resp = this.doPostWithUrl("/workflows/finishTasks", this.gson.toJson(req), String.valueOf(this.url) + "/workflows/finishTasks");
        if (resp == null) {
            logger.error("\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
            throw new MException(999994, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25");
        }
    }

    public String complateTaskNew(List<CompleteTaskNewReq> req) throws MException {
        String resp = this.doPostWithUrl("/workflows/completeTasks", this.gson.toJson(req), String.valueOf(this.url) + "/workflows/completeTasks");
        return resp;
    }

    public void recordTaskLog(TaskLog req) throws MException {
        this.doPostWithUrl("/workflows/tasks/logs", this.gson.toJson((Object)req), String.valueOf(this.url) + "/workflows/tasks/logs");
    }
}

