/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RespResult {
    private AtomicInteger successedTimes = new AtomicInteger(0);
    private AtomicInteger failedTimes = new AtomicInteger(0);
    private List<String> listDesc = new LinkedList<String>();

    public String getDesc(String operation) {
        StringBuilder result = new StringBuilder();
        result.append(operation);
        result.append("\u6210\u529f").append(this.successedTimes.get()).append("\u7b14");
        result.append("\uff0c\u5931\u8d25").append(this.failedTimes.get()).append("\u7b14 ");
        this.listDesc.forEach(desc -> result.append("\n").append((String)desc));
        return result.toString();
    }

    public String getFailedDesc(String operation) {
        StringBuilder result = new StringBuilder();
        result.append(operation);
        result.append("\u5931\u8d25").append(this.failedTimes.get()).append("\u7b14 ");
        this.listDesc.forEach(desc -> result.append("\n").append((String)desc));
        return result.toString();
    }

    public void addDesc(String desc) {
        this.listDesc.add(desc);
    }

    public void incrementSuccessed() {
        this.successedTimes.incrementAndGet();
    }

    public void incrementFailed(String desc) {
        this.failedTimes.incrementAndGet();
        if (desc != null && !desc.isEmpty()) {
            this.addDesc(desc);
        }
    }

    public boolean hasFailed() {
        return this.failedTimes.get() > 0;
    }
}

