/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.update.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.update.dto.AddVersionReq;
import cms.tmx.http.update.dto.CheckVersionResp;
import cms.tmx.http.update.dto.GetVersionInfoResp;
import cms.tmx.http.update.dto.GetVersionInfosReq;
import cms.tmx.http.update.dto.Member;
import cms.tmx.http.update.dto.UpdateMembersReq;
import cms.tmx.http.update.dto.VersionInfo;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UpdateApi
extends HttpService {
    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/updates";
    }

    public List<VersionInfo> getVersionInfos(GetVersionInfosReq req) throws MException {
        String respBody = this.doGet(String.valueOf(this.url) + "/versionInfos/" + req.getBeginDate() + "/" + req.getEndDate());
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        Type type = new TypeToken<ArrayList<VersionInfo>>(){}.getType();
        List resp = (List)this.gson.fromJson(respBody, type);
        return resp;
    }

    public void deleteVersionInfos(String versionId) throws MException {
        String respBody = this.doDeleteWithUrl("delete version", "", String.valueOf(this.url) + "/versionInfos/" + versionId);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
    }

    public VersionInfo getVersionInfosById(String versionId) throws MException {
        String respBody = this.doGet(String.valueOf(this.url) + "/versionInfos/" + versionId);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        GetVersionInfoResp resp = (GetVersionInfoResp)this.gson.fromJson(respBody, GetVersionInfoResp.class);
        return resp.getVersionInfo();
    }

    public VersionInfo updateVersionInfos(AddVersionReq req) throws MException {
        String respBody = this.doPutWithUrl("update versionInfo", this.gson.toJson((Object)req), String.valueOf(this.url) + "/versionInfos/" + req.getVersionInfo().getVersionId());
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        GetVersionInfoResp resp = (GetVersionInfoResp)this.gson.fromJson(respBody, GetVersionInfoResp.class);
        return resp.getVersionInfo();
    }

    public VersionInfo addVersionInfos(AddVersionReq req) throws MException {
        String respBody = this.doPostWithUrl("add versionInfo", this.gson.toJson((Object)req), String.valueOf(this.url) + "/versionInfos");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        VersionInfo resp = (VersionInfo)this.gson.fromJson(respBody, VersionInfo.class);
        return resp;
    }

    public List<Member> getMembersExcludes() throws MException {
        String respBody = this.doGet(String.valueOf(this.url) + "/members/excludes");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        Type type = new TypeToken<ArrayList<Member>>(){}.getType();
        List resp = (List)this.gson.fromJson(respBody, type);
        return resp;
    }

    public void updateMembersExcludes(UpdateMembersReq req) throws MException {
        String respBody = this.doPutWithUrl("update Members Excludes", this.gson.toJson((Object)req), String.valueOf(this.url) + "/members/excludes");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
    }

    public List<Member> getMembersIncludes(String versionId) throws MException {
        String respBody = this.doGet(String.valueOf(this.url) + "/members/includes/" + versionId);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        Type type = new TypeToken<ArrayList<Member>>(){}.getType();
        List resp = (List)this.gson.fromJson(respBody, type);
        return resp;
    }

    public void updateMembersIncludes(UpdateMembersReq req, String versionId) throws MException {
        String respBody = this.doPutWithUrl("update Members Includes", this.gson.toJson((Object)req), String.valueOf(this.url) + "/members/includes/" + versionId);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
    }

    public CheckVersionResp checkVersion(String version, String mac) throws MException {
        String respBody = this.doGet(String.valueOf(this.url) + "/" + version + "/" + mac);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        CheckVersionResp resp = (CheckVersionResp)this.gson.fromJson(respBody, CheckVersionResp.class);
        return resp;
    }
}

