/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.statement.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.GetUnderlyingSecuritysReq;
import cms.tmx.http.query.margin.GetUnderlyingSecuritysResp;
import cms.tmx.http.query.margin.UnderlyingSecurityQuery;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UnderlyingSecurityApi
extends HttpService {
    @Inject
    private HttpBaseApi httpBase;
    private Gson gson = new Gson();

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/collateral/CollateralService";
    }

    public List<UnderlyingSecurityQuery> getUnderlyingSecurityList(String market) throws MException {
        LinkedList<UnderlyingSecurityQuery> list = new LinkedList<UnderlyingSecurityQuery>();
        GetUnderlyingSecuritysReq req = new GetUnderlyingSecuritysReq();
        Page httpDefPage = this.httpBase.getHttpDefPage();
        req.setOpUser(this.httpBase.getHttpOpUser());
        if (!market.isEmpty()) {
            req.setMarket(market);
        }
        boolean flag = false;
        do {
            req.setPage(httpDefPage);
            String json = this.gson.toJson((Object)req);
            String respBody = this.doPost("GetUnderlyingSecurity", json);
            GetUnderlyingSecuritysResp resp = new GetUnderlyingSecuritysResp();
            if (respBody == null) break;
            resp = (GetUnderlyingSecuritysResp)this.gson.fromJson(respBody, GetUnderlyingSecuritysResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getUnderlyingSecurity() == null) break;
            list.addAll(resp.getUnderlyingSecurity());
            boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
            if (!flag) continue;
            httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
        } while (flag);
        if (!list.isEmpty()) {
            list.forEach(item -> item.setExtraFields());
        }
        return list;
    }
}

