/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.statement.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.query.GetBalanceSheetReq;
import cms.tmx.http.query.GetBalanceSheetResp;
import cms.tmx.http.query.GetCreditContractReq;
import cms.tmx.http.query.GetCreditContractResp;
import cms.tmx.http.query.Sofp;
import com.google.gson.Gson;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class StatementServiceApi
extends HttpService {
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi httpBase;
    private static final Logger logger = LogManager.getLogger(StatementServiceApi.class);

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/statement/StatementService";
    }

    public Sofp GetBalanceSheetReq(String extAccntId, String marketGrp) {
        Sofp sofp = null;
        try {
            GetBalanceSheetReq req = new GetBalanceSheetReq();
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarketGrp(marketGrp);
            req.setCashAccntId(extAccntId);
            String json = this.gson.toJson((Object)req);
            logger.info("\u878d\u8d44\u878d\u5238\u8d44\u91d1\u5e74\u5229\u7387\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
            String respBody = this.doPost("GetBalanceSheet", json);
            logger.info("\u878d\u8d44\u878d\u5238\u8d44\u91d1\u5e74\u5229\u7387\u67e5\u8be2\u7ed3\u679c\uff1a", (Object)respBody);
            GetBalanceSheetResp resp = new GetBalanceSheetResp();
            if (respBody == null) {
                return sofp;
            }
            resp = (GetBalanceSheetResp)this.gson.fromJson(respBody, GetBalanceSheetResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getSofp() == null) {
                return sofp;
            }
            sofp = resp.getSofp();
        }
        catch (MException e) {
            logger.error("\u878d\u8d44\u878d\u5238\u8d44\u91d1\u5e74\u5229\u7387\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        return sofp;
    }

    public GetCreditContractResp getContractList(GetCreditContractReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        logger.info("\u878d\u8d44\u878d\u5238\u5408\u7ea6\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
        String respBody = this.doPost("GetCreditContract", json);
        logger.info("\u878d\u8d44\u878d\u5238\u5408\u7ea6\u67e5\u8be2\u54cd\u5e94\uff1a", (Object)respBody);
        GetCreditContractResp resp = (GetCreditContractResp)this.gson.fromJson(respBody, GetCreditContractResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }
}

