/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.statement.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.statement.api.OtcQueryProductReq;
import cms.tmx.http.statement.api.OtcQueryProductResp;
import cms.tmx.http.statement.api.OtcSignProductReq;
import cms.tmx.http.statement.api.OtcSignProductResp;
import com.google.gson.Gson;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class RouterServiceApi
extends HttpService {
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi httpBase;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/router";
    }

    public String signProduct(OtcSignProductReq req) throws Exception, MException {
        req.setSignType("O");
        req.setMarketCode("8");
        req.setOpUser(this.httpBase.getHttpOpUser());
        String json = this.gson.toJson((Object)req);
        logger.info("\u573a\u5916\u57fa\u91d1\u7b7e\u7f72\u534f\u8bae\u8bf7\u6c42" + json);
        String respBody = this.doPostWithUrl("signProduct", json, String.valueOf(this.url) + "/sign_product");
        logger.info("\u573a\u5916\u57fa\u91d1\u7b7e\u7f72\u534f\u8bae\u54cd\u5e94" + respBody);
        OtcSignProductResp resp = (OtcSignProductResp)this.gson.fromJson(respBody, OtcSignProductResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getSignId();
    }

    public boolean queryProduct(OtcQueryProductReq req) throws Exception, MException {
        req.setMarket("8");
        req.setOpUser(this.httpBase.getHttpOpUser());
        String json = this.gson.toJson((Object)req);
        logger.info("\u573a\u5916\u57fa\u91d1\u67e5\u8be2\u534f\u8bae\u8bf7\u6c42" + json);
        String respBody = this.doPostWithUrl("queryProduct", json, String.valueOf(this.url) + "/query_product");
        logger.info("\u573a\u5916\u57fa\u91d1\u67e5\u8be2\u534f\u8bae\u54cd\u5e94" + respBody);
        OtcQueryProductResp resp = (OtcQueryProductResp)this.gson.fromJson(respBody, OtcQueryProductResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.isNeedSign();
    }
}

