/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.statement.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.GetPledgeSecuritysReq;
import cms.tmx.http.query.margin.GetPledgeSecuritysQueryResp;
import cms.tmx.http.query.margin.PledgeSecurityQuery;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PledgeSecurityApi
extends HttpService {
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi httpBase;
    private static final Logger logger = LogManager.getLogger(PledgeSecurityApi.class);

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/collateral/CollateralService";
    }

    public List<PledgeSecurityQuery> getPledgeList(String market) {
        LinkedList<PledgeSecurityQuery> list = new LinkedList<PledgeSecurityQuery>();
        try {
            GetPledgeSecuritysReq req = new GetPledgeSecuritysReq();
            Page httpDefPage = this.httpBase.getHttpDefPage();
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarket(market);
            boolean flag = false;
            do {
                req.setPage(httpDefPage);
                String json = this.gson.toJson((Object)req);
                String respBody = this.doPost("GetPledgeSecurity", json);
                GetPledgeSecuritysQueryResp resp = new GetPledgeSecuritysQueryResp();
                if (respBody == null) {
                    return list;
                }
                resp = (GetPledgeSecuritysQueryResp)this.gson.fromJson(respBody, GetPledgeSecuritysQueryResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getPledgeSecurity() == null) {
                    return list;
                }
                list.addAll(resp.getPledgeSecurity());
                boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
                if (!flag) continue;
                httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
            } while (flag);
        }
        catch (MException e) {
            logger.error("\u62c5\u4fdd\u8bc1\u5238\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        return list;
    }
}

