/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.settlement.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.settlement.dto.ExecuteSettleReq;
import cms.tmx.http.settlement.dto.GetSettleStepReq;
import cms.tmx.http.settlement.dto.GetSettleStepResp;
import cms.tmx.http.settlement.dto.GetSettleSystemStatusReq;
import cms.tmx.http.settlement.dto.GetSettleSystemStatusResp;
import cms.tmx.utils.StringUtils;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ClearingNewServiceApi
extends HttpService {
    @Override
    @PostConstruct
    protected void init() {
        super.init();
    }

    public String clearRunStep(ExecuteSettleReq request) throws MException {
        String body = this.gson.toJson((Object)request);
        String url1 = String.valueOf(this.url) + "/execute";
        logger.info("\u6267\u884c\u6e05\u7b97\u8bf7\u6c42" + body);
        String respBody = this.doPostWithUrl("ExecuteSettleReq", body, url1);
        logger.info("\u6267\u884c\u6e05\u7b97\u7ed3\u679c" + respBody);
        OpStatus resp = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        OpStatus status = new OpStatus();
        status.setStatus(resp.getStatus());
        if (!StringUtils.isEmpty((String)resp.getReason())) {
            status.setReason(resp.getReason());
        } else {
            switch (resp.getStatus()) {
                case 0: {
                    status.setReason("kUndefined");
                    break;
                }
                case 1: {
                    status.setReason("kCodeSucc");
                    break;
                }
                case 11: {
                    status.setReason("last step not finish");
                    break;
                }
                case 12: {
                    status.setReason("curr step still running");
                    break;
                }
                case 13: {
                    status.setReason("curr step is disabled");
                    break;
                }
            }
            logger.info("\u6267\u884c\u6e05\u7b97\u7ed3\u679c\u7ecf\u8fc7\u5ba2\u6237\u7aef\u6e05\u7b97\u6b65\u9aa4\u9519\u8bef\u7801\u89e3\u6790" + respBody + status.getMessage());
        }
        this.checkStatus(status);
        return status.getReason();
    }

    public GetSettleStepResp clearQueryStepInfo(GetSettleStepReq request) throws MException {
        String body = this.gson.toJson((Object)request);
        String url1 = String.valueOf(this.url) + "/settleSteps";
        logger.info("\u6e05\u7b97\u6b65\u9aa4\u8bf7\u6c42" + body);
        String respBody = this.doPostWithUrl("GetSettleStepReq", body, url1);
        logger.info("\u6e05\u7b97\u6b65\u9aa4\u7ed3\u679c" + respBody);
        GetSettleStepResp resp = (GetSettleStepResp)this.gson.fromJson(respBody, GetSettleStepResp.class);
        OpStatus status = resp.getStatus();
        this.checkStatus(status);
        return resp;
    }

    public GetSettleSystemStatusResp clearQuerySysStatus(GetSettleSystemStatusReq request) throws MException {
        String body = this.gson.toJson((Object)request);
        String url1 = String.valueOf(this.url) + "/settleStatus";
        logger.info("\u6e05\u7b97\u7cfb\u7edf\u72b6\u6001\u8bf7\u6c42" + body);
        String respBody = this.doPostWithUrl("GetSettleSystemStatusReq ", body, url1);
        logger.info("\u6e05\u7b97\u7cfb\u7edf\u72b6\u6001\u7ed3\u679c" + respBody);
        GetSettleSystemStatusResp resp = (GetSettleSystemStatusResp)this.gson.fromJson(respBody, GetSettleSystemStatusResp.class);
        OpStatus status = resp.getStatus();
        this.checkStatus(status);
        return resp;
    }
}

