/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.security.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.data.FundInfo;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.security.api.GetSecuritysReq;
import cms.tmx.http.security.api.GetSecuritysResp;
import cms.tmx.http.security.dto.BondInfo;
import cms.tmx.http.security.dto.ForwardInfo;
import cms.tmx.http.security.dto.FutureInfo;
import cms.tmx.http.security.dto.PledgeInfo;
import cms.tmx.http.security.dto.RepoInfo;
import cms.tmx.http.security.dto.StockInfo;
import cms.tmx.http.security.dto.XBondInfo;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class SecurityServiceImpl
extends HttpService {
    private static final int OFFSET = 0;
    private static final int LIMIT = 500;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/security";
    }

    public List<StockInfo> getInstrument(String market, String type) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<StockInfo> list = new LinkedList<StockInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/instruments/" + market + "/" + type + "?" + this.packParam(request)), GetSecuritysResp.class)).getStock() != null) {
                list.addAll(resp.getStock());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<StockInfo> getStocks(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<StockInfo> list = new LinkedList<StockInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/stocks/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getStock() != null) {
                list.addAll(resp.getStock());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<BondInfo> getBonds(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<BondInfo> list = new LinkedList<BondInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/bonds/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getBond() != null) {
                list.addAll(resp.getBond());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<XBondInfo> getXBonds(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<XBondInfo> list = new LinkedList<XBondInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/xbonds?" + this.packParam(request)), GetSecuritysResp.class)).getXbond() != null) {
                list.addAll(resp.getXbond());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<ForwardInfo> getForwards(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<ForwardInfo> list = new LinkedList<ForwardInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/Forwards/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getForward() != null) {
                list.addAll(resp.getForward());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<FundInfo> getFunds(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<FundInfo> list = new LinkedList<FundInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/funds/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getFund() != null) {
                list.addAll(resp.getFund());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<IssueInfo> getIssues(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<IssueInfo> list = new LinkedList<IssueInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/issues/CB/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getIssue() != null) {
                list.addAll(resp.getIssue());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<RepoInfo> getRepos(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<RepoInfo> list = new LinkedList<RepoInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/repos/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getRepo() != null) {
                list.addAll(resp.getRepo());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<IssueInfo> getNewStocks(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<IssueInfo> list = new LinkedList<IssueInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/issues/STOCK/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getIssue() != null) {
                list.addAll(resp.getIssue());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<PledgeInfo> getPledges(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<PledgeInfo> list = new LinkedList<PledgeInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/pledges/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getPledge() != null) {
                list.addAll(resp.getPledge());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<BondInfo> getFixed() throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<BondInfo> list = new LinkedList<BondInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/fixedIncomeBonds?" + this.packParam(request)), GetSecuritysResp.class)).getBond() != null) {
                list.addAll(resp.getBond());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    public List<FutureInfo> getFutures(String market) throws MException {
        GetSecuritysReq request = new GetSecuritysReq();
        request.setOffset(0);
        request.setLimit(500);
        LinkedList<FutureInfo> list = new LinkedList<FutureInfo>();
        GetSecuritysResp resp = null;
        do {
            String respBody;
            if ((resp = (GetSecuritysResp)this.gson.fromJson(respBody = this.doGet(String.valueOf(this.url) + "/futures/" + market + "?" + this.packParam(request)), GetSecuritysResp.class)).getFuture() != null) {
                list.addAll(resp.getFuture());
            }
            request.setOffset(resp.getOffset());
        } while (resp != null && resp.getTotal() > resp.getOffset());
        return list;
    }

    private String packParam(GetSecuritysReq obj) {
        try {
            Field[] fields;
            StringBuffer param = new StringBuffer();
            Field[] fieldArray = fields = obj.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                if (field.get(obj) != null) {
                    param.append(field.getName()).append("=").append(field.get(obj)).append("&");
                }
                ++n2;
            }
            if (param.toString().contains("&")) {
                param.delete(param.length() - 1, param.length());
            }
            return param.toString();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("\u9759\u6001\u884c\u60c5\u67e5\u8be2\u53c2\u6570\u7ec4\u5305\u5931\u8d25", (Throwable)e);
            return "";
        }
    }
}

